/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import com.sun.javafx.runtime.FXBase;
import com.sun.javafx.runtime.FXObject;
import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.annotation.JavafxSignature;
import javafx.animation.KeyValueTarget;

public class Pointer
implements KeyValueTarget {
    private final KeyValueTarget.Type type;
    private final FXObject obj;
    private final int varnum;

    @JavafxSignature(value="(Ljava/lang/Object;)Lcom/sun/javafx/runtime/Pointer;")
    public static Pointer make(KeyValueTarget.Type type, FXObject obj, int varnum) {
        return new Pointer(type, obj, varnum);
    }

    public static boolean equals(Pointer p1, Pointer p2) {
        return p1 == null ? p2 == null : p1.equals(p2);
    }

    private Pointer(KeyValueTarget.Type type, FXObject obj, int varnum) {
        this.type = type;
        this.obj = obj;
        this.varnum = varnum;
    }

    public Object getDefaultValue() {
        switch (this.type) {
            case BYTE: {
                return (byte)0;
            }
            case SHORT: {
                return (short)0;
            }
            case INTEGER: {
                return 0;
            }
            case LONG: {
                return 0L;
            }
            case FLOAT: {
                return Float.valueOf(0.0f);
            }
            case DOUBLE: {
                return 0.0;
            }
            case BOOLEAN: {
                return false;
            }
            case SEQUENCE: {
                return TypeInfo.Object.emptySequence;
            }
            case OBJECT: {
                return null;
            }
        }
        return null;
    }

    public FXObject getFXObject() {
        return this.obj;
    }

    public int getVarNum() {
        return this.varnum;
    }

    public KeyValueTarget.Type getType() {
        return this.type;
    }

    public Pointer unwrap() {
        return this;
    }

    public Object get() {
        return this.obj != null ? this.obj.get$(this.varnum) : this.getDefaultValue();
    }

    public Object get(int pos) {
        assert (this.type == KeyValueTarget.Type.SEQUENCE) : "expecting a sequence type";
        return this.obj != null ? this.obj.elem$(this.varnum, pos) : null;
    }

    public void set(Object value) {
        if (this.obj != null) {
            this.obj.set$(this.varnum, value);
        }
    }

    public void set(int pos, Object value) {
        assert (this.type == KeyValueTarget.Type.SEQUENCE) : "expecting a sequence type";
        if (this.obj != null) {
            this.obj.set$(this.varnum, value);
        }
    }

    public int size() {
        assert (this.type == KeyValueTarget.Type.SEQUENCE) : "expecting a sequence type";
        return this.obj != null ? this.obj.size$(this.varnum) : 0;
    }

    public Object getValue() {
        return this.get();
    }

    public void setValue(Object o) {
        this.set(o);
    }

    public boolean equals(Object o) {
        if (o instanceof Pointer) {
            Pointer other = (Pointer)o;
            return this.obj == other.obj && this.varnum == other.varnum;
        }
        return false;
    }

    public int hashCode() {
        return System.identityHashCode(this.obj) ^ this.varnum;
    }

    public void addDependency(FXObject dep) {
        if (this.obj != null) {
            this.obj.addDependent$(this.varnum, dep, 0);
        }
    }

    public void removeDependency(FXObject dep) {
        if (this.obj != null) {
            this.obj.removeDependent$(this.varnum, dep);
        }
    }

    public static void switchDependence(Pointer oldPtr, Pointer newPtr, FXObject dep, int depNum) {
        if (oldPtr != newPtr && dep != null) {
            FXObject oldSrc = oldPtr != null ? oldPtr.getFXObject() : null;
            FXObject newSrc = newPtr != null ? newPtr.getFXObject() : null;
            int oldVarNum = oldPtr != null ? oldPtr.getVarNum() : 0;
            int newVarNum = newPtr != null ? newPtr.getVarNum() : 0;
            dep.switchDependence$(oldSrc, oldVarNum, newSrc, newVarNum, depNum);
        }
    }

    public BoundPointer bind(Pointer srcPtr) {
        final FXObject thisObj = this.getFXObject();
        final int thisVarNum = this.getVarNum();
        final int srcVarNum = srcPtr.getVarNum();
        FXBase listener = new FXBase(){

            public boolean update$(FXObject src, int depNum, int startPos, int endPos, int newLength, int phase) {
                if ((phase & 8) == 8 && thisObj != null) {
                    thisObj.set$(thisVarNum, src.get$(srcVarNum));
                }
                return true;
            }
        };
        this.set(thisVarNum, srcPtr.get());
        srcPtr.addDependency(listener);
        return new BoundPointer(this, srcPtr, listener);
    }

    public static class BoundPointer
    extends Pointer {
        private Pointer srcPtr;
        private FXObject listener;

        private BoundPointer(Pointer destPtr, Pointer srcPtr, FXObject listener) {
            super(destPtr.getType(), destPtr.getFXObject(), destPtr.getVarNum());
            this.srcPtr = srcPtr;
            this.listener = listener;
        }

        public void unbind() {
            this.srcPtr.removeDependency(this.listener);
            this.srcPtr = null;
            this.listener = null;
        }
    }
}

