/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericTypeInfo<T extends Number>
extends TypeInfo<T> {
    public NumericTypeInfo(T defaultValue, TypeInfo.Types type) {
        super(defaultValue, type);
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    public long longValue(T value) {
        return ((Number)value).longValue();
    }

    public int intValue(T value) {
        return ((Number)value).intValue();
    }

    public short shortValue(T value) {
        return ((Number)value).shortValue();
    }

    public byte byteValue(T value) {
        return ((Number)value).byteValue();
    }

    public double doubleValue(T value) {
        return ((Number)value).doubleValue();
    }

    public float floatValue(T value) {
        return ((Number)value).floatValue();
    }

    public T[] makeArray(int size) {
        return Util.newNumberArray((int)size);
    }

    public <V extends Number> T asPreferred(NumericTypeInfo<V> otherType, V otherValue) {
        switch (this.type) {
            case INT: {
                return (T)java.lang.Integer.valueOf(otherType.intValue(otherValue));
            }
            case SHORT: {
                return (T)java.lang.Short.valueOf(otherType.shortValue(otherValue));
            }
            case BYTE: {
                return (T)java.lang.Byte.valueOf(otherType.byteValue(otherValue));
            }
            case LONG: {
                return (T)java.lang.Long.valueOf(otherType.longValue(otherValue));
            }
            case FLOAT: {
                return (T)java.lang.Float.valueOf(otherType.floatValue(otherValue));
            }
            case DOUBLE: {
                return (T)java.lang.Double.valueOf(otherType.doubleValue(otherValue));
            }
        }
        throw new IllegalArgumentException();
    }
}

