/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import com.sun.javafx.runtime.Entry;
import com.sun.javafx.runtime.FXObject;
import com.sun.javafx.runtime.LauncherHelper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class Main {
    private static final String MAIN_CLASS_PREFIX = "MainJavaFXScript=";

    private static String getErrorMessage(String key, Object ... args) {
        return LauncherHelper.getLocalizedMessage("javafx.launcher.err.main." + key, args);
    }

    public static void main(String[] args) {
        String[] argsToMain;
        if (args.length == 0) {
            Main.errorExit(LauncherHelper.getHelpMessage().toString());
        }
        if ((argsToMain = new String[args.length - 1]).length != 0) {
            System.arraycopy(args, 1, argsToMain, 0, argsToMain.length);
        }
        Class<?> mainClass = null;
        String mclassname = args[0];
        try {
            if (mclassname.endsWith(".jar")) {
                mclassname = Main.getMainClass(mclassname);
            } else if (mclassname.startsWith(MAIN_CLASS_PREFIX)) {
                mclassname = mclassname.substring(mclassname.indexOf(61) + 1);
            }
            mainClass = Class.forName(mclassname, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException cnfe) {
            Main.errorExit(Main.getErrorMessage("notfound", mclassname), cnfe);
        }
        catch (IOException ioe) {
            Main.errorExit(Main.getErrorMessage("loadfailed", mclassname), ioe);
        }
        if (FXObject.class.isAssignableFrom(mainClass)) {
            try {
                Entry.start(mainClass, argsToMain);
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        } else {
            Method mainMethod = null;
            try {
                mainMethod = mainClass.getMethod("main", String[].class);
            }
            catch (Exception exp) {
                Main.errorExit(Main.getErrorMessage("nomethod", mainClass));
            }
            try {
                mainMethod.invoke(null, new Object[]{argsToMain});
            }
            catch (Exception exp) {
                Main.errorExit("", exp);
            }
        }
    }

    private static void errorExit(String msg) {
        Main.errorExit(msg, null);
    }

    private static void errorExit(String msg, Exception exp) {
        System.err.println(msg);
        if (exp != null) {
            exp.printStackTrace();
        }
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getMainClass(String jarfilename) throws IOException {
        String mainclassname;
        Attributes attr;
        JarFile jf = new JarFile(jarfilename);
        Manifest mf = jf.getManifest();
        if (mf != null && (attr = mf.getMainAttributes()) != null && (mainclassname = attr.getValue("Main-Class")) != null) {
            String string = mainclassname;
            return string;
        }
        String msg = Main.getErrorMessage("notfound", Main.getErrorMessage("reason", jarfilename));
        Main.errorExit(msg, new IOException("Main-Class not found in " + jarfilename));
        String string = null;
        return string;
        finally {
            if (jf != null) {
                try {
                    jf.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

