/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import com.sun.javafx.runtime.SystemProperties;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LauncherHelper {
    INSTANCE;

    private static final String myname = "javafx";
    private static final String defaultBundleName = "com.sun.javafx.runtime.resources.launcher";
    private static ResourceBundle javafxrb;

    private static void printVersion(boolean fullversion) {
        StringBuilder sb = new StringBuilder("javafx ");
        if (fullversion) {
            sb = sb.append("full version ");
            sb = sb.append("\"");
            sb = sb.append(SystemProperties.getProperty("javafx.runtime.version"));
            sb = sb.append("\"");
        } else {
            sb = sb.append(SystemProperties.getProperty("javafx.version"));
        }
        System.err.println(sb.toString());
        System.err.flush();
    }

    static synchronized String getLocalizedMessage(String key, Object ... args) {
        if (javafxrb == null) {
            javafxrb = ResourceBundle.getBundle(defaultBundleName);
        }
        String msg = javafxrb.getString(key);
        return args != null ? MessageFormat.format(msg, args) : msg;
    }

    static StringBuilder getHelpMessage() {
        StringBuilder outBuf = new StringBuilder();
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("javafx.launcher.opt.header", myname));
        outBuf = outBuf.append("\n");
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("javafx.launcher.opt.datamodel", 32, LauncherHelper.getLocalizedMessage("javafx.launcher.ifavailable", new Object[0])));
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("javafx.launcher.opt.datamodel", 64, LauncherHelper.getLocalizedMessage("javafx.launcher.ifavailable", new Object[0])));
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("javafx.launcher.opt.vmselect", "-client", "client", LauncherHelper.getLocalizedMessage("javafx.launcher.ifavailable", new Object[0])));
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("javafx.launcher.opt.vmselect", "-server", "server", LauncherHelper.getLocalizedMessage("javafx.launcher.ifavailable", new Object[0])));
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("javafx.launcher.opt.footer", File.pathSeparator));
        return outBuf;
    }

    private static void printHelpMessage() {
        System.err.println(LauncherHelper.getHelpMessage().toString());
        System.err.flush();
    }

    static void printHelpMessageX() {
        StringBuilder outBuf = new StringBuilder();
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("javafx.launcher.X.usage", File.pathSeparator));
        System.err.println(outBuf.toString());
        System.err.flush();
    }

    public static void main(String ... args) {
        if (args.length > 0) {
            if (args[0].equals("-fullversion")) {
                LauncherHelper.printVersion(true);
            } else if (args[0].equals("-version")) {
                LauncherHelper.printVersion(false);
            } else if (args[0].endsWith("-helpx")) {
                LauncherHelper.printHelpMessageX();
            } else {
                LauncherHelper.printHelpMessage();
            }
        }
    }

    static {
        javafxrb = null;
    }
}

