/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import com.sun.javafx.runtime.FXObject;
import com.sun.javafx.runtime.annotation.JavafxBindees;
import com.sun.javafx.runtime.sequence.Sequence;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FXDOTWriter {
    static final String FONTDEFAULTS = "fontname=Helvetica, fontcolor=black, fontsize=10";
    static final String GRAPHDEFAULTS = "fontname=Helvetica, fontcolor=black, fontsize=10, rankdir=LR";
    static final String NODEDEFAULTS = "fontname=Helvetica, fontcolor=black, fontsize=10, label=\"\\N\", shape=record, style=filled, fillcolor=lightgrey, color=black";
    static final String EDGEDEFAULTS = "fontname=Helvetica, fontcolor=black, fontsize=10, arrowhead=open";
    static final String STARTNODESTYLE = "fillcolor=pink";
    static final String INTRAEDGESTYLE = "style=dashed, color=grey";
    static final String INTEREDGESTYLE = "style=dashed, color=darkGrey";
    private int objectLimit = 256;
    private int fieldLimit = 64;
    private int arrayLimit = 32;
    private int stringLimit = 32;
    private Map<Object, Node> visited = new IdentityHashMap<Object, Node>();
    Map<Class, Field[]> fieldCache = new HashMap<Class, Field[]>();
    Map<Class, FXField[]> fxFieldCache = new HashMap<Class, FXField[]>();
    private Properties graphProperties = new Properties();
    private Properties nodeProperties = new Properties();
    private Properties edgeProperties = new Properties();
    private List<Node> nodes = new ArrayList<Node>();
    private List<Edge> edges = new ArrayList<Edge>();
    private PrintStream dotStream;
    private boolean filtering = false;
    private Set<Object> includeObjects = new HashSet<Object>();
    private Set<Object> excludeObjects = new HashSet<Object>();
    private List<Class> includeClasses = new ArrayList<Class>();
    private List<Class> excludeClasses = new ArrayList<Class>();
    private boolean expandCollections = false;
    private boolean expandFXObjects = false;
    private boolean displayStatics = false;
    private boolean displayLinks = true;
    private boolean displayIntraDependencies = true;
    private boolean displayInterDependencies = true;
    private boolean displayFXFlags = false;

    public FXDOTWriter(String fileName) {
        try {
            this.dotStream = new PrintStream(fileName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.graphProperties.addProperties(GRAPHDEFAULTS);
        this.nodeProperties.addProperties(NODEDEFAULTS);
        this.edgeProperties.addProperties(EDGEDEFAULTS);
    }

    public static void graph(String fileName, Object ... objects) {
        FXDOTWriter writer = new FXDOTWriter(fileName);
        String propertyString = STARTNODESTYLE;
        for (Object object : objects) {
            if (object instanceof String) {
                propertyString = (String)object;
                continue;
            }
            writer.addNode(propertyString, object);
        }
        writer.close();
    }

    public void addNodes(Object ... objects) {
        String propertyString = null;
        for (Object object : objects) {
            if (object instanceof String) {
                propertyString = (String)object;
                continue;
            }
            this.addNode(propertyString, object);
        }
    }

    public void addNode(String propertyString, Object object) {
        if (object == null) {
            return;
        }
        if (this.isPrimitive(object)) {
            return;
        }
        Node newNode = this.getNode(object);
        for (int index = this.nodes.size(); index < this.nodes.size(); ++index) {
            Node node = this.nodes.get(index);
            object = node.object;
            Class<?> clazz = object.getClass();
            this.addHeader(object, clazz, node);
            if (clazz.isArray()) {
                if (index < this.arrayLimit && this.shouldDetail(object)) {
                    this.addArrayDetail(object, node);
                    continue;
                }
                this.addContinuation(node);
                continue;
            }
            if (index < this.objectLimit && this.shouldDetail(object)) {
                if (!this.expandFXObjects && object instanceof FXObject) {
                    this.addFXObjectDetail(object, clazz, node);
                    continue;
                }
                if (!this.expandFXObjects && object instanceof Sequence) {
                    this.addSequenceDetail(object, clazz, node);
                    continue;
                }
                if (!this.expandCollections && object instanceof Collection) {
                    this.addCollectionDetail(object, clazz, node);
                    continue;
                }
                if (!this.expandCollections && object instanceof Map) {
                    this.addMapDetail(object, clazz, node);
                    continue;
                }
                if (this.displayStatics && object instanceof Class) {
                    this.addClassDetail(object, clazz, node);
                    continue;
                }
                this.addObjectDetail(object, clazz, node);
                continue;
            }
            this.addContinuation(node);
        }
        if (propertyString != null) {
            newNode.addProperties(propertyString);
        }
    }

    public void objectLimit(int objectLimit) {
        this.objectLimit = objectLimit;
    }

    public void fieldLimit(int fieldLimit) {
        this.fieldLimit = fieldLimit;
    }

    public void arrayLimit(int arrayLimit) {
        this.arrayLimit = arrayLimit;
    }

    public void stringLimit(int stringLimit) {
        this.stringLimit = stringLimit;
    }

    public void expandCollections(boolean expandCollections) {
        this.expandCollections = expandCollections;
    }

    public void expandFXObjects(boolean expandFXObjects) {
        this.expandFXObjects = expandFXObjects;
    }

    public void displayFXFlags(boolean displayFXFlags) {
        this.displayFXFlags = displayFXFlags;
    }

    public void displayStatics(boolean displayStatics) {
        this.displayStatics = displayStatics;
    }

    public void displayLinks(boolean displayLinks) {
        this.displayLinks = displayLinks;
    }

    public void displayIntraDependencies(boolean displayIntraDependencies) {
        this.displayIntraDependencies = displayIntraDependencies;
    }

    public void displayInterDependencies(boolean displayInterDependencies) {
        this.displayInterDependencies = displayInterDependencies;
    }

    public void includeObjects(Object ... objects) {
        for (Object object : objects) {
            this.includeObjects.add(object);
        }
        this.filtering = true;
    }

    public void excludeObjects(Object ... objects) {
        for (Object object : objects) {
            this.excludeObjects.add(object);
        }
        this.filtering = true;
    }

    public void includeClasses(Class ... clazzes) {
        for (Class clazz : clazzes) {
            this.includeClasses.add(clazz);
        }
        this.filtering = true;
    }

    public void excludeClasses(Class ... clazzes) {
        for (Class clazz : clazzes) {
            this.excludeClasses.add(clazz);
        }
        this.filtering = true;
    }

    public void addEdge(Object head, Object tail) {
        this.addEdge(head, -1, tail, -1, null);
    }

    public void addEdge(Object head, Object tail, String propertyString) {
        this.addEdge(head, -1, tail, -1, propertyString);
    }

    public void addEdge(Object head, int headFieldId, Object tail, int tailFieldId) {
        this.addEdge(head, headFieldId, tail, tailFieldId, null);
    }

    public void addEdge(Object head, int headFieldId, Object tail, int tailFieldId, String propertyString) {
        this.addEdge(this.getNode(head), headFieldId, this.getNode(tail), tailFieldId, propertyString);
    }

    private void addEdge(Node head, int headFieldId, Node tail, int tailFieldId) {
        this.addEdge(head, headFieldId, tail, tailFieldId, null);
    }

    public void close() {
        if (this.dotStream != null) {
            this.writeGraph();
            this.dotStream.close();
            this.dotStream = null;
        }
    }

    private boolean isPrimitive(Object object) {
        return object.getClass().isPrimitive() || object instanceof Number || object instanceof Boolean || object instanceof String;
    }

    private void writeGraph() {
        this.dotStream.println("digraph g {");
        this.dotStream.print(" graph ");
        this.graphProperties.writeProperties(this.dotStream);
        this.dotStream.println(";");
        this.dotStream.print(" node ");
        this.nodeProperties.writeProperties(this.dotStream);
        this.dotStream.println(";");
        this.dotStream.print(" edge ");
        this.edgeProperties.writeProperties(this.dotStream);
        this.dotStream.println(";");
        for (Node node : this.nodes) {
            this.dotStream.print(" node" + node.id + " ");
            node.writeProperties(this.dotStream);
            this.dotStream.println(";");
        }
        for (Edge edge : this.edges) {
            this.dotStream.print(" node" + edge.head.id + (edge.headFieldId < 0 ? ":f" : ":f" + edge.headFieldId));
            this.dotStream.print(" -> ");
            this.dotStream.print(" node" + edge.tail.id + (edge.tailFieldId < 0 ? ":f" : ":f" + edge.tailFieldId));
            this.dotStream.print(" ");
            edge.writeProperties(this.dotStream);
            this.dotStream.println(";");
        }
        this.dotStream.println("}");
    }

    private Node getNode(Object object) {
        if (object == null) {
            return null;
        }
        Node node = null;
        try {
            node = this.visited.get(object);
        }
        catch (Throwable ex) {
            return null;
        }
        if (node == null) {
            node = new Node(this.nodes.size(), object);
            this.nodes.add(node);
            this.visited.put(object, node);
        }
        return node;
    }

    private boolean shouldDetail(Object object) {
        if (object == this) {
            return false;
        }
        if (!this.filtering) {
            return true;
        }
        if (!this.includeObjects.isEmpty()) {
            return this.includeObjects.contains(object);
        }
        if (!this.includeClasses.isEmpty()) {
            for (Class clazz : this.includeClasses) {
                if (!clazz.isInstance(object)) continue;
                return true;
            }
            return false;
        }
        if (!this.excludeObjects.isEmpty() && this.excludeObjects.contains(object)) {
            return false;
        }
        if (!this.excludeClasses.isEmpty()) {
            for (Class clazz : this.excludeClasses) {
                if (!clazz.isInstance(object)) continue;
                return false;
            }
        }
        return true;
    }

    private void addEdge(Node head, int headFieldId, Node tail, int tailFieldId, String propertyString) {
        if (head == null || tail == null) {
            return;
        }
        if (headFieldId > this.getLimit(head) && head.id >= this.objectLimit) {
            headFieldId = -1;
        }
        if (tailFieldId > this.getLimit(tail) && tail.id >= this.objectLimit) {
            tailFieldId = -1;
        }
        Edge edge = new Edge(this.edges.size(), head, headFieldId, tail, tailFieldId);
        if (propertyString != null) {
            edge.addProperties(propertyString);
        }
        this.edges.add(edge);
    }

    private int getLimit(Node node) {
        return node.object.getClass().isArray() ? this.arrayLimit : this.fieldLimit;
    }

    private String getClassName(Class clazz) {
        String name = clazz.getCanonicalName();
        if (name == null) {
            name = clazz.getName();
        }
        if (name == null) {
            name = clazz.getSimpleName();
        }
        return name;
    }

    private void addHeader(Object object, Class clazz, Node node) {
        if (this.displayStatics && object instanceof Class) {
            clazz = (Class)object;
        }
        String className = this.getClassName(clazz);
        if (object instanceof FXObject) {
            className = className + "(FX)";
        } else if (object instanceof Class) {
            className = className + "(Class)";
        }
        node.addProperty("label", "<f> " + className);
    }

    private void addContinuation(Node node) {
        node.extendProperty("label", " | ...");
    }

    private Object getValue(Field field, Object object) {
        Object value = null;
        try {
            value = field.get(object);
        }
        catch (Throwable ex) {
            // empty catch block
        }
        return value;
    }

    private int getIntValue(Field field, Object object) {
        int value = 0;
        try {
            value = field.getInt(object);
        }
        catch (Throwable ex) {
            // empty catch block
        }
        return value;
    }

    private Field[] getFields(Class clazz) {
        if (clazz == null) {
            return new Field[0];
        }
        if (this.displayStatics && clazz == Class.class) {
            return new Field[0];
        }
        Field[] fields = this.fieldCache.get(clazz);
        if (fields != null) {
            return fields;
        }
        Field[] superFields = this.getFields(clazz.getSuperclass());
        Field[] classFields = clazz.getDeclaredFields();
        fields = new Field[superFields.length + classFields.length];
        System.arraycopy(superFields, 0, fields, 0, superFields.length);
        System.arraycopy(classFields, 0, fields, superFields.length, classFields.length);
        this.fieldCache.put(clazz, fields);
        return fields;
    }

    private void addObjectDetail(Object object, Class clazz, Node node) {
        Field[] fields = this.getFields(clazz);
        if (this.displayStatics && fields.length != 0) {
            this.addEdge(node, -1, this.getNode(clazz), -1);
        }
        for (int index = 0; index < fields.length && index < this.fieldLimit; ++index) {
            Field field = fields[index];
            if ((field.getModifiers() & 8) != 0) continue;
            field.setAccessible(true);
            String name = field.getName();
            Object value = this.getValue(field, object);
            Format format = new Format(value);
            this.addNodeField(node, name, index, format.string);
            if (!this.displayLinks || format.isSimple) continue;
            this.addEdge(node, index, this.getNode(value), -1);
        }
        if (fields.length >= this.fieldLimit) {
            this.addContinuation(node);
        }
    }

    private void addClassDetail(Object object, Class clazz, Node node) {
        Field[] fields = this.getFields((Class)object);
        for (int index = 0; index < fields.length && index < this.fieldLimit; ++index) {
            Field field = fields[index];
            if ((field.getModifiers() & 8) == 0) continue;
            field.setAccessible(true);
            String name = field.getName();
            Object value = this.getValue(field, object);
            Format format = new Format(value);
            this.addNodeField(node, name, index, format.string);
            if (!this.displayLinks || format.isSimple) continue;
            this.addEdge(node, index, this.getNode(value), -1);
        }
        if (fields.length >= this.fieldLimit) {
            this.addContinuation(node);
        }
    }

    private FXField[] getFXFields(Object object, Class clazz) {
        Class<?> enclosing;
        FXField[] fxFields = this.fxFieldCache.get(clazz);
        if (fxFields != null) {
            return fxFields;
        }
        Field[] fields = this.getFields(clazz);
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        ArrayList<FXField> fxFieldList = new ArrayList<FXField>();
        if (this.getClassName(clazz).endsWith("$Script") && (enclosing = clazz.getEnclosingClass()) != null) {
            for (Field field : this.getFields(enclosing)) {
                if ((field.getModifiers() & 8) == 0) continue;
                fieldMap.put(field.getName(), field);
            }
        }
        for (Field field : fields) {
            String name = field.getName();
            fieldMap.put(name, field);
            if (!name.startsWith("VOFF$") || (field.getModifiers() & 8) == 0) continue;
            String varName = name.substring("VOFF$".length() - 1);
            String className = this.getClassName(field.getDeclaringClass()).replaceAll("\\.", "\\$");
            String simpleClassName = field.getDeclaringClass().getSimpleName();
            String bareName = varName.startsWith(className, 1) ? varName.substring(className.length() + 2) : (varName.startsWith(simpleClassName, 1) ? varName.substring(simpleClassName.length() + 2) : varName.substring(1));
            int voff = this.getIntValue(field, null);
            FXField fxField = new FXField(bareName, varName, voff, null);
            fxFieldList.add(fxField);
        }
        int count = fxFieldList.size();
        fxFields = new FXField[count];
        for (int index = 0; index < count; ++index) {
            FXField fxField = (FXField)fxFieldList.get(index);
            try {
                fxField.field = (Field)fieldMap.get(fxField.varName);
                fxField.bindees = fxField.field.getAnnotation(JavafxBindees.class).value();
                fxField.flags = ((Field)fieldMap.get("VFLG" + fxField.varName)).getInt(object);
            }
            catch (Throwable ex) {
                // empty catch block
            }
            fxFields[index] = fxField;
        }
        this.fxFieldCache.put(clazz, fxFields);
        return fxFields;
    }

    private FXField findField(FXField[] fxFields, String varName) {
        for (FXField fxField : fxFields) {
            if (!varName.equals(fxField.varName)) continue;
            return fxField;
        }
        return null;
    }

    private void addFXObjectDetail(Object object, Class clazz, Node node) {
        FXField[] fxFields = this.getFXFields(object, clazz);
        for (int index = 0; index < fxFields.length && index < this.fieldLimit; ++index) {
            String bindees;
            FXField fxField = fxFields[index];
            Field field = fxField.field;
            field.setAccessible(true);
            String name = fxField.name;
            Object value = this.getValue(field, object);
            if (this.displayFXFlags) {
                name = name + " (0x" + Integer.toHexString(fxField.flags) + ")";
            }
            Format format = new Format(value);
            this.addNodeField(node, name, fxField.voff, format.string);
            if (this.displayLinks && !format.isSimple) {
                this.addEdge(node, fxField.voff, this.getNode(value), -1);
            }
            if ((bindees = fxField.bindees) == null || !this.displayIntraDependencies && !this.displayInterDependencies) continue;
            for (String bindee : bindees.split(",")) {
                Object selector;
                String[] pair = bindee.split("\\.");
                FXField bindField = this.findField(fxFields, pair[0]);
                if (pair.length == 1) {
                    if (!this.displayIntraDependencies) continue;
                    this.addEdge(node, bindField.voff, node, fxField.voff, INTRAEDGESTYLE);
                    continue;
                }
                if (!this.displayInterDependencies || (selector = this.getValue(bindField.field, object)) == null) continue;
                FXField[] selectorFxFields = this.getFXFields(selector, selector.getClass());
                FXField selectorField = this.findField(selectorFxFields, pair[1]);
                this.addEdge(this.getNode(selector), selectorField.voff, node, fxField.voff, INTEREDGESTYLE);
            }
        }
        if (fxFields.length >= this.fieldLimit) {
            this.addContinuation(node);
        }
    }

    private void addSequenceDetail(Object object, Class clazz, Node node) {
        Sequence seq = (Sequence)object;
        int size = Math.min(seq.size(), this.arrayLimit + 1);
        Object[] array = new Object[size];
        seq.toArray(0, size, array, 0);
        this.addArrayDetail(array, node);
    }

    private void addCollectionDetail(Object object, Class clazz, Node node) {
        Object[] array = ((Collection)object).toArray();
        this.addArrayDetail(array, node);
    }

    private void addMapDetail(Object object, Class clazz, Node node) {
        Object[] array = ((Map)object).entrySet().toArray();
        this.addArrayDetail(array, node);
    }

    private void addArrayDetail(Object object, Node node) {
        int length = Array.getLength(object);
        if (object instanceof char[] || object instanceof byte[] && this.allASCII((byte[])object)) {
            Format format = new Format(object);
            String string = " | " + format.string;
            node.extendProperty("label", string);
            length = 0;
        } else {
            for (int index = 0; index < length && index < this.arrayLimit; ++index) {
                Object value = Array.get(object, index);
                Format format = new Format(value);
                this.addNodeField(node, null, index, format.string);
                if (!this.displayLinks || format.isSimple) continue;
                this.addEdge(node, index, this.getNode(value), -1);
            }
        }
        if (length >= this.arrayLimit) {
            this.addContinuation(node);
        }
    }

    private void addNodeField(Node node, String fieldName, int fieldId, String valueString) {
        String labelString = " | ";
        labelString = labelString + "<f" + fieldId + "> ";
        if (fieldName != null) {
            labelString = labelString + fieldName + ": ";
        }
        labelString = labelString + valueString;
        node.extendProperty("label", labelString);
    }

    private String formatString(String string, String quote) {
        boolean isLong;
        boolean bl = isLong = string.length() > this.stringLimit;
        if (isLong) {
            string = string.substring(0, this.stringLimit - 1);
        }
        string = quote + string + quote;
        if (isLong) {
            string = string + "...";
        }
        return string;
    }

    private static String escapeString(String value) {
        if (FXDOTWriter.needsEscape(value)) {
            StringBuilder result = new StringBuilder();
            result.append('\"');
            StringCharacterIterator iterator = new StringCharacterIterator(value);
            char ch = iterator.current();
            while (ch != '\uffff') {
                if (ch == '\"' || ch == '\'' || ch == '{' || ch == '}' || ch == '[' || ch == ']') {
                    result.append('\\');
                    result.append(ch);
                } else if (ch < ' ' || ch > '~') {
                    result.append("\\\\u");
                    String hex = "0000" + Integer.toHexString(ch);
                    hex = hex.substring(hex.length() - 4);
                    result.append(hex);
                } else {
                    result.append(ch);
                }
                ch = iterator.next();
            }
            result.append('\"');
            value = result.toString();
        }
        return value;
    }

    private static boolean needsEscape(String value) {
        if (value.length() > 0 && value.charAt(0) == '\"') {
            return false;
        }
        StringCharacterIterator iterator = new StringCharacterIterator(value);
        char ch = iterator.current();
        while (ch != '\uffff') {
            if (!Character.isJavaIdentifierPart(ch) && ch != '-') {
                return true;
            }
            ch = iterator.next();
        }
        return false;
    }

    private boolean allASCII(byte[] array) {
        for (byte b : array) {
            char ch = (char)b;
            if (ch >= ' ' || '~' >= ch) continue;
            return false;
        }
        return false;
    }

    static class Edge
    extends Element {
        Node head;
        int headFieldId;
        Node tail;
        int tailFieldId;

        Edge(int id, Node head, int headFieldId, Node tail, int tailFieldId) {
            super(id);
            this.head = head;
            this.headFieldId = headFieldId;
            this.tail = tail;
            this.tailFieldId = tailFieldId;
        }
    }

    static class Element
    extends Properties {
        int id;

        Element(int id) {
            this.id = id;
        }
    }

    class FXField {
        static final String voffPrefix = "VOFF$";
        static final String vflgPrefix = "VFLG";
        String name;
        String varName;
        int voff;
        int flags;
        Field field;
        String bindees;

        FXField(String name, String varName, int voff, Field field) {
            this.name = name;
            this.varName = varName;
            this.voff = voff;
        }
    }

    class Format {
        String string = "";
        boolean isSimple = true;

        Format(Object value) {
            if (value == null) {
                this.string = this.string + value;
                this.isSimple = false;
            } else if (value instanceof String) {
                this.string = FXDOTWriter.this.formatString((String)value, "\"");
            } else if (value instanceof char[]) {
                this.string = FXDOTWriter.this.formatString(new String((char[])value), "'");
            } else if (value instanceof byte[] && FXDOTWriter.this.allASCII((byte[])value)) {
                this.string = FXDOTWriter.this.formatString(new String((byte[])value), "'");
            } else if (value instanceof Character) {
                Character character = (Character)value;
                this.string = "'" + character + "'";
            } else if (!FXDOTWriter.this.expandCollections && value instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)value;
                Format keyFormat = new Format(entry.getKey());
                Format valueFormat = new Format(entry.getValue());
                if (!keyFormat.isSimple) {
                    this.isSimple = false;
                } else {
                    this.string = keyFormat.string + "-\\>";
                    if (valueFormat.isSimple) {
                        this.string = this.string + valueFormat.string;
                    } else {
                        this.isSimple = false;
                    }
                }
            } else if (FXDOTWriter.this.isPrimitive(value)) {
                this.string = this.string + value;
            } else {
                this.isSimple = false;
            }
        }
    }

    static class Node
    extends Element {
        Object object;

        Node(int id, Object object) {
            super(id);
            this.object = object;
        }
    }

    static class Properties {
        private Map<String, String> properties = new HashMap<String, String>();

        Properties() {
        }

        void addProperty(String key, String value) {
            this.properties.put(key, value);
        }

        void addProperties(String propertyString) {
            String[] kvs;
            for (String kv : kvs = propertyString.split("\\s*,\\s*")) {
                String[] pair = kv.split("\\s*=\\s*");
                if (pair.length == 1) {
                    this.properties.put(pair[0], "true");
                    continue;
                }
                this.properties.put(pair[0], pair[1]);
            }
        }

        void extendProperty(String key, String extension) {
            String value = this.getProperty(key);
            if (value == null) {
                value = "";
            }
            value = value + extension;
            this.addProperty(key, value);
        }

        String getProperty(String key) {
            return this.properties.get(key);
        }

        void writeProperties(PrintStream dotStream) {
            if (!this.properties.isEmpty()) {
                dotStream.print("[");
                String comma = "";
                for (String key : this.properties.keySet()) {
                    String value = this.properties.get(key);
                    if (value.equals("true")) {
                        dotStream.print(comma + key);
                    } else {
                        dotStream.print(comma + key + "=" + FXDOTWriter.escapeString(value));
                    }
                    comma = ", ";
                }
                dotStream.print("]");
            }
        }
    }
}

