/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import com.sun.javafx.runtime.Dep;
import com.sun.javafx.runtime.DepChain;
import com.sun.javafx.runtime.ErrorHandler;
import com.sun.javafx.runtime.FXObject;
import com.sun.javafx.runtime.WeakBinderRef;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DependentsManager {
    public static void addDependent(FXObject bindee, int varNum, FXObject binder, int depNum) {
        Dep dep = Dep.newDependency(binder, depNum);
        dep.linkToBindee(bindee, varNum);
        WeakBinderRef.checkForCleanups();
    }

    public static void removeDependent(FXObject bindee, int varNum, FXObject binder) {
        DepChain chain = DepChain.find(varNum, bindee.getDepChain$internal$());
        if (chain == null) {
            return;
        }
        Dep prev = null;
        WeakBinderRef binderRef = WeakBinderRef.instance(binder);
        Dep dep = binderRef.bindees;
        while (dep != null) {
            Dep next = dep.nextInBindees;
            if (dep.chain == chain) {
                if (prev == null) {
                    binderRef.bindees = next;
                } else {
                    prev.nextInBindees = next;
                }
                dep.unlinkFromBindee();
                return;
            }
            prev = dep;
            dep = next;
        }
    }

    public static void switchDependence(FXObject binder, FXObject oldBindee, int oldNum, FXObject newBindee, int newNum, int depNum) {
        if (oldBindee != null) {
            oldBindee.removeDependent$(oldNum, binder);
        }
        if (newBindee != null) {
            newBindee.addDependent$(newNum, binder, depNum);
        }
    }

    public static void notifyDependents(FXObject bindee, int varNum, int startPos, int endPos, int newLength, int phase) {
        DepChain chain = DepChain.find(varNum, bindee.getDepChain$internal$());
        if (chain == null) {
            return;
        }
        Dep dep = chain.dependencies;
        while (dep != null) {
            Dep next = dep.nextInBinders;
            WeakBinderRef binderRef = dep.binderRef;
            if (binderRef != null) {
                FXObject binder = (FXObject)binderRef.get();
                if (binder == null) {
                    binderRef.cleanup();
                } else {
                    boolean handled = true;
                    try {
                        handled = binder.update$(bindee, dep.depNum, startPos, endPos, newLength, phase);
                    }
                    catch (RuntimeException re) {
                        ErrorHandler.bindException(re);
                    }
                    if (!handled) {
                        Dep prev = null;
                        Dep d = binderRef.bindees;
                        while (d != null) {
                            Dep nextInBindees = d.nextInBindees;
                            if (d == dep) {
                                if (prev == null) {
                                    binderRef.bindees = nextInBindees;
                                } else {
                                    prev.nextInBindees = nextInBindees;
                                }
                                dep.unlinkFromBindee();
                                break;
                            }
                            prev = d;
                            d = nextInBindees;
                        }
                    }
                }
            }
            dep = next;
        }
    }

    public static int getListenerCount(FXObject bindee) {
        return DependentsManager.getListenerCount(bindee.getDepChain$internal$());
    }

    private static int getListenerCount(DepChain chain) {
        if (chain == null) {
            return 0;
        }
        int count = 0;
        Dep dep = chain.dependencies;
        while (dep != null) {
            WeakBinderRef binderRef = dep.binderRef;
            if (binderRef != null && binderRef.get() != null) {
                ++count;
            }
            dep = dep.nextInBinders;
        }
        return count + DependentsManager.getListenerCount(chain.child0) + DependentsManager.getListenerCount(chain.child1);
    }

    public static List<FXObject> getDependents(FXObject bindee) {
        ArrayList<FXObject> res = new ArrayList<FXObject>();
        DependentsManager.getDependents(bindee.getDepChain$internal$(), res);
        return res;
    }

    private static void getDependents(DepChain chain, List<FXObject> res) {
        if (chain == null) {
            return;
        }
        Dep dep = chain.dependencies;
        while (dep != null) {
            WeakBinderRef binderRef = dep.binderRef;
            if (binderRef != null && binderRef.get() != null) {
                res.add((FXObject)binderRef.get());
            }
            dep = dep.nextInBinders;
        }
        DependentsManager.getDependents(chain.child0, res);
        DependentsManager.getDependents(chain.child1, res);
    }
}

