/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import com.sun.javafx.runtime.DependentsManager;
import com.sun.javafx.runtime.FXObject;
import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.Sequence;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public final class DependentsGraphWriter {
    private static final String GXL_NS = "http://www.gupro.de/GXL/gxl-1.0.dtd";
    private static final String GXL = "gxl";
    private static final String GRAPH = "graph";
    private static final String NODE = "node";
    private static final String EDGE = "edge";
    private static final String ATTR = "attr";
    private static final String STRING = "string";
    private static final String BOOL = "bool";
    private static final String ID = "id";
    private static final String FROM = "from";
    private static final String TO = "to";
    private static final String EDGEMODE = "edgemode";
    private static final String NAME = "name";
    private static final String DIRECTED = "directed";
    private static final String ATTR_ID = "ID";
    private static final String ATTR_IDREF = "IDREF";
    private static final String ATTR_CDATA = "CDATA";
    private static final String ATTR_NMTOKEN = "NMTOKEN";
    private static final String COLOR = "color";
    private static final String INTEROBJECT_EDGE_COLOR = "red";
    private Map<FXObject, FXObject> allObjects = new IdentityHashMap<FXObject, FXObject>();
    private AttributesImpl attrs = new AttributesImpl();
    private ContentHandler handler;
    private boolean followFields;

    public static void write(FXObject obj, String fileName) {
        DependentsGraphWriter.write(obj, fileName, false);
    }

    public static void write(FXObject obj, String fileName, boolean followFields) {
        DependentsGraphWriter.write(obj, new File(fileName), followFields);
    }

    public static void write(FXObject obj, File file) {
        DependentsGraphWriter.write(obj, file, false);
    }

    public static void write(FXObject obj, File file, boolean followFields) {
        DependentsGraphWriter depWriter = new DependentsGraphWriter(file, followFields);
        depWriter.start(file.getName());
        depWriter.writeDependencies(obj);
        depWriter.end();
    }

    private DependentsGraphWriter(File file, boolean followFields) {
        this.handler = DependentsGraphWriter.makeContentHandler(file);
        this.followFields = followFields;
    }

    private static ContentHandler makeContentHandler(File file) {
        try {
            FileOutputStream fis = new FileOutputStream(file);
            BufferedOutputStream bos = new BufferedOutputStream(fis);
            StreamResult streamResult = new StreamResult(bos);
            SAXTransformerFactory fac = (SAXTransformerFactory)TransformerFactory.newInstance();
            TransformerHandler thandler = fac.newTransformerHandler();
            Transformer transformer = thandler.getTransformer();
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.setOutputProperty("indent", "yes");
            thandler.setResult(streamResult);
            return thandler;
        }
        catch (Exception exp) {
            throw DependentsGraphWriter.wrapException(exp);
        }
    }

    private void start(String graphId) {
        this.startDocument();
        this.startElement(GXL);
        this.attrs.clear();
        this.attrs.addAttribute("", ID, ID, ATTR_ID, graphId);
        this.attrs.addAttribute("", EDGEMODE, EDGEMODE, ATTR_CDATA, DIRECTED);
        this.startElement(GRAPH, this.attrs);
    }

    private void end() {
        for (FXObject obj : this.allObjects.keySet()) {
            this.attrs.clear();
            this.attrs.addAttribute("", ID, ID, ATTR_ID, this.id(obj));
            this.startElement(NODE, this.attrs);
            this.endElement(NODE);
        }
        this.endElement(GRAPH);
        this.endElement(GXL);
        this.endDocument();
        this.allObjects.clear();
        this.attrs.clear();
        this.allObjects = null;
        this.attrs = null;
        this.handler = null;
    }

    private void writeDependencies(FXObject bindee) {
        if (this.allObjects.containsKey(bindee)) {
            return;
        }
        this.allObjects.put(bindee, bindee);
        List<FXObject> dependents = DependentsManager.getDependents(bindee);
        for (FXObject binder : dependents) {
            this.writeDependency(binder, bindee);
            this.writeDependencies(binder);
        }
        if (this.followFields) {
            int count = bindee.count$();
            for (int idx = 0; idx < count; ++idx) {
                Sequence seq;
                Object fieldValue = bindee.get$(idx);
                if (fieldValue instanceof FXObject) {
                    this.writeDependencies((FXObject)fieldValue);
                    continue;
                }
                if (!(fieldValue instanceof Sequence) || (seq = (Sequence)fieldValue).getElementType() != TypeInfo.Object) continue;
                for (Object elem : seq) {
                    if (!(elem instanceof FXObject)) continue;
                    this.writeDependencies((FXObject)elem);
                }
            }
        }
    }

    private void writeDependency(FXObject binder, FXObject bindee) {
        this.attrs.clear();
        this.attrs.addAttribute("", FROM, FROM, ATTR_IDREF, this.id(binder));
        this.attrs.addAttribute("", TO, TO, ATTR_IDREF, this.id(bindee));
        this.startElement(EDGE, this.attrs);
        this.attrs.clear();
        this.attrs.addAttribute("", NAME, NAME, ATTR_NMTOKEN, COLOR);
        this.startElement(ATTR, this.attrs);
        this.startElement(STRING);
        this.emitData(INTEROBJECT_EDGE_COLOR);
        this.endElement(STRING);
        this.endElement(ATTR);
        this.endElement(EDGE);
    }

    private String id(FXObject obj) {
        StringBuilder buf = new StringBuilder();
        buf.append(obj.getClass().getName());
        buf.append('@');
        buf.append(Integer.toHexString(System.identityHashCode(obj)));
        return buf.toString();
    }

    private void startDocument() {
        try {
            this.handler.startDocument();
        }
        catch (Exception exp) {
            throw DependentsGraphWriter.wrapException(exp);
        }
    }

    private void endDocument() {
        try {
            this.handler.endDocument();
        }
        catch (Exception exp) {
            throw DependentsGraphWriter.wrapException(exp);
        }
    }

    private void startElement(String element) {
        this.attrs.clear();
        this.startElement(element, this.attrs);
    }

    private void startElement(String element, Attributes attrs) {
        try {
            this.handler.startElement(GXL_NS, element, element, attrs);
        }
        catch (Exception exp) {
            throw DependentsGraphWriter.wrapException(exp);
        }
    }

    private void endElement(String element) {
        try {
            this.handler.endElement(GXL_NS, element, element);
        }
        catch (Exception exp) {
            throw DependentsGraphWriter.wrapException(exp);
        }
    }

    private void emitData(String data) {
        if (data == null) {
            return;
        }
        char[] chars = data.toCharArray();
        try {
            this.handler.characters(chars, 0, chars.length);
        }
        catch (Exception exp) {
            throw DependentsGraphWriter.wrapException(exp);
        }
    }

    private static RuntimeException wrapException(Exception exp) {
        if (exp instanceof RuntimeException) {
            return (RuntimeException)exp;
        }
        return new RuntimeException(exp);
    }
}

