/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.loader;

import com.sun.javafx.runtime.FXObject;
import com.sun.javafx.runtime.Pointer;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.tools.fxd.container.doc.PathResolver;
import com.sun.javafx.tools.fxd.loader.Creator;
import com.sun.javafx.tools.fxd.loader.FXClassReflector;
import com.sun.javafx.tools.fxd.reflector.javafx.scene.NodeReflector;
import java.util.Map;
import javafx.scene.Node;

public final class FXPathResolver
extends PathResolver {
    private static final FXClassReflector.FXProperty PROP_ID;
    private final Map m_ids;

    public FXPathResolver(String string) {
        this(string, null);
    }

    public FXPathResolver(String string, Map map) {
        super(string, 0);
        this.m_ids = map;
    }

    protected Object visitChildren(Object object, PathResolver.ResolveVisitor resolveVisitor, Object object2) throws Exception {
        FXObject fXObject = (FXObject)object;
        FXClassReflector fXClassReflector = null;
        try {
            fXClassReflector = Creator.INSTANCE.getReflector(fXObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fXClassReflector == null) {
            return null;
        }
        FXClassReflector.FXProperty[][] fXPropertyArray = fXClassReflector.getProperties();
        if (fXPropertyArray != null) {
            FXClassReflector.FXProperty[][] fXPropertyArray2 = fXPropertyArray;
            int n = fXPropertyArray2.length;
            for (int i = 0; i < n; ++i) {
                FXClassReflector.FXProperty[] fXPropertyArray3;
                for (FXClassReflector.FXProperty fXProperty : fXPropertyArray3 = fXPropertyArray2[i]) {
                    Object object3;
                    Object object4;
                    if ((fXProperty.modifiers & 1) != 0 || fXProperty.isPrimitive() || (object4 = fXProperty.getValue(fXObject)) == null) continue;
                    if (object4 instanceof FXObject) {
                        object3 = resolveVisitor.visit(object4, object2);
                        if (object3 == null) continue;
                        return object3;
                    }
                    if (!(object4 instanceof Sequence)) continue;
                    Sequence sequence = (Sequence)object4;
                    int n2 = sequence.size();
                    for (int j = 0; j < n2; ++j) {
                        object4 = sequence.get(j);
                        if (object4 == null) continue;
                        if (object4 instanceof FXObject) {
                            object3 = resolveVisitor.visit(object4, object2);
                            if (object3 == null) continue;
                            return object3;
                        }
                        System.err.println("Array element is not FXObject " + object4);
                    }
                }
            }
        }
        return null;
    }

    protected Object getPropertyValue(Object object, String string) throws Exception {
        FXObject fXObject = (FXObject)object;
        FXClassReflector.FXProperty fXProperty = Creator.INSTANCE.getReflector(fXObject).getProperty(string);
        return fXProperty.getValue(fXObject);
    }

    protected boolean isObject(Object object) {
        return object instanceof FXObject;
    }

    protected String getID(Object object) {
        String string = null;
        if (object instanceof Node) {
            string = (String)PROP_ID.getValue((FXObject)((Node)object));
        } else if (this.m_ids != null) {
            string = (String)this.m_ids.get(object);
        }
        return string;
    }

    protected boolean mayHaveChildren(Object object) {
        return true;
    }

    protected PathResolver.Referenced createReferenced(Object object, String string) {
        return new FXReferenced(this.m_path, (FXObject)object, string);
    }

    static {
        FXClassReflector.FXProperty fXProperty = null;
        for (FXClassReflector.FXProperty fXProperty2 : NodeReflector.DECLARED_PROPERTIES) {
            if (!"id".equals(fXProperty2.name)) continue;
            fXProperty = fXProperty2;
            break;
        }
        PROP_ID = fXProperty;
    }

    public static final class FXReferenced
    extends PathResolver.Referenced {
        private final String m_path;
        private final FXObject m_fxObject;

        public FXReferenced(String string, FXObject fXObject, String string2) {
            super(string2);
            this.m_path = string;
            this.m_fxObject = fXObject;
        }

        public Object getValue() {
            if (this.isPropertyReference()) {
                return Creator.INSTANCE.getPropertyValue(this.m_fxObject, this.m_propName);
            }
            return this.getObject();
        }

        public Pointer.BoundPointer bindProperty(Pointer pointer) {
            if (this.isPropertyReference()) {
                return Creator.INSTANCE.bindProperty(this.m_fxObject, this.m_propName, pointer);
            }
            throw new IllegalArgumentException("The query '" + this.m_path + "' matches object, rather than a single property.");
        }

        public FXObject getObject() {
            return this.m_fxObject;
        }

        public String toString() {
            return String.format("Referenced[ elem=%s property=%s]", this.m_fxObject, this.m_propName);
        }
    }
}

