/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.loader;

import com.sun.javafx.runtime.FXObject;
import com.sun.javafx.runtime.Pointer;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.tools.fxd.CancelledException;
import com.sun.javafx.tools.fxd.FXDObjectElement;
import com.sun.javafx.tools.fxd.loader.CreationContext;
import com.sun.javafx.tools.fxd.loader.Profile;
import com.sun.javafx.tools.fxd.loader.Reflector;
import com.sun.javafx.tools.fxd.pool.DelayedValue;
import java.util.Enumeration;
import javafx.animation.KeyValueTarget;
import javafx.lang.Duration;

public abstract class FXClassReflector
implements Reflector {
    protected static final String MSG_ATTR_NOT_SUPPORTED = "The attribute %s#%s not supported by the %s profile!";
    protected static final String MSG_ATTR_NOT_FOUND = "The attribute %s#%s not found!";
    protected static final int NO_VAR_INDEX = -1024;
    public static final int NORMAL = 0;
    public static final int STATIC = 1;
    public static final int READ_ONLY = 2;
    public static final int PUBLIC_INIT = 4;
    public static final int REQUIRES_COPY = 8;
    public final Class objectClass;
    public final Class[] extendsClasses;
    public final Profile profile;

    public FXClassReflector(Class clazz, Class[] classArray, Profile profile) {
        this.objectClass = clazz;
        this.extendsClasses = classArray;
        this.profile = profile;
        for (FXProperty[] fXPropertyArray : this.getProperties()) {
            this.sortProperties(fXPropertyArray);
        }
    }

    private synchronized void sortProperties(FXProperty[] fXPropertyArray) {
        int n = 0;
        for (FXProperty fXProperty : fXPropertyArray) {
            if (fXProperty.fxVarIndex == -1024) continue;
            if (n <= fXProperty.fxVarIndex) {
                n = fXProperty.fxVarIndex;
                continue;
            }
            for (int i = 0; i < fXPropertyArray.length - 1; ++i) {
                for (int j = i + 1; j < fXPropertyArray.length; ++j) {
                    if (fXPropertyArray[i].fxVarIndex <= fXPropertyArray[j].fxVarIndex) continue;
                    FXProperty fXProperty2 = fXPropertyArray[i];
                    fXPropertyArray[i] = fXPropertyArray[j];
                    fXPropertyArray[j] = fXProperty2;
                }
            }
            return;
        }
    }

    public Object create(FXDObjectElement fXDObjectElement, CreationContext creationContext) {
        FXObject fXObject = this.initObject();
        this.fillAttributes(fXObject, fXDObjectElement, creationContext);
        this.completeObject(fXObject);
        return fXObject;
    }

    public FXObject duplicate(FXObject fXObject, CreationContext creationContext) {
        FXObject fXObject2 = this.initObject();
        this.fillAttributes(fXObject2, fXObject, creationContext);
        this.completeObject(fXObject2);
        return fXObject2;
    }

    protected FXObject initObject() {
        FXObject fXObject = this.construct();
        fXObject.initVars$();
        return fXObject;
    }

    protected void fillAttributes(FXObject fXObject, FXDObjectElement fXDObjectElement, CreationContext creationContext) {
        int n;
        FXProperty[][] fXPropertyArray = this.getProperties();
        Profile profile = creationContext.getTargetProfile();
        int n2 = fXDObjectElement.getAttrNum();
        int n3 = 0;
        for (n = fXPropertyArray.length - 1; n >= 0; --n) {
            FXProperty[] fXPropertyArray2;
            for (FXProperty fXProperty : fXPropertyArray2 = fXPropertyArray[n]) {
                if (creationContext.isCancelled()) {
                    throw new CancelledException();
                }
                if ((fXProperty.modifiers & 1) != 0) continue;
                if (fXProperty.fxVarIndex != -1024) {
                    while (n3 < fXProperty.fxVarIndex) {
                        fXObject.varChangeBits$(n3, 0, 8);
                        fXObject.applyDefaults$(n3++);
                    }
                    if (n3 != fXProperty.fxVarIndex) {
                        System.err.println("Internal error in element duplication - illegal var index order for " + this.objectClass.getName() + " at " + fXProperty.name + " " + fXProperty.fxVarIndex + " != " + n3);
                        continue;
                    }
                    if ((profile == null || profile.contains(fXProperty.profile)) && fXDObjectElement.getAttrValue(fXProperty.name) != null) {
                        int n4 = 8;
                        if (fXProperty.isArray) {
                            n4 |= 0x80;
                        }
                        fXObject.varChangeBits$(n3, -1, n4);
                        fXObject.varChangeBits$(n3, 0, 8);
                        Object object = fXDObjectElement.getAttrValue(fXProperty.name);
                        if (object != null) {
                            --n2;
                            if (object == FXDObjectElement.NULL_VALUE) {
                                fXProperty.setValue(fXObject, null);
                            } else if (fXProperty.isArray) {
                                if (creationContext.isCreationBlocked() && FXClassReflector.isBlockAllowed(this.objectClass.getName(), fXProperty.name)) {
                                    creationContext.addConnector(this, fXObject, fXProperty, object);
                                } else {
                                    fXProperty.setValue(fXObject, CreationContext.creator.createSequence(object, fXProperty.type, (fXProperty.modifiers & 8) != 0, creationContext));
                                }
                            } else {
                                Object object2 = CreationContext.creator.coerce(object, fXProperty.type, (fXProperty.modifiers & 8) != 0, creationContext);
                                if (object2 instanceof DelayedValue) {
                                    creationContext.getPool().addConnection(creationContext.createConnector(this, fXObject, fXProperty, object2));
                                } else {
                                    fXProperty.setValue(fXObject, object2);
                                }
                            }
                        }
                        ++n3;
                        continue;
                    }
                }
                fXObject.varChangeBits$(n3, 0, 8);
                fXObject.applyDefaults$(n3);
                ++n3;
            }
        }
        n = fXObject.count$();
        while (n3 < n) {
            fXObject.varChangeBits$(n3, 0, 8);
            fXObject.applyDefaults$(n3++);
        }
        if (n2 > 1 || n2 == 1 && fXDObjectElement.getAttrValue("id") == null) {
            this.reportUnknownAttributes(fXObject, fXDObjectElement, fXPropertyArray, creationContext, n2);
        }
    }

    void connectProperty(FXObject fXObject, FXProperty fXProperty, Object object, CreationContext creationContext) {
        if (fXProperty.isArray) {
            object = CreationContext.creator.createSequence(object, fXProperty.type, (fXProperty.modifiers & 8) != 0, creationContext);
        }
        fXProperty.setValue(fXObject, object);
    }

    protected void reportUnknownAttributes(FXObject fXObject, FXDObjectElement fXDObjectElement, FXProperty[][] fXPropertyArray, CreationContext creationContext, int n) {
        Enumeration enumeration = fXDObjectElement.getAttrNames();
        block0: while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            FXProperty[][] fXPropertyArray2 = fXPropertyArray;
            int n2 = fXPropertyArray2.length;
            for (int i = 0; i < n2; ++i) {
                FXProperty[] fXPropertyArray3;
                for (FXProperty fXProperty : fXPropertyArray3 = fXPropertyArray2[i]) {
                    if (fXProperty.name.equals(string)) continue block0;
                }
            }
            if (!"id".equals(string)) {
                creationContext.report(String.format(MSG_ATTR_NOT_FOUND, fXObject.getClass().getName(), string));
            }
            if (--n > 0) continue;
            break;
        }
    }

    protected void fillAttributes(FXObject fXObject, FXObject fXObject2, CreationContext creationContext) {
        int n;
        FXProperty[][] fXPropertyArray = this.getProperties();
        int n2 = 0;
        for (n = fXPropertyArray.length - 1; n >= 0; --n) {
            FXProperty[] fXPropertyArray2;
            for (FXProperty fXProperty : fXPropertyArray2 = fXPropertyArray[n]) {
                if (creationContext.isCancelled()) {
                    throw new CancelledException();
                }
                if ((fXProperty.modifiers & 1) != 0 || fXProperty.fxVarIndex == -1024) continue;
                while (n2 < fXProperty.fxVarIndex) {
                    fXObject.varChangeBits$(n2, 0, 8);
                    fXObject.applyDefaults$(n2++);
                }
                if (n2 != fXProperty.fxVarIndex) {
                    System.err.println("Internal error in element duplication - illegal var index order for " + this.objectClass.getName() + " at " + fXProperty.name + " " + fXProperty.fxVarIndex + " != " + n2);
                    continue;
                }
                Object object = fXProperty.getValue(fXObject2);
                if ((fXProperty.modifiers & 6) != 0) {
                    fXProperty.setValue(fXObject, object);
                } else {
                    try {
                        if (fXProperty.isArray) {
                            fXProperty.setValue(fXObject, CreationContext.creator.duplicateSequence((Sequence)object, fXProperty.type, creationContext));
                        } else {
                            fXProperty.setValue(fXObject, CreationContext.creator.duplicate(object, creationContext));
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.err.println("Cannot duplicate the " + fXProperty.toString() + " [" + object + "] since the reflector could not be found, skipping.");
                    }
                }
                ++n2;
            }
        }
        n = fXObject.count$();
        while (n2 < n) {
            fXObject.varChangeBits$(n2, 0, 8);
            fXObject.applyDefaults$(n2++);
        }
    }

    protected void completeObject(FXObject fXObject) {
        fXObject.complete$();
    }

    public boolean isEnum() {
        return false;
    }

    protected FXObject construct() {
        throw new RuntimeException("The instance of the class " + this.objectClass.getName() + " cannot be created");
    }

    public FXProperty getProperty(String string) {
        FXProperty[][] fXPropertyArray = this.getProperties();
        int n = fXPropertyArray.length;
        for (int i = 0; i < n; ++i) {
            FXProperty[] fXPropertyArray2;
            for (FXProperty fXProperty : fXPropertyArray2 = fXPropertyArray[i]) {
                if (!fXProperty.name.equals(string)) continue;
                return fXProperty;
            }
        }
        return null;
    }

    public abstract FXProperty[][] getProperties();

    public abstract FXFunction[][] getFunctions();

    private static boolean isBlockAllowed(String string, String string2) {
        return (!string.endsWith(".LinearGradient") || !"stops".equals(string2)) && (!string.endsWith(".RadialGradient") || !"stops".equals(string2));
    }

    public static abstract class Accessor {
        public abstract Object getValue(FXObject var1, int var2);

        public abstract void setValue(FXObject var1, Object var2, int var3);

        public Object invoke(FXObject fXObject, Object[] objectArray, int n, CreationContext creationContext) {
            throw new RuntimeException("No method available");
        }
    }

    public static final class FXFunction {
        public final String name;
        public final Class[] args;
        public final Profile profile;
        private final Accessor accessor;
        private final int methodIndex;

        public FXFunction(String string, Profile profile, Class[] classArray, Accessor accessor, int n) {
            this.name = string;
            this.args = classArray;
            this.profile = profile;
            this.accessor = accessor;
            this.methodIndex = n;
        }

        public Object invoke(FXObject fXObject, Object[] objectArray, CreationContext creationContext) {
            return this.accessor.invoke(fXObject, objectArray, this.methodIndex, creationContext);
        }
    }

    public static final class FXProperty {
        public final String name;
        public final Class type;
        public final int fxVarIndex;
        public final boolean isArray;
        public final Profile profile;
        public final int modifiers;
        private final Accessor accessor;
        private final int index;

        public FXProperty(String string, Class clazz, int n, boolean bl, Profile profile, int n2, Accessor accessor, int n3) {
            this.name = string;
            this.type = clazz;
            this.fxVarIndex = n;
            this.isArray = bl;
            this.profile = profile;
            this.modifiers = n2;
            this.accessor = accessor;
            this.index = n3;
        }

        public Object getValue(FXObject fXObject) {
            return this.accessor.getValue(fXObject, this.index);
        }

        public void setValue(FXObject fXObject, Object object) {
            try {
                this.accessor.setValue(fXObject, object, this.index);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("Cannot set value " + this + " " + fXObject + "," + object);
            }
        }

        public KeyValueTarget.Type getAnimationType() {
            if (this.isArray) {
                return KeyValueTarget.Type.SEQUENCE;
            }
            if (this.type == Float.class) {
                return KeyValueTarget.Type.FLOAT;
            }
            if (this.type == Integer.class) {
                return KeyValueTarget.Type.INTEGER;
            }
            if (this.type == Boolean.class) {
                return KeyValueTarget.Type.BOOLEAN;
            }
            if (this.type == Short.class) {
                return KeyValueTarget.Type.SHORT;
            }
            if (this.type == Double.class) {
                return KeyValueTarget.Type.DOUBLE;
            }
            if (this.type == Long.class) {
                return KeyValueTarget.Type.LONG;
            }
            if (this.type == Byte.class) {
                return KeyValueTarget.Type.BYTE;
            }
            return KeyValueTarget.Type.OBJECT;
        }

        public final void setChangeBits(FXObject fXObject, int n) {
            int n2 = 8;
            if (this.isArray) {
                n2 |= 0x80;
            }
            System.out.println("Setting change bits  " + fXObject + "  - " + this.toString() + " " + n + " " + n2);
            fXObject.varChangeBits$(this.fxVarIndex, n, n2);
        }

        public String toString() {
            return this.name;
        }

        public Pointer createPointer(FXObject fXObject) {
            Pointer pointer = null;
            if (this.fxVarIndex != -1024 && (pointer = Pointer.make((KeyValueTarget.Type)this.getAnimationType(), (FXObject)fXObject, (int)this.fxVarIndex)) == null) {
                System.err.println("Cannot create KeyValueTarget for " + this);
            }
            return pointer;
        }

        public boolean isPrimitive() {
            return this.type == Float.class || this.type == Integer.class || this.type == Boolean.class || this.type == String.class || this.type == Duration.class;
        }

        private class FXPropertyKeyValueTarget
        implements KeyValueTarget {
            private final FXObject m_fxObj;

            public FXPropertyKeyValueTarget(FXObject fXObject) {
                this.m_fxObj = fXObject;
            }

            public Object get() {
                return FXProperty.this.getValue(this.m_fxObj);
            }

            public KeyValueTarget.Type getType() {
                System.err.println("not supported!");
                throw new UnsupportedOperationException("Not supported yet: " + FXProperty.this.type);
            }

            public Object getValue() {
                return this.get();
            }

            public void set(Object object) {
                FXProperty.this.setValue(this.m_fxObj, object);
            }

            public void setValue(Object object) {
                this.set(object);
            }

            public KeyValueTarget unwrap() {
                return this;
            }

            protected String getName() {
                return FXProperty.this.name;
            }

            public boolean equals(Object object) {
                if (object instanceof FXPropertyKeyValueTarget) {
                    FXPropertyKeyValueTarget fXPropertyKeyValueTarget = (FXPropertyKeyValueTarget)object;
                    if (this.m_fxObj == fXPropertyKeyValueTarget.m_fxObj && this.getName().equals(fXPropertyKeyValueTarget.getName())) {
                        return true;
                    }
                }
                return false;
            }

            public int hashCode() {
                int n = 5;
                n = 47 * n + (this.m_fxObj != null ? this.m_fxObj.hashCode() : 0);
                return n;
            }
        }
    }
}

