/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.loader;

import com.sun.javafx.functions.Function0;
import com.sun.javafx.runtime.FXObject;
import com.sun.javafx.runtime.Pointer;
import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.ObjectArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.tools.fxd.FXDArrayElement;
import com.sun.javafx.tools.fxd.FXDExpression;
import com.sun.javafx.tools.fxd.FXDObjectElement;
import com.sun.javafx.tools.fxd.FXDReference;
import com.sun.javafx.tools.fxd.container.misc.ContainerUtils;
import com.sun.javafx.tools.fxd.container.misc.FXDDuration;
import com.sun.javafx.tools.fxd.loader.CreationContext;
import com.sun.javafx.tools.fxd.loader.EnumReflector;
import com.sun.javafx.tools.fxd.loader.FXClassReflector;
import com.sun.javafx.tools.fxd.loader.Reflector;
import com.sun.javafx.tools.fxd.loader.ReflectorNotFoundException;
import com.sun.javafx.tools.fxd.pool.DelayedValuePool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.KeyValueTarget;
import javafx.lang.Duration;

public class Creator {
    private static final String REFLECTOR_PREFIX = "com.sun.javafx.tools.fxd.reflector.";
    private static final String REFLECTOR_APPENDIX = "Reflector";
    private static final String OVERRIDE_APPENDIX = "Override";
    private static final String[] DEFAULT_IMPORTS = new String[]{"javafx.animation.", "javafx.animation.transition.", "javafx.fxd.", "javafx.geometry.", "javafx.scene.", "javafx.scene.control.", "javafx.scene.effect.", "javafx.scene.effect.light.", "javafx.scene.image.", "javafx.scene.layout.", "javafx.scene.paint.", "javafx.scene.shape.", "javafx.scene.text.", "javafx.scene.transform.", "com.sun.javafx.tools.fxd."};
    public static final Creator INSTANCE;
    private final Map<String, Reflector> m_fullMap = new HashMap<String, Reflector>(32);
    private final Map<String, Reflector> m_quickMap = new HashMap<String, Reflector>(32);
    private final List<String> m_imports = new ArrayList<String>(8);

    private Creator() {
        for (String string : DEFAULT_IMPORTS) {
            this.m_imports.add(string);
        }
    }

    public Object coerce(Object object, Class clazz, boolean bl, CreationContext creationContext) {
        if (clazz == Function0.class) {
            return creationContext.createFunction(object);
        }
        if (object == FXDObjectElement.NULL_VALUE) {
            return null;
        }
        if (object instanceof FXDObjectElement) {
            return creationContext.create((FXDObjectElement)object, true);
        }
        if (object instanceof FXDExpression) {
            return this.resolveExpression((FXDExpression)object, creationContext);
        }
        if (object instanceof FXDReference) {
            return creationContext.resolveReference((FXDReference)object, bl, clazz);
        }
        if (clazz == Float.class || clazz == Number.class) {
            if (!(object instanceof Float)) {
                return Float.valueOf(((Number)object).floatValue());
            }
        } else if (clazz == Duration.class && !(object instanceof Duration)) {
            double d = object instanceof FXDDuration ? ((FXDDuration)object).doubleValue() : ((Number)object).doubleValue();
            return Duration.valueOf((double)d);
        }
        return object;
    }

    public Object duplicate(Object object, CreationContext creationContext) throws ClassNotFoundException {
        if (object instanceof FXObject) {
            try {
                return this.duplicate((FXObject)object, creationContext);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw classNotFoundException;
            }
            catch (Exception exception) {
                throw ContainerUtils.createRuntimeException("Could not duplicate object " + object, exception);
            }
        }
        return object;
    }

    private FXObject duplicate(FXObject fXObject, CreationContext creationContext) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        FXClassReflector fXClassReflector = this.getReflector(fXObject);
        return fXClassReflector.duplicate(fXObject, creationContext);
    }

    private Object resolveExpression(FXDExpression fXDExpression, CreationContext creationContext) {
        if (fXDExpression.isEnumeration()) {
            FXDExpression.Enum enum_ = (FXDExpression.Enum)fXDExpression;
            Reflector reflector = this.getReflectorByTypeName(enum_.className);
            if (reflector.isEnum()) {
                for (EnumReflector.EnumConstant enumConstant : ((EnumReflector)reflector).getEnumConstants()) {
                    if (!enumConstant.name.equals(enum_.varName)) continue;
                    return enumConstant.value;
                }
                throw new RuntimeException("Unknown enum constant: " + fXDExpression);
            }
            FXClassReflector.FXProperty[][] fXPropertyArray = ((FXClassReflector)reflector).getProperties();
            int n = fXPropertyArray.length;
            for (int i = 0; i < n; ++i) {
                FXClassReflector.FXProperty[] fXPropertyArray2;
                for (FXClassReflector.FXProperty fXProperty : fXPropertyArray2 = fXPropertyArray[i]) {
                    if ((fXProperty.modifiers & 1) == 0 || !fXProperty.name.equals(enum_.varName)) continue;
                    return fXProperty.getValue(null);
                }
            }
            throw new RuntimeException("Unknown property: " + fXDExpression);
        }
        FXDExpression.Function function = (FXDExpression.Function)fXDExpression;
        FXClassReflector fXClassReflector = (FXClassReflector)this.getReflectorByTypeName(function.className);
        FXClassReflector.FXFunction[][] fXFunctionArray = fXClassReflector.getFunctions();
        int n = fXFunctionArray.length;
        for (int i = 0; i < n; ++i) {
            FXClassReflector.FXFunction[] fXFunctionArray2;
            for (FXClassReflector.FXFunction fXFunction : fXFunctionArray2 = fXFunctionArray[i]) {
                if (fXFunction.args.length != function.args.length || !fXFunction.name.equals(function.methodName)) continue;
                Object[] objectArray = new Object[fXFunction.args.length];
                for (int j = 0; j < objectArray.length; ++j) {
                    objectArray[j] = this.coerce(function.args[j], fXFunction.args[j], false, creationContext);
                }
                return fXFunction.invoke(null, objectArray, creationContext);
            }
        }
        throw new RuntimeException("Cannot resolve the expression " + fXDExpression);
    }

    public Sequence createSequence(Object object, Class clazz, boolean bl, CreationContext creationContext) {
        ObjectArraySequence objectArraySequence;
        TypeInfo typeInfo = TypeInfo.getTypeInfo((Class)clazz);
        if (object instanceof FXDArrayElement) {
            FXDArrayElement fXDArrayElement = (FXDArrayElement)object;
            int n = fXDArrayElement.getLength();
            objectArraySequence = new ObjectArraySequence(n, typeInfo);
            for (int i = 0; i < n; ++i) {
                try {
                    objectArraySequence.add(this.coerce(fXDArrayElement.elementAt(i), clazz, bl, creationContext));
                    continue;
                }
                catch (ReflectorNotFoundException reflectorNotFoundException) {
                    System.err.println(reflectorNotFoundException.getMessage());
                }
            }
        } else if (object instanceof FXDObjectElement) {
            objectArraySequence = new ObjectArraySequence(1, typeInfo);
            try {
                objectArraySequence.add(this.coerce(object, clazz, bl, creationContext));
            }
            catch (ReflectorNotFoundException reflectorNotFoundException) {
                System.err.println(reflectorNotFoundException.getMessage());
            }
        } else {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        return objectArraySequence;
    }

    public Sequence duplicateSequence(Sequence sequence, Class clazz, CreationContext creationContext) throws ClassNotFoundException {
        TypeInfo typeInfo = TypeInfo.getTypeInfo((Class)clazz);
        int n = sequence.size();
        ObjectArraySequence objectArraySequence = new ObjectArraySequence(n, typeInfo);
        for (int i = 0; i < n; ++i) {
            try {
                objectArraySequence.add(CreationContext.creator.duplicate(sequence.get(i), creationContext));
                continue;
            }
            catch (ReflectorNotFoundException reflectorNotFoundException) {
                System.err.println(reflectorNotFoundException.getMessage());
            }
        }
        return objectArraySequence;
    }

    public final FXClassReflector getReflector(FXObject fXObject) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return (FXClassReflector)this.getReflector(this.getTypeFullName(fXObject));
    }

    private String getTypeFullName(FXObject fXObject) {
        return fXObject.getClass().getName();
    }

    public final Object getPropertyValue(FXObject fXObject, String string) {
        FXClassReflector fXClassReflector;
        try {
            fXClassReflector = this.getReflector(fXObject);
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not find reflector for the class " + fXObject.getClass() + " [" + exception.getMessage() + "]");
        }
        FXClassReflector.FXProperty fXProperty = fXClassReflector.getProperty(string);
        if (fXProperty != null) {
            return fXProperty.getValue(fXObject);
        }
        throw new RuntimeException("The property " + string + " not found on the object " + fXObject);
    }

    public KeyValueTarget getKeyValueTarget(FXObject fXObject, String string) {
        String string2 = this.getTypeFullName(fXObject);
        try {
            FXClassReflector fXClassReflector = (FXClassReflector)this.getReflector(string2);
            return fXClassReflector.getProperty(string).createPointer(fXObject);
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot get KeyValueTarget for " + string2 + "#" + string);
        }
    }

    private String getReflectorClassName(String string) {
        return REFLECTOR_PREFIX + string + REFLECTOR_APPENDIX;
    }

    private Reflector getReflector(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Reflector reflector = this.m_fullMap.get(string);
        if (reflector == null) {
            String string2 = this.getReflectorClassName(string);
            Class<?> clazz = Class.forName(string2);
            try {
                clazz = Class.forName(string2 + OVERRIDE_APPENDIX);
            }
            catch (Exception exception) {
                // empty catch block
            }
            reflector = (Reflector)clazz.newInstance();
            this.m_fullMap.put(string, reflector);
        }
        return reflector;
    }

    public Reflector getReflectorByTypeName(String string) {
        Reflector reflector = this.m_quickMap.get(string);
        if (reflector == null) {
            for (String string2 : this.m_imports) {
                String string3 = string2.concat(string);
                try {
                    reflector = this.getReflector(string3);
                    this.m_quickMap.put(string, reflector);
                    return reflector;
                }
                catch (Exception exception) {
                }
            }
            throw new ReflectorNotFoundException(string);
        }
        return reflector;
    }

    private static boolean loadReflectorClass(String string, boolean bl) {
        try {
            Class.forName(REFLECTOR_PREFIX + string + REFLECTOR_APPENDIX + (bl ? OVERRIDE_APPENDIX : "")).getName();
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    Pointer.BoundPointer bindProperty(FXObject fXObject, String string, Pointer pointer) {
        FXClassReflector fXClassReflector;
        try {
            fXClassReflector = this.getReflector(fXObject);
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
        FXClassReflector.FXProperty fXProperty = fXClassReflector.getProperty(string);
        if (fXProperty != null) {
            return fXProperty.createPointer(fXObject).bind(pointer);
        }
        throw new RuntimeException();
    }

    static {
        if (DelayedValuePool.isEnabled()) {
            Creator.loadReflectorClass("javafx.scene.image.Image", true);
        }
        INSTANCE = new Creator();
    }
}

