/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.container.scene.fxd;

import com.sun.javafx.tools.fxd.CancelledException;
import com.sun.javafx.tools.fxd.FXDElement;
import com.sun.javafx.tools.fxd.FXDExpression;
import com.sun.javafx.tools.fxd.FXDObjectElement;
import com.sun.javafx.tools.fxd.FXDReference;
import com.sun.javafx.tools.fxd.FXDRootElement;
import com.sun.javafx.tools.fxd.container.doc.DocumentParser;
import com.sun.javafx.tools.fxd.container.misc.FXDDuration;
import com.sun.javafx.tools.fxd.container.misc.ProgressHandler;
import com.sun.javafx.tools.fxd.container.scene.fxd.ContentHandler;
import com.sun.javafx.tools.fxd.container.scene.fxd.ContentListener;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDException;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDExtendedNodeImpl;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDNodeArrayImpl;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDNodeImpl;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDReader;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDSyntaxErrorException;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDVersionException;
import com.sun.javafx.tools.fxd.container.scene.fxd.lexer.ContentLexer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;

public final class FXDParser
extends FXDReader {
    protected static final String NULL = "null".intern();
    protected static final String TRUE = "true".intern();
    protected static final String FALSE = "false".intern();
    protected int m_valueEndPosition = -1;
    private final ContentListener m_listener;

    public FXDParser(Reader reader, ContentHandler contentHandler) throws IOException {
        this(reader, contentHandler, null);
    }

    public FXDParser(Reader reader, ContentHandler contentHandler, ProgressHandler progressHandler) throws IOException {
        super(reader, progressHandler);
        this.m_listener = ContentListener.create(contentHandler);
    }

    public FXDParser(Reader reader, ContentLexer contentLexer) throws IOException {
        this(reader, contentLexer, null);
    }

    public FXDParser(Reader reader, ContentLexer contentLexer, ProgressHandler progressHandler) throws IOException {
        super(reader, progressHandler);
        this.m_listener = ContentListener.create(contentLexer);
    }

    public void parseObject() throws IOException, FXDException {
        this.m_listener.parsingStarted(this);
        this.parseObject(false);
    }

    protected void parseObject(boolean bl) throws IOException, FXDException {
        String string;
        this.lookForVersion(true);
        String string2 = this.nextID();
        boolean bl2 = false;
        if (string2 == null) {
            string2 = this.nextReference();
            if (string2 == null) {
                if (bl) {
                    throw this.syntaxError("Object type expected, found '" + this.peek() + "'");
                }
                this.m_listener.parsingFinished();
                return;
            }
            bl2 = true;
        }
        if ((string = this.getVersionInfo()) != null) {
            FXDParser.checkVersion(string);
        }
        this.lookForVersion(false);
        int n = this.getPosition() - string2.length();
        this.m_listener.identifier(string2, n);
        char c = this.fetchClean();
        if (c != '{') {
            throw this.syntaxError("A FXD element must continue with '{'; found '" + c + "' instead ");
        }
        this.m_listener.separator(c, this.getPosition() - 1);
        this.parseObjectImpl(n, string2, bl2);
        this.m_listener.parsingFinished();
    }

    protected void commentFound(int n, int n2) {
        this.m_listener.comment(n, n2);
    }

    protected void lineCommentFound(int n, int n2) {
        this.m_listener.lineComment(n, n2);
    }

    protected void parseObjectImpl(int n, String string, boolean bl) throws IOException, FXDException {
        int n2;
        Object object = this.m_listener.startNode(string, n, bl);
        block8: while (true) {
            boolean bl2;
            String string2;
            n2 = this.peekClean();
            switch (n2) {
                case 0: {
                    throw this.syntaxError("A FXD element text must end with '}'");
                }
                case 125: {
                    this.advance((char)n2);
                    this.m_listener.endNode(object, this.getPosition());
                    return;
                }
            }
            n = this.getPosition();
            if (n2 == 34) {
                string2 = this.nextString((char)n2);
                string2 = string2.substring(1, string2.length() - 1);
                bl2 = true;
            } else {
                string2 = this.nextValue();
                bl2 = false;
            }
            this.m_listener.attributeName(string2, this.m_valueEndPosition != -1 ? this.m_valueEndPosition : this.getPosition(), bl2);
            n2 = this.fetchClean();
            if (n2 != 61 && n2 != 58) {
                throw this.syntaxError("Expected a ':' after a attribute '" + string2 + "'");
            }
            this.m_listener.operator((char)n2, this.getPosition() - 1);
            String string3 = this.nextValue();
            if (this.m_valueSepPosition != -1) {
                this.m_listener.attribute(object, string2, string3, n, this.m_valueSepPosition, bl2);
                this.m_listener.attributeValue(string3, this.m_droppedChars, this.m_valueEndPosition);
                n2 = 44;
            } else {
                this.m_listener.attribute(object, string2, string3, n, this.getPosition(), bl2);
                this.m_listener.attributeValue(string3, this.m_droppedChars, this.m_valueEndPosition);
                this.m_valueSepPosition = this.getPosition();
                this.m_separatorFound = false;
                n2 = this.peekClean();
                if (this.m_separatorFound) {
                    n2 = 44;
                } else {
                    n2 = this.fetch();
                    this.m_valueSepPosition = -1;
                }
            }
            switch (n2) {
                case 44: 
                case 59: {
                    this.m_listener.separator((char)n2, this.m_separatorFound ? this.m_valueSepPosition : this.getPosition() - 1);
                    if (!this.checkClean('}')) continue block8;
                    this.m_listener.endNode(object, this.getPosition());
                    return;
                }
                case 125: {
                    this.m_listener.endNode(object, this.getPosition());
                    return;
                }
            }
            break;
        }
        throw this.syntaxError("Expected a ',' or '}'; found '" + (char)n2 + "'");
    }

    public void parseArray() throws IOException, FXDException {
        char c;
        if (!this.checkClean('[')) {
            throw this.syntaxError("A FXD element array must start with '['");
        }
        Object object = this.m_listener.startNodeArray(this.getPosition());
        if (this.checkClean(']')) {
            this.m_listener.endNodeArray(object, this.getPosition() - 1);
            return;
        }
        block4: while (true) {
            int n;
            if (this.peekClean() == ',') {
                this.m_listener.arrayElement(object, null, this.getPosition(), this.getPosition());
            } else {
                n = this.getPosition();
                String string = this.nextValue();
                this.m_listener.arrayElement(object, string, n, this.getPosition());
                this.m_listener.attributeValue(string, this.m_droppedChars, this.m_valueEndPosition);
            }
            n = this.peek();
            c = this.peekClean();
            switch (c) {
                case ',': 
                case ';': {
                    this.m_listener.separator(c, this.getPosition());
                    this.advance(c);
                    if (!this.checkClean(']')) continue block4;
                    this.m_listener.endNodeArray(object, this.getPosition() - 1);
                    return;
                }
                case ']': {
                    this.advance(c);
                    this.m_listener.endNodeArray(object, this.getPosition() - 1);
                    return;
                }
            }
            if (n != 32 && n != 10 && n != 9) break;
        }
        throw this.syntaxError("Expected a ',' or ']' found '" + c + "'!");
    }

    protected char next(char c) throws FXDException, IOException {
        char c2 = this.fetch();
        if (c2 != c) {
            throw this.syntaxError("Expected '" + c + "' and instead saw '" + c2 + "'");
        }
        return c2;
    }

    protected String nextValue() throws IOException, FXDException {
        this.m_valueEndPosition = -1;
        char c = this.peekClean();
        int n = this.getPosition();
        switch (c) {
            case '\"': 
            case '\'': {
                String string = this.nextString(c);
                this.m_valueSepPosition = -1;
                this.m_valueEndPosition = this.getPosition();
                return string;
            }
            case '#': {
                String string = this.nextReference();
                this.m_separatorFound = false;
                this.m_valueEndPosition = this.getPosition();
                n = this.getPosition();
                c = this.peekClean();
                if (c == '{') {
                    this.advance(c);
                    this.parseObjectImpl(n, string, true);
                    this.m_valueSepPosition = -1;
                    return null;
                }
                this.m_valueSepPosition = this.m_separatorFound ? n : -1;
                return string;
            }
            case '{': {
                this.parseObject(true);
                this.m_valueSepPosition = -1;
                return null;
            }
            case '[': {
                this.parseArray();
                this.m_valueSepPosition = -1;
                return null;
            }
            case '$': {
                String string = this.nextText();
                if ("$ref".equals(string)) {
                    if (!this.checkClean(':')) {
                        throw this.syntaxError("FXD reference must start with '$ref:'");
                    }
                    string = this.nextReference();
                    string = "$ref:".concat(string);
                    this.m_valueEndPosition = this.getPosition();
                    this.m_valueSepPosition = -1;
                    c = this.peekClean();
                    if (c == '{') {
                        this.advance(c);
                        this.parseObjectImpl(n, string, true);
                        this.m_valueSepPosition = -1;
                        return null;
                    }
                    return string;
                }
                throw this.syntaxError("Unexpected char '$");
            }
        }
        String string = this.nextText();
        this.m_valueEndPosition = this.getPosition();
        this.m_separatorFound = false;
        c = this.peekClean();
        if (c == '{' && FXDParser.isJavaIdentifier(string)) {
            this.m_listener.identifier(string, n);
            this.m_listener.separator(c, this.getPosition());
            this.advance(c);
            this.parseObjectImpl(n, string, false);
            this.m_valueSepPosition = -1;
            return null;
        }
        int n2 = this.m_valueSepPosition = this.m_separatorFound ? this.m_valueSepPosition : -1;
        if (string.equals("")) {
            throw this.syntaxError("Missing value");
        }
        if (string.equalsIgnoreCase(TRUE)) {
            return TRUE;
        }
        if (string.equalsIgnoreCase(FALSE)) {
            return FALSE;
        }
        if (string.equalsIgnoreCase(NULL)) {
            return NULL;
        }
        return string;
    }

    public static FXDRootElement parse(Reader reader, DocumentParser documentParser) throws IOException, FXDException {
        FXDTreeBuilder fXDTreeBuilder = new FXDTreeBuilder(documentParser);
        FXDParser fXDParser = new FXDParser(reader, fXDTreeBuilder, documentParser.getProgress());
        fXDParser.parseObject();
        return fXDTreeBuilder.m_root;
    }

    public static FXDRootElement parse(Reader reader) throws IOException, FXDException {
        return FXDParser.parse(reader, null);
    }

    public static FXDRootElement parse(InputStream inputStream, DocumentParser documentParser) throws IOException, FXDException {
        return FXDParser.parse(new InputStreamReader(inputStream, "UTF-8"), documentParser);
    }

    public static FXDRootElement parse(InputStream inputStream) throws IOException, FXDException {
        return FXDParser.parse(inputStream, null);
    }

    public static void visitObjectHierarchy(FXDElement fXDElement, NodeVisitor nodeVisitor) throws IOException, FXDException {
        if (fXDElement.getKind() == 0) {
            nodeVisitor.visitNode((FXDObjectElement)fXDElement);
        }
        Enumeration enumeration = fXDElement.children();
        while (enumeration.hasMoreElements()) {
            FXDParser.visitObjectHierarchy((FXDElement)enumeration.nextElement(), nodeVisitor);
        }
        fXDElement.release();
    }

    public Object parseValue(String string) throws FXDSyntaxErrorException, FXDException {
        return FXDParser.parseValue(string, this);
    }

    public static Object parseValue(String string, FXDParser fXDParser) throws FXDSyntaxErrorException, FXDException {
        block30: {
            int n = string.length();
            char c = string.charAt(0);
            if (c == '\"') {
                return string.substring(1, n - 1);
            }
            if (string == TRUE) {
                return Boolean.TRUE;
            }
            if (string == FALSE) {
                return Boolean.FALSE;
            }
            if (string == NULL) {
                return FXDObjectElement.NULL_VALUE;
            }
            if (c == '#') {
                if (fXDParser != null) {
                    return fXDParser.m_listener.createReference(string);
                }
            } else if (c == '$' && string.startsWith("$ref:")) {
                if (fXDParser != null) {
                    return fXDParser.m_listener.createReference(string);
                }
            } else if (c == 'b' && string.startsWith("bind")) {
                if (fXDParser != null) {
                    return fXDParser.m_listener.createReference(string);
                }
            } else {
                FXDExpression fXDExpression;
                if (c >= '0' && c <= '9' || c == '.' || c == '-' || c == '+') {
                    FXDDuration fXDDuration = FXDDuration.valueOf(string);
                    if (fXDDuration != null) {
                        return fXDDuration;
                    }
                    if (c == '0') {
                        if (n > 2 && (string.charAt(1) == 'x' || string.charAt(1) == 'X')) {
                            try {
                                return Integer.valueOf(string.substring(2), 16);
                            }
                            catch (NumberFormatException numberFormatException) {
                            }
                        } else {
                            try {
                                return Integer.valueOf(string, 8);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    if (string.indexOf(46) != -1) {
                        try {
                            return Float.valueOf(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            break block30;
                        }
                    }
                    try {
                        return Integer.valueOf(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            return new Long(Long.parseLong(string));
                        }
                        catch (NumberFormatException numberFormatException2) {
                            break block30;
                        }
                    }
                }
                if (fXDParser != null && (fXDExpression = FXDExpression.parse(string, fXDParser)) != null) {
                    return fXDExpression;
                }
            }
        }
        return string;
    }

    private static void checkVersion(String string) throws FXDVersionException {
        int n;
        String string2 = string.substring(string.indexOf("@version") + "@version".length()).trim();
        String string3 = null;
        if (string2.length() > 0) {
            for (n = 0; n < string2.length(); ++n) {
                char c = string2.charAt(n);
                if (!FXDParser.isWhitespace(c) || n <= 0) continue;
                string3 = string2.substring(0, n);
                break;
            }
            string3 = string2;
        }
        if (string3 != null) {
            n = 0;
            try {
                Float f = Float.valueOf(Float.parseFloat(string3));
                if (f.floatValue() != 1.0f && f.floatValue() != 1.2f && f.floatValue() != 1.3f) {
                    n = 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                n = 1;
            }
            if (n == 1) {
                throw new FXDVersionException("Loader does not support version '" + string3 + "' of the content. Versions 1.3, 1.2 and 1.0 are supported", string3, "1.0, 1.2 or 1.3");
            }
        }
    }

    private static boolean isWhitespace(char c) {
        return c <= ' ';
    }

    private static final class FXDRootImpl
    extends FXDNodeImpl
    implements FXDRootElement {
        private int m_childrenNum = 0;

        public FXDRootImpl(String string, DocumentParser documentParser) {
            super(string, documentParser);
        }

        public int getAllChildrenNum() {
            return this.m_childrenNum;
        }
    }

    public static final class FXDTreeBuilder
    implements ContentHandler {
        private final DocumentParser m_docParser;
        private FXDParser m_parser = null;
        private FXDRootImpl m_root = null;
        private Object m_lastElem = null;
        private Object m_context = null;

        public FXDTreeBuilder(DocumentParser documentParser) {
            this.m_docParser = documentParser;
        }

        public FXDObjectElement getRoot() {
            return this.m_root;
        }

        public Object startNode(String string, int n, boolean bl) throws FXDSyntaxErrorException {
            FXDNodeImpl fXDNodeImpl;
            if (this.m_docParser.getLoadContext().isCancelled()) {
                throw new CancelledException();
            }
            if (this.m_root == null) {
                fXDNodeImpl = this.m_root = new FXDRootImpl(string, this.m_docParser);
            } else {
                this.m_root.m_childrenNum++;
                fXDNodeImpl = bl ? new FXDExtendedNodeImpl(this.createReference(string), this.m_docParser) : new FXDNodeImpl(string, this.m_docParser);
            }
            return fXDNodeImpl;
        }

        public void attribute(Object object, String string, String string2, int n, int n2, boolean bl) throws FXDException {
            Object object2;
            this.m_context = object;
            if (string2 != null) {
                object2 = this.m_parser.parseValue(string2);
            } else {
                object2 = this.m_lastElem;
                this.m_lastElem = null;
            }
            FXDNodeImpl fXDNodeImpl = (FXDNodeImpl)object;
            if (bl) {
                fXDNodeImpl.addMetaData(string, object2);
            } else {
                fXDNodeImpl.addAttribute(string, object2);
            }
        }

        public void endNode(Object object, int n) throws FXDSyntaxErrorException {
            try {
                ((FXDNodeImpl)object).completed();
            }
            catch (FXDSyntaxErrorException fXDSyntaxErrorException) {
                FXDSyntaxErrorException fXDSyntaxErrorException2;
                if (this.m_parser != null) {
                    fXDSyntaxErrorException2 = this.m_parser.syntaxError(fXDSyntaxErrorException.getMessage());
                }
                throw fXDSyntaxErrorException2;
            }
            this.m_lastElem = object;
        }

        public Object startNodeArray(int n) {
            FXDNodeArrayImpl fXDNodeArrayImpl = new FXDNodeArrayImpl();
            return fXDNodeArrayImpl;
        }

        public void arrayElement(Object object, String string, int n, int n2) throws FXDException {
            Object object2;
            this.m_context = object;
            if (string != null) {
                object2 = this.m_parser.parseValue(string);
            } else {
                object2 = this.m_lastElem;
                this.m_lastElem = null;
            }
            ((FXDNodeArrayImpl)object).addElement(object2);
        }

        public void endNodeArray(Object object, int n) {
            this.m_lastElem = object;
            ((FXDNodeArrayImpl)object).completed();
        }

        public FXDReference createReference(String string) throws FXDSyntaxErrorException {
            FXDReference fXDReference = FXDReference.parse(string, (FXDElement)this.m_context);
            if (this.m_docParser != null) {
                try {
                    this.m_docParser.referenceFound(fXDReference);
                }
                catch (IOException iOException) {
                    throw new FXDSyntaxErrorException("Cannot handle the reference", iOException);
                }
            }
            return fXDReference;
        }

        public void parsingStarted(FXDParser fXDParser) {
            this.m_parser = fXDParser;
        }
    }

    public static interface NodeVisitor {
        public void visitNode(FXDObjectElement var1) throws IOException, FXDException;
    }
}

