/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.container.misc;

public class ProgressHandler {
    public static final int DEFAULT_INTERVAL = 1000;
    protected static final int UNKNOWN = -1;
    protected final int m_phaseNum;
    protected final int m_minInterval;
    protected final float m_phasePart;
    protected Callback m_callback;
    protected int m_phase = -1;
    protected int m_totalEventNum = -1;
    protected int m_eventNum = 0;
    protected long m_lastNotification = -1L;

    public ProgressHandler() {
        this(2, 1000);
    }

    public ProgressHandler(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("There must be at least on phase");
        }
        this.m_phaseNum = n;
        this.m_phasePart = 1.0f / (float)n;
        this.m_minInterval = n2;
    }

    public Callback getCallback() {
        return this.m_callback;
    }

    public void setCallback(Callback callback) {
        this.m_callback = callback;
    }

    public final void nextPhase(int n) {
        if (this.m_phase >= 0) {
            this.m_totalEventNum = this.m_eventNum;
            this.implProgress(true);
        }
        ++this.m_phase;
        this.m_eventNum = 0;
        this.m_totalEventNum = n;
        this.implProgress(true);
    }

    public final void phaseDone() {
        if (this.m_phase < 0) {
            throw new IllegalStateException("No phase is started yet. The nextPhase() must be called first.");
        }
        this.m_totalEventNum = this.m_eventNum;
        this.implProgress(true);
    }

    public final void event() {
        ++this.m_eventNum;
        this.implProgress(false);
    }

    public final void done(Throwable throwable) {
        this.implDone(throwable);
    }

    private void implProgress(boolean bl) {
        if (this.m_phase < 0) {
            throw new IllegalStateException("No phase is started yet. The nextPhase() must be called first.");
        }
        if (this.m_callback != null) {
            float f;
            int n;
            if (this.m_totalEventNum == 0 && this.m_eventNum == 0) {
                n = 100;
                f = (float)(this.m_phase + 1) * this.m_phasePart;
            } else if (this.m_totalEventNum != -1 && this.m_totalEventNum != 0) {
                n = (int)((long)this.m_eventNum * 100L / (long)this.m_totalEventNum);
                f = (float)this.m_phase * this.m_phasePart + (float)n / 100.0f;
            } else {
                n = -1;
                f = (float)this.m_phase * this.m_phasePart;
            }
            long l = System.currentTimeMillis();
            if (bl || l - this.m_lastNotification > (long)this.m_minInterval) {
                this.m_callback.onProgress(f, this.m_phase, n, this.m_eventNum);
                this.m_lastNotification = l;
            }
        }
    }

    private void implDone(Throwable throwable) {
        if (this.m_callback != null) {
            this.m_callback.onDone(throwable);
        }
    }

    public static interface Callback {
        public void onProgress(float var1, int var2, int var3, int var4);

        public void onDone(Throwable var1);
    }
}

