/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.container.misc;

import com.sun.javafx.tools.fxd.FXDArrayElement;
import com.sun.javafx.tools.fxd.FXDObjectElement;
import java.util.Enumeration;

public abstract class CommonContainerUtils {
    public static boolean isAbsoluteURL(String string) {
        if (string != null) {
            int n = (string = string.trim()).length() - 1;
            if (n > 10) {
                n = 10;
            }
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (CommonContainerUtils.isLetter(c)) continue;
                if (i <= 0 || c != ':') break;
                return true;
            }
        }
        return false;
    }

    public static boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static float parseNumber(Object object) {
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        if (object instanceof Double) {
            return ((Double)object).floatValue();
        }
        String string = object.toString().trim();
        if (string.startsWith("0x")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        return Float.parseFloat(string);
    }

    public static float[] parseNumbers(Object object) {
        float[] fArray;
        if (object != FXDObjectElement.NULL_VALUE) {
            FXDArrayElement fXDArrayElement = (FXDArrayElement)object;
            fArray = new float[fXDArrayElement.getLength()];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = CommonContainerUtils.parseNumber(fXDArrayElement.elementAt(i));
            }
        } else {
            fArray = null;
        }
        return fArray;
    }

    public static int parseInteger(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        String string = object.toString().trim();
        if (string.startsWith("0x")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        return Integer.parseInt(string);
    }

    public static Boolean parseBoolean(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        String string = object.toString().trim();
        return string.equals("true") ? Boolean.TRUE : Boolean.FALSE;
    }

    public static float[] duplicate(float[] fArray) {
        float[] fArray2;
        if (fArray != null) {
            fArray2 = new float[fArray.length];
            System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        } else {
            fArray2 = null;
        }
        return fArray2;
    }

    public static void dump(FXDObjectElement fXDObjectElement) {
        System.out.print("FXDNode(" + fXDObjectElement.getTypeName());
        Enumeration enumeration = fXDObjectElement.getAttrNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = fXDObjectElement.getAttrValue(string);
            System.out.print(" " + string + "=");
            if (object instanceof FXDArrayElement) {
                System.out.print("[" + ((FXDArrayElement)object).getLength() + "]");
                continue;
            }
            if (object instanceof FXDObjectElement) {
                CommonContainerUtils.dump((FXDObjectElement)object);
                continue;
            }
            System.out.print(fXDObjectElement.getAttrValue(string));
        }
        System.out.print(")");
    }

    public static void append(StringBuffer stringBuffer, Object object) {
        if (object == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append("'");
            stringBuffer.append(object.toString());
            stringBuffer.append("'");
        }
    }

    public static String toString(Object object) {
        return object != null ? object.toString() : "null";
    }

    public static long currentTimeMillis() {
        return System.nanoTime() / 1000000L;
    }

    protected CommonContainerUtils() {
    }
}

