/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.container.doc;

import com.sun.javafx.tools.fxd.FXDObjectElement;
import com.sun.javafx.tools.fxd.FXDReference;
import com.sun.javafx.tools.fxd.FXDRootElement;
import com.sun.javafx.tools.fxd.container.ContainerEntry;
import com.sun.javafx.tools.fxd.container.Context;
import com.sun.javafx.tools.fxd.container.FXDContainer;
import com.sun.javafx.tools.fxd.container.doc.DocumentParser;
import com.sun.javafx.tools.fxd.container.doc.DocumentParsingTask;
import com.sun.javafx.tools.fxd.container.misc.ProgressHandler;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDException;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDParser;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDSyntaxErrorException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class RootDocumentParser
implements DocumentParser {
    private final Context m_loadContext;
    private final ProgressHandler m_progress;
    private final List<FXDReference> m_references = new ArrayList<FXDReference>(4);
    private final List<DocumentParsingTask> m_tasks = new ArrayList<DocumentParsingTask>(4);
    private ContainerEntry m_containerContext = null;
    private int m_refIndex = 0;

    public RootDocumentParser(Context context, ProgressHandler progressHandler) {
        this.m_loadContext = context;
        this.m_progress = progressHandler;
    }

    public RootDocumentParser() {
        this(new Context(){

            public boolean isRootLevel() {
                return true;
            }

            public boolean isCancelled() {
                return false;
            }
        }, null);
    }

    public Context getLoadContext() {
        return this.m_loadContext;
    }

    public ProgressHandler getProgress() {
        return this.m_loadContext.isRootLevel() ? this.m_progress : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FXDRootElement parse(Reader reader, ContainerEntry containerEntry) throws IOException, FXDException {
        this.m_containerContext = containerEntry;
        FXDRootElement fXDRootElement = FXDParser.parse(reader, (DocumentParser)this);
        this.m_containerContext = null;
        if (this.m_references.size() > 0) {
            FXDReference fXDReference;
            int n;
            int n2;
            for (FXDReference object2 : this.m_references) {
                if (!object2.isLocal(containerEntry) || object2.resolveRerefence(fXDRootElement)) continue;
                throw new FXDSyntaxErrorException("The reference '" + object2.getText() + "' at " + object2.getContext() + " cannot be resolved");
            }
            Object var5_7 = null;
            while ((n2 = this.m_tasks.size()) > 0) {
                RootDocumentParser rootDocumentParser = this;
                synchronized (rootDocumentParser) {
                    for (n = n2 - 1; n >= 0; --n) {
                        fXDReference = this.m_tasks.get(n).getReference();
                        if (fXDReference.isResolved()) {
                            this.m_tasks.remove(n);
                            continue;
                        }
                        Throwable throwable = fXDReference.getError();
                        if (throwable == null) continue;
                        throw new FXDSyntaxErrorException(throwable);
                    }
                    if (!this.m_tasks.isEmpty()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            int n3 = 0;
            n = this.m_references.size() - 1;
            while (n >= 0) {
                fXDReference = this.m_references.get(n);
                if (!fXDReference.isResolved()) {
                    throw new IllegalStateException("The reference " + fXDReference + " is not resolved");
                }
                FXDObjectElement fXDObjectElement = fXDReference.getReferencedElement();
                if (fXDObjectElement == null) {
                    throw new IllegalStateException("The reference " + fXDReference + " has null reference");
                }
                if (fXDObjectElement.getReferenceID() == -1) {
                    fXDObjectElement.setReferenceID(this.m_refIndex++);
                }
                this.m_references.remove(n--);
                for (int i = n; i >= 0; --i) {
                    fXDReference = this.m_references.get(i);
                    if (fXDObjectElement != fXDReference.getReferencedElement()) continue;
                    this.m_references.remove(i);
                    --n;
                }
                ++n3;
            }
        }
        return fXDRootElement;
    }

    public void referenceFound(FXDReference fXDReference) throws IOException {
        this.handleReference(fXDReference, this.m_containerContext);
    }

    public void handleReference(FXDReference fXDReference, ContainerEntry containerEntry) throws IOException {
        this.m_references.add(fXDReference);
        if (!fXDReference.isLocal(containerEntry)) {
            DocumentParsingTask documentParsingTask = new DocumentParsingTask(containerEntry, fXDReference, this);
            this.m_tasks.add(documentParsingTask);
            documentParsingTask.start();
        }
    }

    public RootDocumentParser getRootParser() {
        return this;
    }

    public FXDContainer getCurrentContainer() {
        return this.m_containerContext != null ? this.m_containerContext.getContainer() : null;
    }
}

