/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.container.doc;

import com.sun.javafx.tools.fxd.container.scene.fxd.FXDSyntaxErrorException;
import java.util.ArrayList;
import java.util.List;

public abstract class PathResolver {
    protected String m_path;
    protected int m_index;
    protected List<Referenced> m_results = new ArrayList<Referenced>(4);
    protected final ResolveVisitor m_idResolver = new ResolveVisitor(){

        public Object visit(Object object, Object object2) throws Exception {
            Object object3 = null;
            String string = PathResolver.this.getID(object);
            if (string == null || string.length() == 0) {
                object3 = PathResolver.this.getChild(object, (String)object2);
            } else if (object2.equals(string)) {
                object3 = object;
            }
            return object3;
        }
    };

    protected PathResolver(String string, int n) {
        this.m_path = string;
        this.m_index = n;
    }

    protected void implResolve(Object object) throws Exception {
        int n = this.m_path.length();
        while (this.m_index < n && object != null) {
            char c = this.m_path.charAt(this.m_index);
            if (c == '/') {
                ++this.m_index;
                continue;
            }
            if (c == '*') {
                ++this.m_index;
                if (this.m_path.charAt(this.m_index) == '*') {
                    ++this.m_index;
                    this.resolveRecursiveDescent(this.fetchID(), object);
                    continue;
                }
                this.resolveRecursiveDescent(this.fetchID(), object);
                continue;
            }
            if (c == '.') {
                ++this.m_index;
                if (this.isObject(object)) {
                    String string = this.fetchID();
                    Object object2 = this.getPropertyValue(object, string);
                    if (object2 != null) {
                        if (this.isObject(object2)) {
                            object = object2;
                            continue;
                        }
                        if (this.m_index >= n) {
                            this.m_results.add(this.createReferenced(object, string));
                            continue;
                        }
                        throw new FXDSyntaxErrorException("Invalid reference: " + this.m_path);
                    }
                    throw new FXDSyntaxErrorException("Invalid reference '" + this.m_path + "' - unknown property '" + string + "'");
                }
                throw new FXDSyntaxErrorException("Invalid reference '" + this.m_path + "' - the element '" + object + "' is not an object");
            }
            object = this.getChild(object, this.fetchID());
        }
        if (object == null || !this.isObject(object)) {
            throw new FXDSyntaxErrorException("Invalid reference '" + this.m_path + "' - not an object.");
        }
        this.m_results.add(this.createReferenced(object, null));
    }

    protected String fetchID() {
        char c;
        int n;
        int n2 = this.m_path.length();
        for (n = this.m_index; n < n2 && (c = this.m_path.charAt(n)) != '/' && c != '.'; ++n) {
        }
        String string = this.m_path.substring(this.m_index, n);
        this.m_index = n;
        return string;
    }

    protected final void resolveRecursiveDescent(final String string, Object object) throws Exception {
        this.visitChildren(object, new ResolveVisitor(){

            public Object visit(Object object, Object object2) throws Exception {
                String string2;
                if (PathResolver.this.isObject(object) && string.equals(string2 = PathResolver.this.getID(object))) {
                    PathResolver.this.implResolve(object);
                }
                if (PathResolver.this.mayHaveChildren(object)) {
                    PathResolver.this.resolveRecursiveDescent(string, object);
                }
                return null;
            }
        }, null);
    }

    public final Referenced getFirstResult(Object object) throws Exception {
        this.implResolve(object);
        return this.m_results.size() > 0 ? this.m_results.get(0) : null;
    }

    protected Object getChild(Object object, String string) throws Exception {
        return this.visitChildren(object, this.m_idResolver, string);
    }

    protected abstract Object visitChildren(Object var1, ResolveVisitor var2, Object var3) throws Exception;

    protected abstract Object getPropertyValue(Object var1, String var2) throws Exception;

    protected abstract boolean isObject(Object var1);

    protected abstract String getID(Object var1);

    protected abstract boolean mayHaveChildren(Object var1);

    protected abstract Referenced createReferenced(Object var1, String var2);

    public static abstract class Referenced {
        protected final String m_propName;

        protected Referenced(String string) {
            this.m_propName = string;
        }

        public String getProperty() {
            return this.m_propName;
        }

        public boolean isPropertyReference() {
            return this.m_propName != null;
        }

        public String toString() {
            return String.format("Referenced[ ref=%s property=%s]", this.getObject(), this.m_propName);
        }

        public abstract Object getObject();
    }

    protected static interface ResolveVisitor {
        public Object visit(Object var1, Object var2) throws Exception;
    }
}

