/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.container.doc;

import com.sun.javafx.tools.fxd.FXDElement;
import com.sun.javafx.tools.fxd.FXDObjectElement;
import com.sun.javafx.tools.fxd.FXDRootElement;
import com.sun.javafx.tools.fxd.container.doc.FXDPathResolver;
import com.sun.javafx.tools.fxd.container.doc.PathResolver;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDSyntaxErrorException;

public abstract class LocalReference {
    private static final String PREFIX_MAP = "map:";
    private static final String PREFIX_SELECT = "select:";
    private static final String PREFIX_UID = "uid:";
    public static final char PATH_SEPARATOR = '/';
    public static final char WILD_CARD = '*';
    public static final int PROPERTY_DESCRIPTOR = 46;

    public abstract FXDReferenced resolve(FXDRootElement var1, FXDElement var2) throws FXDSyntaxErrorException;

    public static LocalReference createLocalRoot() {
        return new LocalReference(){

            public FXDReferenced resolve(FXDRootElement fXDRootElement, FXDElement fXDElement) throws FXDSyntaxErrorException {
                return new FXDReferenced(fXDRootElement);
            }
        };
    }

    public static LocalReference createLocalReference(String string, int n) throws FXDSyntaxErrorException {
        if (string != null) {
            if (string.startsWith(PREFIX_MAP, n)) {
                throw new RuntimeException("The map: prefix is not supported yet.");
            }
            if (string.startsWith(PREFIX_SELECT, n)) {
                return new LocalSelectReference(string, PREFIX_SELECT.length());
            }
            if (string.startsWith(PREFIX_UID, n)) {
                return new UIDReference(string, n + PREFIX_UID.length());
            }
            return new IDReference(string, n);
        }
        throw new IllegalArgumentException();
    }

    public static final class FXDReferenced
    extends PathResolver.Referenced {
        private final FXDObjectElement m_element;

        public FXDReferenced(FXDObjectElement fXDObjectElement, String string) {
            super(string);
            if (fXDObjectElement == null) {
                throw new IllegalArgumentException("Referenced element cannot be null");
            }
            this.m_element = fXDObjectElement;
        }

        public FXDReferenced(FXDObjectElement fXDObjectElement) {
            this(fXDObjectElement, null);
        }

        public FXDObjectElement getElement() {
            return this.m_element;
        }

        public Object getObject() {
            return this.m_element;
        }
    }

    private static final class IDReference
    extends PropertyReference {
        private IDReference(String string, int n) throws FXDSyntaxErrorException {
            super(string, n);
        }

        protected boolean isFound(FXDObjectElement fXDObjectElement, String string) {
            Object object = fXDObjectElement.getAttrValue("id");
            return object != null && object.equals(string);
        }

        protected String getErrorMessage() {
            return "Cound not find the element with id " + this.m_id;
        }
    }

    private static final class LocalSelectReference
    extends LocalReference {
        private final FXDPathResolver m_resolver;

        private LocalSelectReference(String string, int n) throws FXDSyntaxErrorException {
            this.m_resolver = new FXDPathResolver(string, n);
        }

        public FXDReferenced resolve(FXDRootElement fXDRootElement, FXDElement fXDElement) throws FXDSyntaxErrorException {
            try {
                return (FXDReferenced)this.m_resolver.getObject(fXDRootElement);
            }
            catch (Exception exception) {
                throw new FXDSyntaxErrorException(exception.getMessage(), exception);
            }
        }
    }

    private static abstract class PropertyReference
    extends LocalReference {
        protected final String m_id;
        protected final String m_propName;

        private PropertyReference(String string, int n) throws FXDSyntaxErrorException {
            int n2;
            if (string.charAt(n) == '\"') {
                n2 = string.indexOf(34, n + 1);
                if (n2 == -1) {
                    throw new FXDSyntaxErrorException("Invalid reference " + string);
                }
                this.m_id = string.substring(n + 1, n2);
                n2 = string.indexOf(46, n2);
            } else {
                n2 = string.indexOf(46, n);
                this.m_id = n2 == -1 ? (n == 0 ? string : string.substring(n)) : string.substring(n, n2);
            }
            this.m_propName = n2 != -1 ? string.substring(n2 + 1) : null;
        }

        public FXDReferenced resolve(FXDRootElement fXDRootElement, FXDElement fXDElement) throws FXDSyntaxErrorException {
            FXDObjectElement fXDObjectElement = this.findChildrenByID(fXDRootElement, this.m_id);
            if (fXDObjectElement != null) {
                return new FXDReferenced(fXDObjectElement, this.m_propName);
            }
            throw new FXDSyntaxErrorException(this.getErrorMessage());
        }

        protected final FXDObjectElement findChildrenByID(FXDElement fXDElement, String string) {
            Object object;
            if (fXDElement instanceof FXDObjectElement) {
                object = (FXDObjectElement)fXDElement;
                if (this.isFound((FXDObjectElement)object, string)) {
                    return object;
                }
                if (object.getTypeName() == null) {
                    return null;
                }
            }
            if (!fXDElement.isLeaf()) {
                object = fXDElement.children();
                while (object.hasMoreElements()) {
                    FXDObjectElement fXDObjectElement;
                    Object e = object.nextElement();
                    if (!(e instanceof FXDElement) || (fXDObjectElement = this.findChildrenByID((FXDElement)e, string)) == null) continue;
                    return fXDObjectElement;
                }
            }
            return null;
        }

        protected abstract boolean isFound(FXDObjectElement var1, String var2);

        protected abstract String getErrorMessage();
    }

    private static final class UIDReference
    extends PropertyReference {
        private UIDReference(String string, int n) throws FXDSyntaxErrorException {
            super(string, n);
        }

        protected boolean isFound(FXDObjectElement fXDObjectElement, String string) {
            Object object = fXDObjectElement.getMetaValue("uid");
            return object != null && object.equals(string);
        }

        protected String getErrorMessage() {
            return "Cound not find the element with meta uid " + this.m_id;
        }
    }
}

