/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.container.doc;

import com.sun.javafx.tools.fxd.FXDReference;
import com.sun.javafx.tools.fxd.FXDRootElement;
import com.sun.javafx.tools.fxd.container.ContainerEntry;
import com.sun.javafx.tools.fxd.container.Context;
import com.sun.javafx.tools.fxd.container.FXDContainer;
import com.sun.javafx.tools.fxd.container.doc.DocumentParser;
import com.sun.javafx.tools.fxd.container.doc.RootDocumentParser;
import com.sun.javafx.tools.fxd.container.misc.ContainerUtils;
import com.sun.javafx.tools.fxd.container.misc.ProgressHandler;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDException;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDParser;
import java.io.IOException;
import java.io.Reader;

public class DocumentParsingTask
extends Thread
implements DocumentParser {
    private final RootDocumentParser m_rootParser;
    private final ContainerEntry m_context;
    private final FXDReference m_ref;

    public DocumentParsingTask(ContainerEntry containerEntry, FXDReference fXDReference, DocumentParser documentParser) {
        this.m_context = containerEntry;
        this.m_ref = fXDReference;
        this.m_rootParser = documentParser.getRootParser();
        ContainerUtils.setName(this, "DocumentParsingTask");
        ContainerUtils.setDaemon(this, true);
        this.setPriority(1);
    }

    public FXDReference getReference() {
        return this.m_ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.m_ref.resolveReference(this.m_context, this);
        }
        catch (Throwable throwable) {
            this.m_ref.resolutionFailed(throwable);
        }
        finally {
            RootDocumentParser rootDocumentParser = this.m_rootParser;
            synchronized (rootDocumentParser) {
                this.m_rootParser.notifyAll();
            }
        }
    }

    public RootDocumentParser getRootParser() {
        return this.m_rootParser;
    }

    public ProgressHandler getProgress() {
        return null;
    }

    public FXDRootElement parse(Reader reader, ContainerEntry containerEntry) throws IOException, FXDException {
        return FXDParser.parse(reader, (DocumentParser)this);
    }

    public void referenceFound(FXDReference fXDReference) throws IOException {
        this.m_rootParser.handleReference(fXDReference, this.m_context);
    }

    public Context getLoadContext() {
        return this.m_rootParser.getLoadContext();
    }

    public FXDContainer getCurrentContainer() {
        return this.m_context != null ? this.m_context.getContainer() : null;
    }
}

