/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.container;

import com.sun.javafx.tools.fxd.FXDRootElement;
import com.sun.javafx.tools.fxd.container.ContainerEntry;
import com.sun.javafx.tools.fxd.container.FXDContainer;
import com.sun.javafx.tools.fxd.container.doc.DocumentParser;
import com.sun.javafx.tools.fxd.container.misc.ProgressHandler;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

final class FXDReaderContainerImpl
extends ContainerEntry
implements FXDContainer {
    private Reader m_reader;

    public FXDReaderContainerImpl(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("The reader cannot be null.");
        }
        this.m_reader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FXDRootElement getRoot(String string, DocumentParser documentParser) throws IOException, FXDException {
        this.checkMainEntry(string);
        if (this.m_reader == null) {
            throw new IOException("The getRoot() method can be called just once.");
        }
        ProgressHandler progressHandler = documentParser.getProgress();
        try {
            if (progressHandler != null) {
                progressHandler.nextPhase(-1);
            }
            FXDRootElement fXDRootElement = documentParser.parse(this.m_reader, ContainerEntry.create(this, string));
            return fXDRootElement;
        }
        finally {
            this.m_reader = null;
        }
    }

    public InputStream open(String string) throws IOException {
        this.checkMainEntry(string);
        throw new IOException(String.format("The method %s() is not implemented, use getRoot() instead.", "open"));
    }

    public String getEntryURL(String string) throws IOException {
        return null;
    }

    public InputStream open() throws IOException {
        return this.open("content.fxd");
    }

    public String getContent(String string) throws IOException {
        this.checkMainEntry(string);
        throw new IOException(String.format("The method %s() is not implemented, use getRoot() instead.", "getContent"));
    }

    public String getContent() throws IOException {
        return this.getContent("content.fxd");
    }

    public byte[] getBinary(String string) throws IOException {
        this.checkMainEntry(string);
        throw new IOException(String.format("The method %s() is not implemented, use getRoot() instead.", "getBinary"));
    }

    public void close() {
    }

    private void checkMainEntry(String string) {
        if (string != null && !"content.fxd".equals(string)) {
            throw new IllegalArgumentException("The entry" + string + " not found.");
        }
    }

    public FXDContainer getContainer() {
        return this;
    }

    public String getEntryName() {
        return "content.fxd";
    }

    public String getRelativeURL(String string) throws IOException {
        return null;
    }
}

