/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.container;

import com.sun.javafx.tools.fxd.FXDRootElement;
import com.sun.javafx.tools.fxd.container.ContainerEntry;
import com.sun.javafx.tools.fxd.container.FXDContainer;
import com.sun.javafx.tools.fxd.container.doc.DocumentParser;
import com.sun.javafx.tools.fxd.container.misc.CacheMap;
import com.sun.javafx.tools.fxd.container.misc.ContainerUtils;
import com.sun.javafx.tools.fxd.container.misc.ProgressHandler;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

abstract class AbstractFXDContainer
extends ContainerEntry
implements FXDContainer {
    private final CacheMap m_roots = new CacheMap(4);

    AbstractFXDContainer() {
    }

    public String getEntryURL(String string) throws IOException {
        if (ContainerUtils.isAbsoluteURL(string)) {
            return string;
        }
        String string2 = this.getContainerURL();
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(string2);
        char c = string2.charAt(n - 1);
        if (c == '/' && c == '\\') {
            stringBuilder.deleteCharAt(n - 1);
        }
        stringBuilder.append(this.getArchiveSeparator());
        stringBuilder.append('/');
        if (string.startsWith("{__DIR__}")) {
            c = string.charAt("{__DIR__}".length());
            if (c == '/' || c == '\\') {
                stringBuilder.append(string.substring("{__DIR__}".length() + 1));
            } else {
                stringBuilder.append(string.substring("{__DIR__}".length()));
            }
        } else {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public final InputStream open() throws IOException {
        return this.open("content.fxd");
    }

    public final String getContent() throws IOException {
        return this.getRaw("content.fxd").toString();
    }

    public final String getContent(String string) throws IOException {
        return this.getRaw(string).toString();
    }

    public final byte[] getBinary(String string) throws IOException {
        return this.getRaw(string).toByteArray();
    }

    public void close() {
        this.m_roots.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FXDRootElement getRoot(String string, DocumentParser documentParser) throws IOException, FXDException {
        if (string == null) {
            string = "content.fxd";
        }
        ProgressHandler progressHandler = documentParser.getProgress();
        FXDRootElement fXDRootElement = (FXDRootElement)this.m_roots.get(string);
        if (fXDRootElement == null) {
            if (progressHandler != null) {
                progressHandler.nextPhase(this.getSize(string));
            }
            InputStream inputStream = this.open(string);
            try {
                fXDRootElement = documentParser.parse(new InputStreamReader(inputStream, "UTF-8"), ContainerEntry.create(this, string));
            }
            finally {
                inputStream.close();
            }
            this.m_roots.put(string, fXDRootElement);
        } else if (progressHandler != null) {
            progressHandler.nextPhase(0);
        }
        return fXDRootElement;
    }

    protected String getArchiveSeparator() {
        return "";
    }

    protected ByteArrayOutputStream getRaw(String string) throws IOException {
        return this.getRaw(this.open(string));
    }

    protected abstract String getContainerURL() throws IOException;

    protected abstract ByteArrayOutputStream getRaw(InputStream var1) throws IOException;

    protected abstract int getSize(String var1) throws IOException;

    protected static final String removeMagicDirVar(String string) {
        if (string.startsWith("{__DIR__}") && (string = string.substring("{__DIR__}".length())).startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    public FXDContainer getContainer() {
        return this;
    }

    public String getEntryName() {
        return "content.fxd";
    }
}

