/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.client;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.nio.ByteBuffer;

@ServerEndpoint(value="/binecho")
public class WSCBinaryEchoServerEndpoint {
    private static final System.Logger logger = System.getLogger(WSCBinaryEchoServerEndpoint.class.getName());
    public static final String SAYS = "Binary Server says:";

    @OnMessage
    public ByteBuffer onMessage(ByteBuffer text) {
        return ByteBuffer.wrap((SAYS + IOUtil.byteBufferToString(text)).getBytes());
    }

    @OnError
    public void onError(Session session, Throwable t) throws IOException {
        logger.log(System.Logger.Level.INFO, "@OnError in " + this.getClass().getName());
        t.printStackTrace();
        String message = "Exception: " + IOUtil.printStackTrace(t);
        session.getBasicRemote().sendBinary(ByteBuffer.wrap(message.getBytes()));
    }
}

