/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpoint;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryDecoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryEncoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryStreamDecoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryStreamEncoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextDecoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextEncoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextStreamDecoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextStreamEncoder;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.common.util.StringUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpoint.SimpleConfigurator;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = 3021625862493775185L;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_ee_server_serverendpoint_web.war");
        archive.addPackages(false, Filters.exclude((Class[])new Class[]{WSClientIT.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpoint"});
        archive.addPackages(false, new String[]{"com.sun.ts.tests.websocket.common.stringbean"});
        archive.addClasses(new Class[]{IOUtil.class, StringUtil.class});
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("wsc_ee_server_serverendpoint_web");
    }

    @Test
    public void getDefaultConfiguratorTest() throws Exception {
        String[] sequence = new String[]{"default", "encoded", "decoded", "subprotocoled"};
        this.invokeDefaults(sequence, "configurator", ServerEndpointConfig.Configurator.class.getName());
    }

    @Test
    public void getDefaultEncodersTest() throws Exception {
        String[] sequence = new String[]{"default", "configured", "decoded", "subprotocoled"};
        this.invokeDefaults(sequence, "encoders", "{}");
    }

    @Test
    public void getDefaultDecodersTest() throws Exception {
        String[] sequence = new String[]{"default", "encoded", "configured", "subprotocoled"};
        this.invokeDefaults(sequence, "decoders", "{}");
    }

    @Test
    public void getDefaultSubprotocolsTest() throws Exception {
        String[] sequence = new String[]{"default", "encoded", "configured", "decoded"};
        this.invokeDefaults(sequence, "subprotocols", "{}");
    }

    @Test
    public void getDefaultValueTest() throws Exception {
        String[] sequence = new String[]{"default", "encoded", "configured", "decoded", "subprotocoled"};
        this.invokeValues(sequence, "value");
    }

    @Test
    public void getEncodersTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("encoded"));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, "encoders");
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, StringBeanBinaryEncoder.class.getName());
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, StringBeanBinaryStreamEncoder.class.getName());
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, StringBeanTextEncoder.class.getName());
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, StringBeanTextStreamEncoder.class.getName());
        this.invoke();
    }

    @Test
    public void getDecodersTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("decoded"));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, "decoders");
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, StringBeanBinaryDecoder.class.getName());
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, StringBeanBinaryStreamDecoder.class.getName());
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, StringBeanTextDecoder.class.getName());
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, StringBeanTextStreamDecoder.class.getName());
        this.invoke();
    }

    @Test
    public void getSubprotocolsTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("subprotocoled"));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, "subprotocols");
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, "abc");
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, "def");
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, "ghi");
        this.invoke();
    }

    @Test
    public void getConfiguratorTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("configured"));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, "configurator");
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, SimpleConfigurator.class.getName());
        this.invoke();
    }

    @Test
    public void countConfigurationInstancesTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("countone"));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, "any");
        this.invoke();
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("counttwo"));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, "any");
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, "2");
        this.invoke();
    }

    private void invokeDefaults(String[] endpointSequence, String content, String search) throws Exception {
        for (String endpoint : endpointSequence) {
            this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(endpoint));
            this.setProperty(WebSocketCommonClient.Property.CONTENT, content);
            this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, search);
            this.invoke();
        }
    }

    private void invokeValues(String[] endpointSequence, String content) throws Exception {
        for (String endpoint : endpointSequence) {
            this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(endpoint));
            this.setProperty(WebSocketCommonClient.Property.CONTENT, content);
            this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, endpoint);
            this.invoke();
        }
    }
}

