/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.server.handshakerequest;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.impl.ClientConfigurator;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.common.util.StringUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.handshakerequest.CaseInsensitiveHeaderNamesConfigurator;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.HandshakeResponse;
import java.io.IOException;
import java.util.Collection;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSCClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = 6725664656725817177L;
    static final String KEY = "aFirstKey";
    static final String[] HEADERS = new String[]{"header1", "header2", "header3", "header4", "header5", "header6", "header7", "header8"};

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_ee_jakarta_websocket_handshakerequest_web.war");
        archive.addPackages(true, Filters.exclude((Class[])new Class[]{WSCClientIT.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.server.handshakerequest"});
        archive.addPackages(true, new String[]{"com.sun.ts.tests.websocket.common.stringbean"});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public WSCClientIT() throws Exception {
        this.setContextRoot("wsc_ee_jakarta_websocket_handshakerequest_web");
    }

    @Test
    public void getHeadersIsReadonlyTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator(){

            @Override
            public void afterResponse(HandshakeResponse hr) {
                super.afterResponse(hr);
                boolean contains = hr.getHeaders().containsKey("GetQueryStringConfigurator");
                1.assertTrue(!contains, "HandshakeRequest.getHeaders is not readonly, it contains [", "GetQueryStringConfigurator", ",", StringUtil.collectionToString((Collection)hr.getHeaders().get("GetQueryStringConfigurator")), "]");
                WebSocketCommonClient.logMsg("HandshakeRequest.getHeaders is readonly as expected");
            }
        };
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("readonlygetheaders", (Object)"anything", "anything");
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getHeadersHasCaseInsensitiveNamesTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToRequest("caseInsensitiveKey", CaseInsensitiveHeaderNamesConfigurator.REQUEST_VALUES);
        configurator.addToResponse("isCaseSensitive", String.valueOf(true));
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("caseinsensitiveheadernames", (Object)"anything", "anything");
        configurator.assertBeforeRequestHasBeenCalled();
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getParameterMapIsUnmodifiableTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator(){

            @Override
            public void afterResponse(HandshakeResponse hr) {
                super.afterResponse(hr);
                boolean contains = hr.getHeaders().containsKey("ReadOnlyKey");
                2.assertTrue(!contains, "HandshakeRequest.getParameterMap is not readonly, it contains [", "ReadOnlyKey", ",", StringUtil.collectionToString((Collection)hr.getHeaders().get("ReadOnlyKey")), "]");
                WebSocketCommonClient.logMsg("HandshakeRequest.getParameterMap is readonly as expected");
            }
        };
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("readonlygetparams", (Object)"anything", "anything");
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getParameterMapOneParamTest() throws Exception {
        String param = "firstParam";
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("first", param);
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, param);
        this.invoke("getoneparam/" + param, (Object)"anything", "anything");
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getParameterMapOneParamOneQueryParamTest() throws Exception {
        String param = "firstParam";
        String queryParam = "secondParam";
        String query = "?second=" + queryParam + "&second=" + param;
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("second", queryParam, param);
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, param);
        this.invoke("getoneparam/" + param + query, (Object)"anything", "anything");
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getParameterMapTwoParamsTest() throws Exception {
        String[] params = new String[]{String.valueOf(123L), String.valueOf(123.456)};
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("first", params[0]);
        configurator.addToResponse("second", params[1]);
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, params[0]);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, params[1]);
        this.invoke("gettwoparams/" + params[0] + "/" + params[1], (Object)"anything", "anything");
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getQueryStringTest() throws Exception {
        String query = "abc=123&def=456";
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("GetQueryStringConfigurator", query);
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("getquerystring?" + query, (Object)"anything", "anything");
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getRequestUriTest() throws Exception {
        String uri = "getrequesturi";
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("GetRequestUriConfigurator", uri);
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke(uri, (Object)"anything", "anything");
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getUserPrincipalNotAuthenticatedTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("GetUserPrincipalNotAuthenticatedConfigurator", String.valueOf(true));
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("getuserprincipal", (Object)"anything", "anything");
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void isUserInRoleNotAuthenticatedTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("IsUserInRoleNotAuthenticatedConfigurator", String.valueOf(false));
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("isuserinrole", (Object)"anything", "anything");
        configurator.assertAfterResponseHasBeenCalled();
    }
}

