/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.basic;

import com.sun.ts.tests.websocket.common.client.BinaryAndTextClientEndpoint;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.impl.WaitingSendHandler;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.OPS;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.WSCBinaryClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.WSCBinaryStreamClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.WSCSuperEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.WSCTextClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.WSCTextStreamClientEndpoint;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = 7637718042723179933L;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_ee_jakarta_websocket_remoteendpoint_usercoder_basic_web.war");
        archive.addPackages(false, Filters.exclude((Class[])new Class[]{WSClientIT.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.basic"});
        archive.addPackages(false, new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder"});
        archive.addPackages(true, new String[]{"com.sun.ts.tests.websocket.common.stringbean"});
        archive.addClasses(new Class[]{WaitingSendHandler.class});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("wsc_ee_jakarta_websocket_remoteendpoint_usercoder_basic_web");
    }

    @Test
    public void sendObjectBooleanTextEncoderOnServerTest() throws Exception {
        this.invoke("text", OPS.BOOL, "Anything that should have been coded has been coded into this");
    }

    @Test
    public void sendObjectCharTextEncoderOnServerTest() throws Exception {
        this.invoke("text", OPS.CHAR, "Anything that should have been coded has been coded into this");
    }

    @Test
    public void sendObjectNumberTextEncoderOnServerTest() throws Exception {
        this.invoke("text", OPS.BYTE, "Anything that should have been coded has been coded into this");
        this.invoke("text", OPS.SHORT, "Anything that should have been coded has been coded into this");
        this.invoke("text", OPS.INT, "Anything that should have been coded has been coded into this");
        this.invoke("text", OPS.LONG, "Anything that should have been coded has been coded into this");
        this.invoke("text", OPS.FLOAT, "Anything that should have been coded has been coded into this");
        this.invoke("text", OPS.DOUBLE, "Anything that should have been coded has been coded into this");
    }

    @Test
    public void sendObjectBooleanTextEncoderOnClientTest() throws Exception {
        WSCTextClientEndpoint client = new WSCTextClientEndpoint();
        this.setAnnotatedClientEndpoint(client);
        this.invoke("echo", (Object)true, "Anything that should have been coded has been coded into this");
    }

    @Test
    public void sendObjectCharTextEncoderOnClientTest() throws Exception {
        WSCTextClientEndpoint client = new WSCTextClientEndpoint();
        this.setAnnotatedClientEndpoint(client);
        this.invoke("echo", (Object)Character.valueOf('1'), "Anything that should have been coded has been coded into this");
    }

    @Test
    public void sendObjectNumberTextEncoderOnClientTest() throws Exception {
        WSCTextClientEndpoint client = new WSCTextClientEndpoint();
        this.setAnnotatedClientEndpoint(client);
        this.invoke("echo", (Object)WSCSuperEndpoint.NUMERIC, "Anything that should have been coded has been coded into this");
        this.setAnnotatedClientEndpoint(client);
        this.invoke("echo", (Object)WSCSuperEndpoint.NUMERIC.shortValue(), "Anything that should have been coded has been coded into this");
        this.setAnnotatedClientEndpoint(client);
        this.invoke("echo", (Object)WSCSuperEndpoint.NUMERIC.intValue(), "Anything that should have been coded has been coded into this");
        this.setAnnotatedClientEndpoint(client);
        this.invoke("echo", (Object)WSCSuperEndpoint.NUMERIC.longValue(), "Anything that should have been coded has been coded into this");
        this.setAnnotatedClientEndpoint(client);
        this.invoke("echo", (Object)WSCSuperEndpoint.NUMERIC.doubleValue(), "Anything that should have been coded has been coded into this");
        this.setAnnotatedClientEndpoint(client);
        this.invoke("echo", (Object)Float.valueOf(WSCSuperEndpoint.NUMERIC.floatValue()), "Anything that should have been coded has been coded into this");
    }

    @Test
    public void sendObjectPrimitivesTextStreamEncoderOnServerTest() throws Exception {
        for (OPS op : OPS.values()) {
            this.invoke("textstream", op, "Anything that should have been coded has been coded into this");
        }
    }

    @Test
    public void sendObjectPrimitivesTextStreamEncoderOnClientTest() throws Exception {
        WSCTextStreamClientEndpoint client = new WSCTextStreamClientEndpoint();
        for (Object entity : OPS.getClientEntities()) {
            this.setAnnotatedClientEndpoint(client);
            this.invoke("echo", entity, "Anything that should have been coded has been coded into this");
        }
    }

    @Test
    public void sendObjectPrimitivesBinaryEncoderOnServerTest() throws Exception {
        for (OPS op : OPS.values()) {
            this.setClientEndpoint(BinaryAndTextClientEndpoint.class);
            this.invoke("binary", op, "Anything that should have been coded has been coded into this");
        }
    }

    @Test
    public void sendObjectPrimitivesBinaryEncoderOnClientTest() throws Exception {
        WSCBinaryClientEndpoint client = new WSCBinaryClientEndpoint();
        for (Object entity : OPS.getClientEntities()) {
            this.setAnnotatedClientEndpoint(client);
            this.invoke("echo", entity, "Anything that should have been coded has been coded into this");
        }
    }

    @Test
    public void sendObjectPrimitivesBinaryStreamEncoderOnServerTest() throws Exception {
        for (OPS op : OPS.values()) {
            this.setClientEndpoint(BinaryAndTextClientEndpoint.class);
            this.invoke("binarystream", op, "Anything that should have been coded has been coded into this");
        }
    }

    @Test
    public void sendObjectPrimitivesBinaryStreamEncoderOnClientTest() throws Exception {
        WSCBinaryStreamClientEndpoint client = new WSCBinaryStreamClientEndpoint();
        for (Object entity : OPS.getClientEntities()) {
            this.setAnnotatedClientEndpoint(client);
            this.invoke("echo", entity, "Anything that should have been coded has been coded into this");
        }
    }
}

