/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.async;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.OPS;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.WSCSuperEndpoint;
import jakarta.websocket.EncodeException;
import jakarta.websocket.Session;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class WSCCommonServer
implements WSCSuperEndpoint {
    private static final System.Logger logger = System.getLogger(WSCCommonServer.class.getName());

    public void onMessage(String msg, Session session) throws IOException, EncodeException, InterruptedException, ExecutionException {
        OPS op = OPS.valueOf(msg);
        Future future = null;
        switch (op) {
            case BOOL: {
                future = session.getAsyncRemote().sendObject((Object)true);
                break;
            }
            case BYTE: {
                future = session.getAsyncRemote().sendObject((Object)NUMERIC);
                break;
            }
            case CHAR: {
                future = session.getAsyncRemote().sendObject((Object)Character.valueOf('1'));
                break;
            }
            case DOUBLE: {
                future = session.getAsyncRemote().sendObject((Object)NUMERIC.doubleValue());
                break;
            }
            case FLOAT: {
                future = session.getAsyncRemote().sendObject((Object)Float.valueOf(NUMERIC.floatValue()));
                break;
            }
            case INT: {
                future = session.getAsyncRemote().sendObject((Object)NUMERIC.intValue());
                break;
            }
            case LONG: {
                future = session.getAsyncRemote().sendObject((Object)NUMERIC.longValue());
                break;
            }
            case SHORT: {
                future = session.getAsyncRemote().sendObject((Object)NUMERIC.shortValue());
            }
        }
        future.get();
    }

    public void onError(Session session, Throwable t) throws IOException {
        logger.log(System.Logger.Level.INFO, "@OnError in " + this.getClass().getName());
        t.printStackTrace();
        String message = "Exception: " + IOUtil.printStackTrace(t);
        session.getBasicRemote().sendText(message);
    }
}

