/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.async;

import com.sun.ts.tests.websocket.common.impl.WaitingSendHandler;
import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextEncoder;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.async.OPS;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.async.ThrowingBinaryCoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.async.ThrowingStringBean;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.async.ThrowingStringBeanEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.async.ThrowingTextCoder;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.SendHandler;
import jakarta.websocket.SendResult;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

@ServerEndpoint(value="/throwing", encoders={ThrowingBinaryCoder.class, ThrowingTextCoder.class, StringBeanTextEncoder.class, ThrowingStringBeanEncoder.class})
public class WSCThrowingServerSideServer {
    private static final System.Logger logger = System.getLogger(WSCThrowingServerSideServer.class.getName());
    static final String[] RESPONSE = new String[]{"OK", "FAIL"};

    @OnMessage
    public StringBean onMessage(String msg, Session session) {
        RemoteEndpoint.Async asyncRemote = session.getAsyncRemote();
        OPS op = OPS.valueOf(msg.toUpperCase());
        switch (op) {
            case SENDBINARYEXECUTIONEXCEPTION: {
                msg = WSCThrowingServerSideServer.sendBinaryHasExecutionException(asyncRemote);
                break;
            }
            case SENDOBJECTEXECUTIONEXCEPTION: {
                msg = WSCThrowingServerSideServer.sendObjectHasExecutionException(asyncRemote);
                break;
            }
            case SENDOBJECTHANDLEREXECUTIONEXCEPTION: {
                msg = WSCThrowingServerSideServer.sendObjectWithSendHandlerHasExecutionException(asyncRemote);
                break;
            }
            default: {
                throw new IllegalArgumentException("Method " + msg + " not implemented");
            }
        }
        return new StringBean(msg);
    }

    @OnError
    public void onError(Session session, Throwable t) throws IOException {
        logger.log(System.Logger.Level.INFO, "@OnError in " + this.getClass().getName());
        t.printStackTrace();
        String message = "Exception: " + IOUtil.printStackTrace(t);
        session.getBasicRemote().sendText(message);
    }

    public static String sendBinaryHasExecutionException(RemoteEndpoint.Async asyncRemote) {
        Future future = asyncRemote.sendBinary(ByteBuffer.wrap(OPS.SENDBINARYEXECUTIONEXCEPTION.name().getBytes()));
        try {
            future.get();
            return RESPONSE[1];
        }
        catch (ExecutionException e) {
            return RESPONSE[0];
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static String sendObjectHasExecutionException(RemoteEndpoint.Async asyncRemote) {
        Future future = asyncRemote.sendObject((Object)new ThrowingStringBean());
        try {
            future.get();
            return RESPONSE[1];
        }
        catch (ExecutionException e) {
            return RESPONSE[0];
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static String sendObjectWithSendHandlerHasExecutionException(RemoteEndpoint.Async asyncRemote) {
        WaitingSendHandler handler = new WaitingSendHandler();
        asyncRemote.sendObject((Object)new ThrowingStringBean(), (SendHandler)handler);
        SendResult result = handler.waitForResult(10L);
        return !result.isOK() && result.getException() != null ? RESPONSE[0] : RESPONSE[1];
    }
}

