/*
 * Decompiled with CFR 0.152.
 */
package jakarta.persistence.sql;

import jakarta.persistence.Tuple;
import jakarta.persistence.sql.MappingElement;
import jakarta.persistence.sql.ResultSetMapping;
import java.util.Objects;

public record TupleMapping(MappingElement<?>[] elements) implements ResultSetMapping<Tuple>
{
    public TupleMapping {
        Objects.requireNonNull(elements, "elements are required");
        if (elements.length == 0) {
            throw new IllegalArgumentException("at least one element is required");
        }
        for (MappingElement<?> element : elements) {
            Objects.requireNonNull(element, "element is required");
        }
    }

    public static TupleMapping of(MappingElement<?> ... elements) {
        return new TupleMapping(elements);
    }

    @Override
    public Class<Tuple> type() {
        return Tuple.class;
    }
}

