/*
 * Decompiled with CFR 0.152.
 */
package jakarta.persistence.sql;

import jakarta.persistence.LockModeType;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.sql.ColumnMapping;
import jakarta.persistence.sql.CompoundMapping;
import jakarta.persistence.sql.ConstructorMapping;
import jakarta.persistence.sql.EmbeddedMapping;
import jakarta.persistence.sql.EntityMapping;
import jakarta.persistence.sql.FieldMapping;
import jakarta.persistence.sql.MappingElement;
import jakarta.persistence.sql.MemberMapping;
import jakarta.persistence.sql.TupleMapping;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ResultSetMapping<T> {
    public Class<T> type();

    public static <T> ColumnMapping<T> column(String columnName, Class<T> type) {
        return ColumnMapping.of(columnName, type);
    }

    public static ColumnMapping<Object> column(String columnName) {
        return ColumnMapping.of(columnName);
    }

    public static <T> ConstructorMapping<T> constructor(Class<T> targetClass, MappingElement<?> ... arguments) {
        return ConstructorMapping.of(targetClass, arguments);
    }

    public static CompoundMapping compound(MappingElement<?> ... elements) {
        return CompoundMapping.of(elements);
    }

    public static TupleMapping tuple(MappingElement<?> ... elements) {
        return TupleMapping.of(elements);
    }

    @SafeVarargs
    public static <T> EntityMapping<T> entity(Class<T> entityClass, MemberMapping<T> ... fields) {
        return EntityMapping.of(entityClass, fields);
    }

    @SafeVarargs
    public static <T> EntityMapping<T> entity(Class<T> entityClass, String discriminatorColumn, MemberMapping<T> ... fields) {
        return EntityMapping.of(entityClass, discriminatorColumn, fields);
    }

    @SafeVarargs
    public static <T> EntityMapping<T> entity(Class<T> entityClass, LockModeType lockMode, String discriminatorColumn, MemberMapping<T> ... fields) {
        return EntityMapping.of(entityClass, lockMode, discriminatorColumn, fields);
    }

    @SafeVarargs
    public static <C, T> EmbeddedMapping<C, T> embedded(Class<C> container, Class<T> embeddableClass, String name, MemberMapping<T> ... fields) {
        return EmbeddedMapping.of(container, embeddableClass, name, fields);
    }

    @SafeVarargs
    public static <C, T> EmbeddedMapping<C, T> embedded(SingularAttribute<C, T> embedded, MemberMapping<T> ... fields) {
        return EmbeddedMapping.of(embedded, fields);
    }

    public static <C, T> FieldMapping<C, T> field(Class<C> container, Class<T> type, String name, String columnName) {
        return FieldMapping.of(container, type, name, columnName);
    }

    public static <C, T> FieldMapping<C, T> field(SingularAttribute<C, T> attribute, String columnName) {
        return FieldMapping.of(attribute, columnName);
    }
}

