/*
 * Decompiled with CFR 0.152.
 */
package jakarta.persistence.sql;

import jakarta.persistence.LockModeType;
import jakarta.persistence.sql.MappingElement;
import jakarta.persistence.sql.MemberMapping;
import jakarta.persistence.sql.ResultSetMapping;
import java.util.Objects;

public record EntityMapping<T>(Class<T> entityClass, LockModeType lockMode, String discriminatorColumn, MemberMapping<?>[] fields) implements MappingElement<T>,
ResultSetMapping<T>
{
    public EntityMapping {
        Objects.requireNonNull(entityClass, "entityClass is required");
        Objects.requireNonNull(lockMode, "lockMode is required");
        if (discriminatorColumn != null && discriminatorColumn.isBlank()) {
            throw new IllegalArgumentException("discriminatorColumn may not be blank");
        }
        Objects.requireNonNull(fields, "fields are required");
        for (MemberMapping<?> field : fields) {
            Objects.requireNonNull(field, "field is required");
        }
    }

    @Override
    public Class<T> getJavaType() {
        return this.entityClass;
    }

    @Override
    public String getAlias() {
        return null;
    }

    @SafeVarargs
    public static <T> EntityMapping<T> of(Class<T> entityClass, MemberMapping<T> ... fields) {
        return new EntityMapping<T>(entityClass, LockModeType.NONE, null, fields);
    }

    @SafeVarargs
    public static <T> EntityMapping<T> of(Class<T> entityClass, String discriminatorColumn, MemberMapping<T> ... fields) {
        return new EntityMapping<T>(entityClass, LockModeType.NONE, discriminatorColumn, fields);
    }

    @SafeVarargs
    public static <T> EntityMapping<T> of(Class<T> entityClass, LockModeType lockMode, String discriminatorColumn, MemberMapping<T> ... fields) {
        return new EntityMapping<T>(entityClass, lockMode, discriminatorColumn, fields);
    }

    @Override
    public Class<T> type() {
        return this.entityClass;
    }
}

