/*
 * Decompiled with CFR 0.152.
 */
package jakarta.persistence.sql;

import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.sql.MemberMapping;
import java.util.Objects;

public record EmbeddedMapping<C, T>(Class<C> container, Class<T> embeddableClass, String name, MemberMapping<?>[] fields) implements MemberMapping<C>
{
    public EmbeddedMapping {
        Objects.requireNonNull(container, "container is required");
        Objects.requireNonNull(embeddableClass, "embeddableClass is required");
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(fields, "fields are required");
        for (MemberMapping<?> field : fields) {
            Objects.requireNonNull(field, "field is required");
        }
    }

    @SafeVarargs
    public static <C, T> EmbeddedMapping<C, T> of(Class<C> container, Class<T> embeddableClass, String name, MemberMapping<T> ... fields) {
        return new EmbeddedMapping<C, T>(container, embeddableClass, name, fields);
    }

    @SafeVarargs
    public static <C, T> EmbeddedMapping<C, T> of(SingularAttribute<C, T> embedded, MemberMapping<T> ... fields) {
        return new EmbeddedMapping(embedded.getDeclaringType().getJavaType(), embedded.getJavaType(), embedded.getName(), fields);
    }
}

