/*
 * Decompiled with CFR 0.152.
 */
package jakarta.persistence.query;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.LockModeType;
import jakarta.persistence.PessimisticLockScope;
import jakarta.persistence.Timeout;
import jakarta.persistence.TypedQueryReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class StaticTypedQueryReference<R>
implements TypedQueryReference<R> {
    private final Class<?> annotatedClass;
    private final String annotatedMemberName;
    private final Class<R> resultType;
    private final String name;
    private final List<Class<?>> parameterTypes;
    private final List<String> parameterNames;
    private final List<Object> arguments;
    private final Map<String, Object> hints;
    private final CacheRetrieveMode cacheRetrieveMode;
    private final CacheStoreMode cacheStoreMode;
    private final LockModeType lockMode;
    private final PessimisticLockScope lockScope;
    private final Timeout timeout;
    private final String entityGraphName;

    public StaticTypedQueryReference(String queryName, Class<?> annotatedClass, String annotatedMemberName, Class<R> resultType, List<Class<?>> parameterTypes, List<String> parameterNames, List<Object> arguments, CacheRetrieveMode cacheRetrieveMode, CacheStoreMode cacheStoreMode, LockModeType lockMode, PessimisticLockScope lockScope, Timeout timeout, String entityGraphName, Map<String, Object> hints) {
        this.name = queryName;
        this.annotatedClass = annotatedClass;
        this.annotatedMemberName = annotatedMemberName;
        this.resultType = resultType;
        this.parameterTypes = parameterTypes;
        this.parameterNames = parameterNames;
        this.arguments = arguments;
        this.cacheRetrieveMode = cacheRetrieveMode;
        this.cacheStoreMode = cacheStoreMode;
        this.lockMode = lockMode;
        this.lockScope = lockScope;
        this.timeout = timeout;
        this.entityGraphName = entityGraphName;
        this.hints = hints;
    }

    public StaticTypedQueryReference(String queryName, Class<?> annotatedClass, String annotatedMemberName, Class<R> resultType, List<Class<?>> parameterTypes, List<String> parameterNames, List<Object> arguments) {
        this(queryName, annotatedClass, annotatedMemberName, resultType, parameterTypes, parameterNames, arguments, null, null, LockModeType.NONE, PessimisticLockScope.NORMAL, null, null, Collections.emptyMap());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<? extends R> getResultType() {
        return this.resultType;
    }

    @Override
    public Map<String, Object> getHints() {
        return this.hints;
    }

    @Override
    public List<Class<?>> getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    @Override
    public List<Object> getArguments() {
        return this.arguments;
    }

    public Class<?> getAnnotatedClass() {
        return this.annotatedClass;
    }

    public String getAnnotatedMemberName() {
        return this.annotatedMemberName;
    }

    @Override
    public CacheRetrieveMode getCacheRetrieveMode() {
        return this.cacheRetrieveMode;
    }

    @Override
    public CacheStoreMode getCacheStoreMode() {
        return this.cacheStoreMode;
    }

    @Override
    public LockModeType getLockMode() {
        return this.lockMode;
    }

    @Override
    public PessimisticLockScope getPessimisticLockScope() {
        return this.lockScope;
    }

    @Override
    public Timeout getTimeout() {
        return this.timeout;
    }

    @Override
    public String getEntityGraphName() {
        return this.entityGraphName;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StaticTypedQueryReference)) {
            return false;
        }
        StaticTypedQueryReference that = (StaticTypedQueryReference)obj;
        return Objects.equals(this.resultType, that.resultType) && Objects.equals(this.name, that.name) && Objects.equals(this.parameterTypes, that.parameterTypes) && Objects.equals(this.parameterNames, that.parameterNames) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.cacheRetrieveMode, that.cacheRetrieveMode) && Objects.equals(this.cacheStoreMode, that.cacheStoreMode) && Objects.equals(this.lockMode, that.lockMode) && Objects.equals(this.lockScope, that.lockScope) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.hints, that.hints);
    }

    public int hashCode() {
        return Objects.hash(this.resultType, this.name, this.parameterTypes, this.parameterNames, this.arguments);
    }

    public String toString() {
        return "StaticQueryReference[resultType=" + String.valueOf(this.resultType) + ", name=" + this.name + ", parameterNames=" + String.valueOf(this.parameterNames) + ", arguments=" + String.valueOf(this.arguments) + ", options=" + String.valueOf(List.of(this.cacheRetrieveMode, this.cacheStoreMode, this.lockMode, this.lockScope, this.timeout)) + "hints=" + String.valueOf(this.hints) + "]";
    }
}

