/*
 * Decompiled with CFR 0.152.
 */
package jakarta.persistence.query;

import jakarta.persistence.StatementReference;
import jakarta.persistence.Timeout;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class StaticStatementReference
implements StatementReference {
    private final Class<?> annotatedClass;
    private final String annotatedMemberName;
    private final String name;
    private final List<Class<?>> parameterTypes;
    private final List<String> parameterNames;
    private final List<Object> arguments;
    private final Timeout timeout;
    private final Map<String, Object> hints;

    public StaticStatementReference(String queryName, Class<?> annotatedClass, String annotatedMemberName, List<Class<?>> parameterTypes, List<String> parameterNames, List<Object> arguments, Timeout timeout, Map<String, Object> hints) {
        this.name = queryName;
        this.annotatedClass = annotatedClass;
        this.annotatedMemberName = annotatedMemberName;
        this.parameterTypes = parameterTypes;
        this.parameterNames = parameterNames;
        this.arguments = arguments;
        this.timeout = timeout;
        this.hints = hints;
    }

    public StaticStatementReference(String queryName, Class<?> annotatedClass, String annotatedMemberName, List<Class<?>> parameterTypes, List<String> parameterNames, List<Object> arguments) {
        this(queryName, annotatedClass, annotatedMemberName, parameterTypes, parameterNames, arguments, null, Collections.emptyMap());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, Object> getHints() {
        return this.hints;
    }

    @Override
    public List<Class<?>> getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    @Override
    public List<Object> getArguments() {
        return this.arguments;
    }

    public Class<?> getAnnotatedClass() {
        return this.annotatedClass;
    }

    public String getAnnotatedMemberName() {
        return this.annotatedMemberName;
    }

    @Override
    public Timeout getTimeout() {
        return this.timeout;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StaticStatementReference)) {
            return false;
        }
        StaticStatementReference that = (StaticStatementReference)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.parameterTypes, that.parameterTypes) && Objects.equals(this.parameterNames, that.parameterNames) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.hints, that.hints);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parameterTypes, this.parameterNames, this.arguments);
    }

    public String toString() {
        return "StaticQueryReference[name=" + this.name + ", parameterNames=" + String.valueOf(this.parameterNames) + ", arguments=" + String.valueOf(this.arguments) + ", timeout=" + String.valueOf(this.timeout) + ", hints=" + String.valueOf(this.hints) + "]";
    }
}

