/*
 * Decompiled with CFR 0.152.
 */
package jakarta.persistence;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.FetchType;
import jakarta.persistence.Persistence;
import jakarta.persistence.PersistenceUnitTransactionType;
import jakarta.persistence.SchemaManagementAction;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PersistenceConfiguration
implements Persistence.JdbcProperties,
Persistence.ConnectionProperties,
Persistence.DatabaseProperties,
Persistence.SchemaManagementProperties,
Persistence.ValidationProperties,
Persistence.CacheProperties,
Persistence.BeanManagementProperties {
    private final String name;
    private String provider;
    private String jtaDataSource;
    private String nonJtaDataSource;
    private SharedCacheMode sharedCacheMode = SharedCacheMode.UNSPECIFIED;
    private ValidationMode validationMode = ValidationMode.AUTO;
    private PersistenceUnitTransactionType transactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
    private FetchType defaultToOneFetchType = FetchType.EAGER;
    private SchemaManagementAction schemaManagementDatabaseAction = SchemaManagementAction.NONE;
    private SchemaManagementAction schemaManagementScriptsAction = SchemaManagementAction.NONE;
    private final List<Class<?>> managedClasses = new ArrayList();
    private final List<String> mappingFileNames = new ArrayList<String>();
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public PersistenceConfiguration(String name) {
        Objects.requireNonNull(name, "Persistence unit name should not be null");
        this.name = name;
    }

    public EntityManagerFactory createEntityManagerFactory() {
        return Persistence.createEntityManagerFactory(this);
    }

    public void exportSchema() {
        Persistence.generateSchema(this);
    }

    public String name() {
        return this.name;
    }

    public PersistenceConfiguration provider(String providerClassName) {
        this.provider = providerClassName;
        return this;
    }

    public String provider() {
        return this.provider;
    }

    public PersistenceConfiguration jtaDataSource(String dataSourceJndiName) {
        this.jtaDataSource = dataSourceJndiName;
        return this;
    }

    public String jtaDataSource() {
        return this.jtaDataSource;
    }

    public PersistenceConfiguration nonJtaDataSource(String dataSourceJndiName) {
        this.nonJtaDataSource = dataSourceJndiName;
        return this;
    }

    public String nonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public PersistenceConfiguration managedClass(Class<?> managedClass) {
        this.managedClasses.add(managedClass);
        return this;
    }

    public List<Class<?>> managedClasses() {
        return this.managedClasses;
    }

    public PersistenceConfiguration mappingFile(String name) {
        this.mappingFileNames.add(name);
        return this;
    }

    public List<String> mappingFiles() {
        return this.mappingFileNames;
    }

    public PersistenceConfiguration transactionType(PersistenceUnitTransactionType transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    public PersistenceUnitTransactionType transactionType() {
        return this.transactionType;
    }

    public PersistenceConfiguration sharedCacheMode(SharedCacheMode sharedCacheMode) {
        this.sharedCacheMode = sharedCacheMode;
        return this;
    }

    public SharedCacheMode sharedCacheMode() {
        return this.sharedCacheMode;
    }

    public PersistenceConfiguration validationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
        return this;
    }

    public ValidationMode validationMode() {
        return this.validationMode;
    }

    public PersistenceConfiguration defaultToOneFetchType(FetchType defaultToOneFetchType) {
        if (defaultToOneFetchType == null || defaultToOneFetchType == FetchType.DEFAULT) {
            throw new IllegalArgumentException("defaultToOneFetchType: " + String.valueOf((Object)defaultToOneFetchType));
        }
        this.defaultToOneFetchType = defaultToOneFetchType;
        return this;
    }

    public FetchType defaultToOneFetchType() {
        return this.defaultToOneFetchType;
    }

    public PersistenceConfiguration schemaManagementDatabaseAction(SchemaManagementAction action) {
        this.schemaManagementDatabaseAction = action;
        return this;
    }

    public SchemaManagementAction schemaManagementDatabaseAction() {
        return this.schemaManagementDatabaseAction;
    }

    public PersistenceConfiguration schemaManagementScriptsAction(SchemaManagementAction action) {
        this.schemaManagementScriptsAction = action;
        return this;
    }

    public SchemaManagementAction getSchemaManagementScriptsAction() {
        return this.schemaManagementScriptsAction;
    }

    public PersistenceConfiguration property(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    public PersistenceConfiguration properties(Map<String, ?> properties) {
        this.properties.putAll(properties);
        return this;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }
}

