/*
 * Decompiled with CFR 0.152.
 */
package jakarta.persistence;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceConfiguration;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PersistenceUtil;
import jakarta.persistence.spi.LoadState;
import jakarta.persistence.spi.PersistenceProvider;
import jakarta.persistence.spi.PersistenceProviderResolver;
import jakarta.persistence.spi.PersistenceProviderResolverHolder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Persistence {
    private Persistence() {
    }

    public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName) {
        return Persistence.createEntityManagerFactory(persistenceUnitName, null);
    }

    public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map<?, ?> properties) {
        PersistenceProvider provider;
        EntityManagerFactory emf = null;
        PersistenceProviderResolver resolver = PersistenceProviderResolverHolder.getPersistenceProviderResolver();
        List<PersistenceProvider> providers = resolver.getPersistenceProviders();
        Iterator<PersistenceProvider> iterator = providers.iterator();
        while (iterator.hasNext() && (emf = (provider = iterator.next()).createEntityManagerFactory(persistenceUnitName, properties)) == null) {
        }
        if (emf == null) {
            throw new PersistenceException("No Persistence provider for EntityManager named " + persistenceUnitName);
        }
        return emf;
    }

    public static EntityManagerFactory createEntityManagerFactory(PersistenceConfiguration configuration) {
        PersistenceProvider provider;
        EntityManagerFactory emf = null;
        PersistenceProviderResolver resolver = PersistenceProviderResolverHolder.getPersistenceProviderResolver();
        List<PersistenceProvider> providers = resolver.getPersistenceProviders();
        Iterator<PersistenceProvider> iterator = providers.iterator();
        while (iterator.hasNext() && (emf = (provider = iterator.next()).createEntityManagerFactory(configuration)) == null) {
        }
        if (emf == null) {
            throw new PersistenceException("No Persistence provider for EntityManager named " + configuration.name());
        }
        return emf;
    }

    public static void generateSchema(String persistenceUnitName, Map<?, ?> map) {
        PersistenceProviderResolver resolver = PersistenceProviderResolverHolder.getPersistenceProviderResolver();
        List<PersistenceProvider> providers = resolver.getPersistenceProviders();
        for (PersistenceProvider provider : providers) {
            if (!provider.generateSchema(persistenceUnitName, map)) continue;
            return;
        }
        throw new PersistenceException("No Persistence provider to generate schema named " + persistenceUnitName);
    }

    public static void generateSchema(PersistenceConfiguration configuration) {
        PersistenceProviderResolver resolver = PersistenceProviderResolverHolder.getPersistenceProviderResolver();
        List<PersistenceProvider> providers = resolver.getPersistenceProviders();
        for (PersistenceProvider provider : providers) {
            if (!provider.generateSchema(configuration)) continue;
            return;
        }
        throw new PersistenceException("No Persistence provider to generate schema named " + configuration.name());
    }

    public static PersistenceUtil getPersistenceUtil() {
        return new PersistenceUtilImpl();
    }

    private static class PersistenceUtilImpl
    implements PersistenceUtil {
        private PersistenceUtilImpl() {
        }

        @Override
        public boolean isLoaded(Object entity, String attributeName) {
            LoadState loadstate;
            PersistenceProviderResolver resolver = PersistenceProviderResolverHolder.getPersistenceProviderResolver();
            List<PersistenceProvider> providers = resolver.getPersistenceProviders();
            for (PersistenceProvider provider : providers) {
                loadstate = provider.getProviderUtil().isLoadedWithoutReference(entity, attributeName);
                if (loadstate == LoadState.LOADED) {
                    return true;
                }
                if (loadstate != LoadState.NOT_LOADED) continue;
                return false;
            }
            for (PersistenceProvider provider : providers) {
                loadstate = provider.getProviderUtil().isLoadedWithReference(entity, attributeName);
                if (loadstate == LoadState.LOADED) {
                    return true;
                }
                if (loadstate != LoadState.NOT_LOADED) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isLoaded(Object entity) {
            PersistenceProviderResolver resolver = PersistenceProviderResolverHolder.getPersistenceProviderResolver();
            List<PersistenceProvider> providers = resolver.getPersistenceProviders();
            for (PersistenceProvider provider : providers) {
                LoadState loadstate = provider.getProviderUtil().isLoaded(entity);
                if (loadstate == LoadState.LOADED) {
                    return true;
                }
                if (loadstate != LoadState.NOT_LOADED) continue;
                return false;
            }
            return true;
        }
    }

    public static interface BeanManagementProperties {
        public static final String BEAN_MANAGER = "jakarta.persistence.bean.manager";
    }

    public static interface ValidationProperties {
        public static final String VALIDATION_FACTORY = "jakarta.persistence.validation.factory";
        public static final String VALIDATION_GROUP_PRE_PERSIST = "jakarta.persistence.validation.group.pre-persist";
        public static final String VALIDATION_GROUP_PRE_MERGE = "jakarta.persistence.validation.group.pre-merge";
        public static final String VALIDATION_GROUP_PRE_REMOVE = "jakarta.persistence.validation.group.pre-remove";
        public static final String VALIDATION_GROUP_PRE_INSERT = "jakarta.persistence.validation.group.pre-insert";
        public static final String VALIDATION_GROUP_PRE_UPDATE = "jakarta.persistence.validation.group.pre-update";
        public static final String VALIDATION_GROUP_PRE_UPSERT = "jakarta.persistence.validation.group.pre-upsert";
        public static final String VALIDATION_GROUP_PRE_DELETE = "jakarta.persistence.validation.group.pre-delete";
        public static final String VALIDATION_MODE = "jakarta.persistence.validation.mode";
    }

    public static interface SchemaManagementProperties {
        public static final String SCHEMAGEN_DATABASE_ACTION = "jakarta.persistence.schema-generation.database.action";
        public static final String SCHEMAGEN_SCRIPTS_ACTION = "jakarta.persistence.schema-generation.scripts.action";
        public static final String SCHEMAGEN_CREATE_SOURCE = "jakarta.persistence.schema-generation.create-source";
        public static final String SCHEMAGEN_DROP_SOURCE = "jakarta.persistence.schema-generation.drop-source";
        public static final String SCHEMAGEN_CREATE_SCRIPT_SOURCE = "jakarta.persistence.schema-generation.create-script-source";
        public static final String SCHEMAGEN_DROP_SCRIPT_SOURCE = "jakarta.persistence.schema-generation.drop-script-source";
        public static final String SCHEMAGEN_LOAD_SCRIPT_SOURCE = "jakarta.persistence.sql-load-script-source";
        public static final String SCHEMAGEN_CREATE_TARGET = "jakarta.persistence.schema-generation.scripts.create-target";
        public static final String SCHEMAGEN_DROP_TARGET = "jakarta.persistence.schema-generation.scripts.drop-target";
        public static final String SCHEMAGEN_CREATE_SCHEMAS = "jakarta.persistence.schema-generation.create-database-schemas";
        public static final String SCHEMAGEN_CONNECTION = "jakarta.persistence.schema-generation.connection";
    }

    public static interface DatabaseProperties {
        public static final String DATABASE_PRODUCT_NAME = "jakarta.persistence.database-product-name";
        public static final String DATABASE_MAJOR_VERSION = "jakarta.persistence.database-major-version";
        public static final String DATABASE_MINOR_VERSION = "jakarta.persistence.database-minor-version";
    }

    public static interface JdbcProperties {
        public static final String JDBC_FETCH_SIZE = "jakarta.persistence.jdbc.fetchSize";
        public static final String JDBC_BATCH_SIZE = "jakarta.persistence.jdbc.batchSize";
        public static final String LOCK_TIMEOUT = "jakarta.persistence.lock.timeout";
        public static final String QUERY_TIMEOUT = "jakarta.persistence.query.timeout";
    }

    public static interface ConnectionProperties {
        public static final String JDBC_DRIVER = "jakarta.persistence.jdbc.driver";
        public static final String JDBC_URL = "jakarta.persistence.jdbc.url";
        public static final String JDBC_USER = "jakarta.persistence.jdbc.user";
        public static final String JDBC_PASSWORD = "jakarta.persistence.jdbc.password";
        public static final String JDBC_DATASOURCE = "jakarta.persistence.dataSource";
    }

    public static interface CacheProperties {
        public static final String CACHE_MODE = "jakarta.persistence.sharedCache.mode";
    }

    public static interface UnitProperties {
        public static final String PERSISTENCE_PROVIDER = "jakarta.persistence.provider";
        public static final String PERSISTENCE_UNIT_TRANSACTION_TYPE = "jakarta.persistence.transactionType";
        public static final String PERSISTENCE_UNIT_JTA_DATASOURCE = "jakarta.persistence.jtaDataSource";
        public static final String PERSISTENCE_UNIT_NON_JTA_DATASOURCE = "jakarta.persistence.nonJtaDataSource";
        public static final String PERSISTENCE_UNIT_BEAN_QUALIFIERS = "jakarta.persistence.qualifiers";
        public static final String PERSISTENCE_UNIT_BEAN_SCOPE = "jakarta.persistence.scope";
    }
}

