/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import com.sun.faces.facelets.tag.faces.ComponentSupport;
import com.sun.faces.util.Util;
import jakarta.el.ValueExpression;
import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.StateHelper;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component.StateHolderSaver;
import jakarta.faces.component.TransientStateHelper;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.context.FacesContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

class ComponentStateHelper
implements StateHelper,
TransientStateHelper {
    private UIComponent component;
    private boolean isTransient;
    private Map<Serializable, Object> deltaMap;
    private Map<Serializable, Object> defaultMap;
    private Map<Object, Object> transientState;

    public ComponentStateHelper(UIComponent component) {
        this.component = component;
        this.deltaMap = new HashMap<Serializable, Object>();
        this.defaultMap = new HashMap<Serializable, Object>();
        this.transientState = null;
    }

    @Override
    public Object put(Serializable key, Object value) {
        if (this.component.initialStateMarked() || value instanceof PartialStateHolder) {
            Object retVal = this.deltaMap.put(key, value);
            if (retVal == null) {
                return this.defaultMap.put(key, value);
            }
            this.defaultMap.put(key, value);
            return retVal;
        }
        return this.defaultMap.put(key, value);
    }

    @Override
    public Object remove(Serializable key) {
        if (this.component.initialStateMarked()) {
            Object retVal = this.deltaMap.remove(key);
            if (retVal == null) {
                return this.defaultMap.remove(key);
            }
            this.defaultMap.remove(key);
            return retVal;
        }
        return this.defaultMap.remove(key);
    }

    @Override
    public Object put(Serializable key, String mapKey, Object value) {
        UIComponent parent;
        this.initMap(key);
        if ("com.sun.faces.facelets.MARK_ID".equals(mapKey) && UIComponent.PropertyKeys.attributes.equals(key) && (parent = this.component.getParent()) != null) {
            ComponentSupport.addToDescendantMarkIdCache((UIComponent)parent, (UIComponent)this.component);
        }
        Object ret = null;
        if (this.component.initialStateMarked()) {
            Map dMap = (Map)this.deltaMap.get(key);
            ret = dMap.put(mapKey, value);
        }
        Map map = (Map)this.get(key);
        if (ret == null) {
            return map.put(mapKey, value);
        }
        map.put(mapKey, value);
        return ret;
    }

    private void initMap(Serializable key) {
        HashMap map;
        HashMap dMap;
        if (this.component.initialStateMarked() && (dMap = (HashMap)this.deltaMap.get(key)) == null) {
            dMap = new HashMap(5);
            this.deltaMap.put(key, dMap);
        }
        if ((map = (HashMap)this.get(key)) == null) {
            map = new HashMap(8);
            this.defaultMap.put(key, map);
        }
    }

    @Override
    public Object get(Serializable key) {
        return this.defaultMap.get(key);
    }

    @Override
    public Object eval(Serializable key) {
        return this.eval(key, null);
    }

    @Override
    public Object eval(Serializable key, Object defaultValue) {
        ValueExpression valueExpression;
        Object retVal = this.get(key);
        if (retVal == null && (valueExpression = this.component.getValueExpression(key.toString())) != null) {
            retVal = valueExpression.getValue(this.component.getFacesContext().getELContext());
        }
        return Util.coalesce((Object[])new Object[]{retVal, defaultValue});
    }

    @Override
    public Object eval(Serializable key, Supplier<Object> defaultValueSupplier) {
        ValueExpression valueExpression;
        Object retVal = this.get(key);
        if (retVal == null && (valueExpression = this.component.getValueExpression(key.toString())) != null) {
            retVal = valueExpression.getValue(this.component.getFacesContext().getELContext());
        }
        if (retVal == null && defaultValueSupplier != null) {
            retVal = defaultValueSupplier.get();
        }
        return retVal;
    }

    @Override
    public void add(Serializable key, Object value) {
        this.initList(key);
        if (this.component.initialStateMarked()) {
            ((List)this.deltaMap.get(key)).add(value);
        }
        List items = (List)this.get(key);
        items.add(value);
    }

    private void initList(Serializable key) {
        if (this.component.initialStateMarked()) {
            this.deltaMap.computeIfAbsent(key, e -> new ArrayList(4));
        }
        if (this.get(key) == null) {
            ArrayList items = new ArrayList(4);
            this.defaultMap.put(key, items);
        }
    }

    @Override
    public Object remove(Serializable key, Object valueOrKey) {
        Object source = this.get(key);
        if (source instanceof Collection) {
            return this.removeFromList(key, valueOrKey);
        }
        if (source instanceof Map) {
            return this.removeFromMap(key, valueOrKey.toString());
        }
        return null;
    }

    @Override
    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.component.initialStateMarked()) {
            return this.saveMap(context, this.deltaMap);
        }
        return this.saveMap(context, this.defaultMap);
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] savedState;
        if (context == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            return;
        }
        if (!this.component.initialStateMarked() && !this.defaultMap.isEmpty()) {
            this.defaultMap.clear();
            if (!Util.isEmpty(this.deltaMap)) {
                this.deltaMap.clear();
            }
        }
        if ((savedState = (Object[])state)[savedState.length - 1] != null) {
            this.component.initialState = (Boolean)savedState[savedState.length - 1];
        }
        int length = (savedState.length - 1) / 2;
        for (int i = 0; i < length; ++i) {
            Object value = savedState[i * 2 + 1];
            Serializable serializable = (Serializable)savedState[i * 2];
            if (value != null) {
                if (value instanceof Collection) {
                    value = UIComponentBase.restoreAttachedState(context, value);
                } else if (value instanceof StateHolderSaver) {
                    value = ((StateHolderSaver)value).restore(context);
                } else {
                    Object object = value = value instanceof Serializable ? value : UIComponentBase.restoreAttachedState(context, value);
                }
            }
            if (value instanceof Map) {
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    this.put(serializable, (String)entry.getKey(), entry.getValue());
                }
                continue;
            }
            if (value instanceof List) {
                this.defaultMap.remove(serializable);
                this.deltaMap.remove(serializable);
                List values = (List)value;
                values.stream().forEach(o -> this.add(serializable, o));
                continue;
            }
            this.put(serializable, value);
            this.handleAttribute(serializable.toString(), value);
        }
    }

    private void handleAttribute(String name, Object value) {
        String className;
        ArrayList<String> setAttributes = (ArrayList<String>)this.component.getAttributes().get("jakarta.faces.component.UIComponentBase.attributesThatAreSet");
        if (setAttributes == null && (className = this.getClass().getName()) != null && className.startsWith("jakarta.faces.component.")) {
            setAttributes = new ArrayList<String>(6);
            this.component.getAttributes().put("jakarta.faces.component.UIComponentBase.attributesThatAreSet", setAttributes);
        }
        if (setAttributes != null) {
            if (value == null) {
                ValueExpression valueExpression = this.component.getValueExpression(name);
                if (valueExpression == null) {
                    setAttributes.remove(name);
                }
            } else if (!setAttributes.contains(name)) {
                setAttributes.add(name);
            }
        }
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public void setTransient(boolean newTransientValue) {
        this.isTransient = newTransientValue;
    }

    private Object saveMap(FacesContext context, Map<Serializable, Object> map) {
        if (map.isEmpty()) {
            if (!this.component.initialStateMarked()) {
                return new Object[]{this.component.initialStateMarked()};
            }
            return null;
        }
        Object[] savedState = new Object[map.size() * 2 + 1];
        int i = 0;
        for (Map.Entry<Serializable, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            savedState[i * 2] = entry.getKey();
            if (value instanceof Collection || value instanceof StateHolder || value instanceof Map || !(value instanceof Serializable)) {
                value = UIComponentBase.saveAttachedState(context, value);
            }
            savedState[i * 2 + 1] = value;
            ++i;
        }
        if (!this.component.initialStateMarked()) {
            savedState[savedState.length - 1] = this.component.initialStateMarked();
        }
        return savedState;
    }

    private Object removeFromList(Serializable key, Object value) {
        Collection list;
        Collection deltaList;
        Boolean ret = null;
        if ((this.component.initialStateMarked() || value instanceof PartialStateHolder) && (deltaList = (Collection)this.deltaMap.get(key)) != null) {
            ret = deltaList.remove(value);
            if (deltaList.isEmpty()) {
                this.deltaMap.remove(key);
            }
        }
        if ((list = (Collection)this.get(key)) != null) {
            if (ret == null) {
                ret = list.remove(value);
            } else {
                list.remove(value);
            }
            if (list.isEmpty()) {
                this.defaultMap.remove(key);
            }
        }
        return ret;
    }

    private Object removeFromMap(Serializable key, String mapKey) {
        Map map;
        Map dMap;
        Object ret = null;
        if (this.component.initialStateMarked() && (dMap = (Map)this.deltaMap.get(key)) != null) {
            ret = dMap.remove(mapKey);
            if (dMap.isEmpty()) {
                this.deltaMap.remove(key);
            }
        }
        if ((map = (Map)this.get(key)) != null) {
            if (ret == null) {
                ret = map.remove(mapKey);
            } else {
                map.remove(mapKey);
            }
            if (map.isEmpty()) {
                this.defaultMap.remove(key);
            }
        }
        if (ret != null && !this.component.initialStateMarked()) {
            this.deltaMap.remove(key);
        }
        return ret;
    }

    @Override
    public Object getTransient(Object key) {
        return this.transientState == null ? null : this.transientState.get(key);
    }

    @Override
    public Object getTransient(Object key, Object defaultValue) {
        Object returnValue;
        Object object = returnValue = this.transientState == null ? null : this.transientState.get(key);
        if (returnValue != null) {
            return returnValue;
        }
        return defaultValue;
    }

    @Override
    public Object putTransient(Object key, Object value) {
        if (this.transientState == null) {
            this.transientState = new HashMap<Object, Object>();
        }
        return this.transientState.put(key, value);
    }

    @Override
    public void restoreTransientState(FacesContext context, Object state) {
        this.transientState = (Map)state;
    }

    @Override
    public Object saveTransientState(FacesContext context) {
        return this.transientState;
    }
}

