/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.model;

import jakarta.data.Sort;
import jakarta.data.exceptions.MappingException;
import jakarta.data.model.AttributeInfo;
import java.util.concurrent.atomic.AtomicReference;

public class Attribute {
    private final AtomicReference<AttributeInfo> info = new AtomicReference();

    private Attribute() {
    }

    public final Sort asc() {
        return this.attrInfo().asc();
    }

    public final Sort ascIgnoreCase() {
        return this.attrInfo().ascIgnoreCase();
    }

    private final AttributeInfo attrInfo() {
        AttributeInfo attrInfo = this.info.get();
        if (attrInfo == null) {
            throw new MappingException("Unable to find a Jakarta Data provider that provides a repository  for an entity with an attribute having this name.");
        }
        return attrInfo;
    }

    public final Sort desc() {
        return this.attrInfo().desc();
    }

    public final Sort descIgnoreCase() {
        return this.attrInfo().descIgnoreCase();
    }

    public static final Attribute get() {
        return new Attribute();
    }

    public final boolean init(AttributeInfo attrInfo) {
        return this.info.compareAndSet(null, attrInfo);
    }

    public final String name() {
        return this.attrInfo().name();
    }
}

