/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import jakarta.activation.CommandInfo;
import jakarta.activation.DataContentHandler;
import jakarta.activation.DataSource;
import jakarta.activation.MailcapCommandMap;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class CommandMap {
    private static CommandMap defaultCommandMap = null;
    private static Map<ClassLoader, CommandMap> map = new WeakHashMap<ClassLoader, CommandMap>();

    protected CommandMap() {
    }

    public static synchronized CommandMap getDefaultCommandMap() {
        if (defaultCommandMap != null) {
            return defaultCommandMap;
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        CommandMap def = map.get(tccl);
        if (def == null) {
            def = new MailcapCommandMap();
            map.put(tccl, def);
        }
        return def;
    }

    public static synchronized void setDefaultCommandMap(CommandMap commandMap) {
        map.remove(Thread.currentThread().getContextClassLoader());
        defaultCommandMap = commandMap;
    }

    public abstract CommandInfo[] getPreferredCommands(String var1);

    public CommandInfo[] getPreferredCommands(String mimeType, DataSource ds) {
        return this.getPreferredCommands(mimeType);
    }

    public abstract CommandInfo[] getAllCommands(String var1);

    public CommandInfo[] getAllCommands(String mimeType, DataSource ds) {
        return this.getAllCommands(mimeType);
    }

    public abstract CommandInfo getCommand(String var1, String var2);

    public CommandInfo getCommand(String mimeType, String cmdName, DataSource ds) {
        return this.getCommand(mimeType, cmdName);
    }

    public abstract DataContentHandler createDataContentHandler(String var1);

    public DataContentHandler createDataContentHandler(String mimeType, DataSource ds) {
        return this.createDataContentHandler(mimeType);
    }

    public String[] getMimeTypes() {
        return null;
    }
}

