/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.impl;

import java.io.IOException;
import java.math.BigDecimal;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.impl.NumericNode;

public final class DecimalNode
extends NumericNode {
    final BigDecimal mValue;

    public DecimalNode(BigDecimal v) {
        this.mValue = v;
    }

    public static DecimalNode valueOf(BigDecimal d) {
        return new DecimalNode(d);
    }

    public boolean isFloatingPointNumber() {
        return true;
    }

    public boolean isBigDecimal() {
        return true;
    }

    public Number getNumberValue() {
        return this.mValue;
    }

    public int getIntValue() {
        return this.mValue.intValue();
    }

    public long getLongValue() {
        return this.mValue.longValue();
    }

    public double getDoubleValue() {
        return this.mValue.doubleValue();
    }

    public BigDecimal getDecimalValue() {
        return this.mValue;
    }

    public String getValueAsText() {
        return this.mValue.toString();
    }

    public void writeTo(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeNumber(this.mValue);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return ((DecimalNode)o).mValue.equals(this.mValue);
    }
}

