/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson;

import org.codehaus.jackson.JsonLocation;
import org.codehaus.jackson.util.CharTypes;

public final class JsonReadContext {
    protected static final int INT_COLON = 58;
    protected static final int INT_COMMA = 44;
    private static final int TYPE_ROOT = 0;
    private static final int TYPE_ARRAY = 1;
    private static final int TYPE_OBJECT = 2;
    public static final int HANDLED_EXPECT_NAME = 0;
    public static final int HANDLED_EXPECT_VALUE = 1;
    public static final int MISSING_COMMA = 2;
    public static final int MISSING_COLON = 3;
    public static final int NOT_EXP_SEPARATOR_NEED_VALUE = 4;
    public static final int NOT_EXP_SEPARATOR_NEED_NAME = 5;
    protected int mType;
    protected int mIndex;
    protected int mLineNr;
    protected int mColumnNr;
    protected final JsonReadContext mParent;
    protected String mCurrentName;
    JsonReadContext mChild = null;

    public JsonReadContext(int type, JsonReadContext parent, int lineNr, int colNr) {
        this.mType = type;
        this.mParent = parent;
        this.mIndex = -1;
        this.mLineNr = lineNr;
        this.mColumnNr = colNr;
    }

    private final void reset(int type, int lineNr, int colNr) {
        this.mType = type;
        this.mIndex = -1;
        this.mLineNr = lineNr;
        this.mColumnNr = colNr;
        this.mCurrentName = null;
    }

    public static JsonReadContext createRootContext(int lineNr, int colNr) {
        return new JsonReadContext(0, null, lineNr, colNr);
    }

    public final JsonReadContext createChildArrayContext(int lineNr, int colNr) {
        JsonReadContext ctxt = this.mChild;
        if (ctxt == null) {
            this.mChild = new JsonReadContext(1, this, lineNr, colNr);
            return this.mChild;
        }
        ctxt.reset(1, lineNr, colNr);
        return ctxt;
    }

    public final JsonReadContext createChildObjectContext(int lineNr, int colNr) {
        JsonReadContext ctxt = this.mChild;
        if (ctxt == null) {
            this.mChild = new JsonReadContext(2, this, lineNr, colNr);
            return this.mChild;
        }
        ctxt.reset(2, lineNr, colNr);
        return ctxt;
    }

    public final JsonReadContext getParent() {
        return this.mParent;
    }

    public final int getEntryCount() {
        if (this.mType == 2) {
            return (this.mIndex >> 1) + 1;
        }
        return this.mIndex + 1;
    }

    public final int getCurrentIndex() {
        if (this.mIndex < 0) {
            return 0;
        }
        if (this.mType == 2) {
            return this.mIndex >> 1;
        }
        return this.mIndex;
    }

    public final JsonLocation getStartLocation(Object srcRef) {
        long totalChars = -1L;
        return new JsonLocation(srcRef, totalChars, this.mLineNr, this.mColumnNr);
    }

    public final boolean isArray() {
        return this.mType == 1;
    }

    public final boolean isRoot() {
        return this.mType == 0;
    }

    public final boolean isObject() {
        return this.mType == 2;
    }

    public final String getTypeDesc() {
        switch (this.mType) {
            case 0: {
                return "ROOT";
            }
            case 1: {
                return "ARRAY";
            }
            case 2: {
                return "OBJECT";
            }
        }
        return "?";
    }

    public final String getCurrentName() {
        return this.mCurrentName;
    }

    public int handleSeparator(int ch) {
        int ix = ++this.mIndex;
        if (this.mType == 2) {
            if (ix == 0) {
                return 5;
            }
            if ((ix & 1) == 0) {
                if (ch == 44) {
                    return 0;
                }
                return 2;
            }
            if (ch == 58) {
                return 1;
            }
            return 3;
        }
        if (this.mType == 1) {
            if (ix == 0) {
                return 4;
            }
            if (ch == 44) {
                return 1;
            }
            return 2;
        }
        return 4;
    }

    public void setCurrentName(String name) {
        this.mCurrentName = name;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(64);
        switch (this.mType) {
            case 0: {
                sb.append("/");
                break;
            }
            case 1: {
                sb.append('[');
                sb.append(this.getCurrentIndex());
                sb.append(']');
                break;
            }
            case 2: {
                sb.append('{');
                if (this.mCurrentName != null) {
                    sb.append('\"');
                    CharTypes.appendQuoted(sb, this.mCurrentName);
                    sb.append('\"');
                } else {
                    sb.append('?');
                }
                sb.append(']');
            }
        }
        return sb.toString();
    }
}

