/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.AbstractIntComparator;
import it.unimi.dsi.fastutil.ints.IntComparator;

public class IntComparators {
    public static final IntComparator NATURAL_COMPARATOR = new AbstractIntComparator(){

        @Override
        public final int compare(int a, int b) {
            return Integer.compare(a, b);
        }
    };
    public static final IntComparator OPPOSITE_COMPARATOR = new AbstractIntComparator(){

        @Override
        public final int compare(int a, int b) {
            return -Integer.compare(a, b);
        }
    };

    private IntComparators() {
    }

    public static IntComparator oppositeComparator(final IntComparator c) {
        return new AbstractIntComparator(){
            private final IntComparator comparator;
            {
                this.comparator = c;
            }

            @Override
            public final int compare(int a, int b) {
                return -this.comparator.compare(a, b);
            }
        };
    }
}

