/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.test;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.test.SplitMix64;
import java.util.Arrays;

public class RadixSortSpeed {
    public static void main(String[] args) {
        SplitMix64 random = new SplitMix64();
        int n = Integer.parseInt(args[0]);
        int[] a = new int[n];
        int repeat = 3;
        while (repeat-- != 0) {
            random.state = 0;
            int i = n;
            while (i-- != 0) {
                a[i] = (int)random.nextLong();
            }
            long start = System.nanoTime();
            IntArrays.radixSort(a);
            System.err.println((double)(System.nanoTime() - start) / 1.0E9 + "s");
            random.state = 0;
            i = n;
            while (i-- != 0) {
                a[i] = (int)random.nextLong();
            }
            start = System.nanoTime();
            IntArrays.parallelRadixSort(a);
            System.err.println((double)(System.nanoTime() - start) / 1.0E9 + "s");
            random.state = 0;
            i = n;
            while (i-- != 0) {
                a[i] = (int)random.nextLong();
            }
            start = System.nanoTime();
            Arrays.parallelSort(a);
            System.err.println((double)(System.nanoTime() - start) / 1.0E9 + "s");
            random.state = 0;
            i = n;
            while (i-- != 0) {
                a[i] = (int)random.nextLong();
            }
            start = System.nanoTime();
            Arrays.sort(a);
            System.err.println((double)(System.nanoTime() - start) / 1.0E9 + "s");
        }
    }
}

