/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.test;

import it.unimi.dsi.fastutil.ints.AbstractIntComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.test.SplitMix64;

public class IndirectLongSortSpeed {
    private static SplitMix64 random = new SplitMix64();

    public static void main(String[] args) {
        int n = Integer.parseInt(args[0]);
        int[] a = new int[n];
        final long[] b = new long[n];
        int repeat = 3;
        while (repeat-- != 0) {
            IndirectLongSortSpeed.random.state = 0;
            int i = n;
            while (i-- != 0) {
                a[i] = i;
                b[i] = random.nextLong();
            }
            long start = System.nanoTime();
            IntArrays.quickSort(a, new AbstractIntComparator(){

                @Override
                public int compare(int x, int y) {
                    return Long.compare(b[x], b[y]);
                }
            });
            System.err.println("sequential quicksort: " + (double)(System.nanoTime() - start) / 1.0E9 + "s");
            IndirectLongSortSpeed.random.state = 0;
            i = n;
            while (i-- != 0) {
                a[i] = i;
                b[i] = random.nextLong();
            }
            start = System.nanoTime();
            IntArrays.parallelQuickSort(a, new AbstractIntComparator(){

                @Override
                public int compare(int x, int y) {
                    return Long.compare(b[x], b[y]);
                }
            });
            System.err.println("parallel quicksort: " + (double)(System.nanoTime() - start) / 1.0E9 + "s");
            IndirectLongSortSpeed.random.state = 0;
            i = n;
            while (i-- != 0) {
                a[i] = i;
                b[i] = random.nextLong();
            }
            start = System.nanoTime();
            LongArrays.radixSortIndirect(a, b, false);
            System.err.println("sequential radixsort: " + (double)(System.nanoTime() - start) / 1.0E9 + "s");
            IndirectLongSortSpeed.random.state = 0;
            i = n;
            while (i-- != 0) {
                a[i] = i;
                b[i] = random.nextLong();
            }
            start = System.nanoTime();
            LongArrays.parallelRadixSortIndirect(a, b, false);
            System.err.println("parallel radixsort: " + (double)(System.nanoTime() - start) / 1.0E9 + "s");
        }
    }
}

