/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.chars.CharComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.io.Serializable;
import java.util.Random;

public class CharArrays {
    public static final char[] EMPTY_ARRAY = new char[0];
    private static final int SMALL = 7;
    private static final int MEDIUM = 50;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 2;
    public static final Hash.Strategy<char[]> HASH_STRATEGY = new ArrayHashStrategy();

    private CharArrays() {
    }

    public static char[] ensureCapacity(char[] array, int length) {
        if (length > array.length) {
            char[] t = new char[length];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static char[] ensureCapacity(char[] array, int length, int preserve) {
        if (length > array.length) {
            char[] t = new char[length];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static char[] grow(char[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(2L * (long)array.length, (long)length), Integer.MAX_VALUE);
            char[] t = new char[newLength];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static char[] grow(char[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(2L * (long)array.length, (long)length), Integer.MAX_VALUE);
            char[] t = new char[newLength];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static char[] trim(char[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        char[] t = length == 0 ? EMPTY_ARRAY : new char[length];
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static char[] setLength(char[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return CharArrays.trim(array, length);
        }
        return CharArrays.ensureCapacity(array, length);
    }

    public static char[] copy(char[] array, int offset, int length) {
        CharArrays.ensureOffsetLength(array, offset, length);
        char[] a = length == 0 ? EMPTY_ARRAY : new char[length];
        System.arraycopy(array, offset, a, 0, length);
        return a;
    }

    public static char[] copy(char[] array) {
        return (char[])array.clone();
    }

    public static void fill(char[] array, char value) {
        int i = array.length;
        while (i-- != 0) {
            array[i] = value;
        }
    }

    public static void fill(char[] array, int from, int to, char value) {
        CharArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i = from; i < to; ++i) {
                array[i] = value;
            }
        }
    }

    public static boolean equals(char[] a1, char[] a2) {
        int i = a1.length;
        if (i != a2.length) {
            return false;
        }
        while (i-- != 0) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(char[] a, int from, int to) {
        Arrays.ensureFromTo(a.length, from, to);
    }

    public static void ensureOffsetLength(char[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    private static void swap(char[] x, int a, int b) {
        char t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecSwap(char[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            CharArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(char[] x, int a, int b, int c, CharComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(char[] a, int from, int to, CharComparator comp) {
        for (int i = from; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (comp.compare(a[j], a[m]) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            char u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(char[] a, int from, int to, CharComparator comp) {
        int i = from;
        while (++i < to) {
            char t = a[i];
            int j = i;
            char u = a[j - 1];
            while (comp.compare(t, u) < 0) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    private static void selectionSort(char[] a, int from, int to) {
        for (int i = from; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (Character.compare(a[j], a[m]) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            char u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(char[] a, int from, int to) {
        int i = from;
        while (++i < to) {
            char t = a[i];
            int j = i;
            char u = a[j - 1];
            while (Character.compare(t, u) < 0) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void quickSort(char[] x, int from, int to, CharComparator comp) {
        int c;
        int a;
        int len = to - from;
        if (len < 7) {
            CharArrays.selectionSort(x, from, to, comp);
            return;
        }
        int m = from + len / 2;
        if (len > 7) {
            int l = from;
            int n = to - 1;
            if (len > 50) {
                int s = len / 8;
                l = CharArrays.med3(x, l, l + s, l + 2 * s, comp);
                m = CharArrays.med3(x, m - s, m, m + s, comp);
                n = CharArrays.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = CharArrays.med3(x, l, m, n, comp);
        }
        char v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            CharArrays.swap(x, b++, c--);
        }
        int n = to;
        int s = Math.min(a - from, b - a);
        CharArrays.vecSwap(x, from, b - s, s);
        s = Math.min(d - c, n - d - 1);
        CharArrays.vecSwap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            CharArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1) {
            CharArrays.quickSort(x, n - s, n, comp);
        }
    }

    public static void quickSort(char[] x, CharComparator comp) {
        CharArrays.quickSort(x, 0, x.length, comp);
    }

    private static int med3(char[] x, int a, int b, int c) {
        int ab = Character.compare(x[a], x[b]);
        int ac = Character.compare(x[a], x[c]);
        int bc = Character.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    @Deprecated
    public static void quickSort(char[] x, int from, int to) {
        int c;
        int a;
        int len = to - from;
        if (len < 7) {
            CharArrays.selectionSort(x, from, to);
            return;
        }
        int m = from + len / 2;
        if (len > 7) {
            int l = from;
            int n = to - 1;
            if (len > 50) {
                int s = len / 8;
                l = CharArrays.med3(x, l, l + s, l + 2 * s);
                m = CharArrays.med3(x, m - s, m, m + s);
                n = CharArrays.med3(x, n - 2 * s, n - s, n);
            }
            m = CharArrays.med3(x, l, m, n);
        }
        char v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = Character.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = Character.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            CharArrays.swap(x, b++, c--);
        }
        int n = to;
        int s = Math.min(a - from, b - a);
        CharArrays.vecSwap(x, from, b - s, s);
        s = Math.min(d - c, n - d - 1);
        CharArrays.vecSwap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            CharArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c) > 1) {
            CharArrays.quickSort(x, n - s, n);
        }
    }

    @Deprecated
    public static void quickSort(char[] x) {
        CharArrays.quickSort(x, 0, x.length);
    }

    public static void mergeSort(char[] a, int from, int to, char[] supp) {
        int len = to - from;
        if (len < 7) {
            CharArrays.insertionSort(a, from, to);
            return;
        }
        int mid = from + to >>> 1;
        CharArrays.mergeSort(supp, from, mid, a);
        CharArrays.mergeSort(supp, mid, to, a);
        if (Character.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && Character.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(char[] a, int from, int to) {
        CharArrays.mergeSort(a, from, to, (char[])a.clone());
    }

    public static void mergeSort(char[] a) {
        CharArrays.mergeSort(a, 0, a.length);
    }

    public static void mergeSort(char[] a, int from, int to, CharComparator comp, char[] supp) {
        int len = to - from;
        if (len < 7) {
            CharArrays.insertionSort(a, from, to, comp);
            return;
        }
        int mid = from + to >>> 1;
        CharArrays.mergeSort(supp, from, mid, comp, a);
        CharArrays.mergeSort(supp, mid, to, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(char[] a, int from, int to, CharComparator comp) {
        CharArrays.mergeSort(a, from, to, comp, (char[])a.clone());
    }

    public static void mergeSort(char[] a, CharComparator comp) {
        CharArrays.mergeSort(a, 0, a.length, comp);
    }

    public static int binarySearch(char[] a, int from, int to, char key) {
        --to;
        while (from <= to) {
            int mid = from + to >>> 1;
            char midVal = a[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(char[] a, char key) {
        return CharArrays.binarySearch(a, 0, a.length, key);
    }

    public static int binarySearch(char[] a, int from, int to, char key, CharComparator c) {
        --to;
        while (from <= to) {
            int mid = from + to >>> 1;
            char midVal = a[mid];
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(char[] a, char key, CharComparator c) {
        return CharArrays.binarySearch(a, 0, a.length, key, c);
    }

    public static void radixSort(char[] a) {
        CharArrays.radixSort(a, 0, a.length);
    }

    public static void radixSort(char[] a, int from, int to) {
        boolean maxLevel = true;
        int stackSize = 256;
        int[] offsetStack = new int[256];
        int offsetPos = 0;
        int[] lengthStack = new int[256];
        int lengthPos = 0;
        int[] levelStack = new int[256];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        byte[] digit = new byte[to - from];
        while (offsetPos > 0) {
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int level = levelStack[--levelPos];
            boolean signMask = false;
            if (length < 50) {
                CharArrays.selectionSort(a, first, first + length);
                continue;
            }
            int shift = (1 - level % 2) * 8;
            int i = length;
            while (i-- != 0) {
                digit[i] = (byte)(a[first + i] >>> shift & 0xFF ^ 0);
            }
            i = length;
            while (i-- != 0) {
                int n = digit[i] & 0xFF;
                count[n] = count[n] + 1;
            }
            int lastUsed = -1;
            int p = 0;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count[i2] != 0) {
                    lastUsed = i2;
                    if (level < 1 && count[i2] > 1) {
                        offsetStack[offsetPos++] = p + first;
                        lengthStack[lengthPos++] = count[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i2] = p += count[i2];
            }
            int end = length - count[lastUsed];
            count[lastUsed] = 0;
            int c = -1;
            for (int i3 = 0; i3 < end; i3 += count[c]) {
                char t = a[i3 + first];
                c = digit[i3] & 0xFF;
                while (true) {
                    int n = c;
                    int n2 = pos[n] - 1;
                    pos[n] = n2;
                    int d = n2;
                    if (n2 <= i3) break;
                    char z = t;
                    int zz = c;
                    t = a[d + first];
                    c = digit[d] & 0xFF;
                    a[d + first] = z;
                    digit[d] = (byte)zz;
                }
                a[i3 + first] = t;
                count[c] = 0;
            }
        }
    }

    private static void insertionSortIndirect(int[] perm, char[] a, int from, int to) {
        int i = from;
        while (++i < to) {
            int t = perm[i];
            int j = i;
            int u = perm[j - 1];
            while (a[t] < a[u]) {
                perm[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = perm[--j - 1];
            }
            perm[j] = t;
        }
    }

    public static void radixSortIndirect(int[] perm, char[] a, boolean stable) {
        CharArrays.radixSortIndirect(perm, a, 0, perm.length, stable);
    }

    public static void radixSortIndirect(int[] perm, char[] a, int from, int to, boolean stable) {
        boolean maxLevel = true;
        int stackSize = 256;
        int[] offsetStack = new int[256];
        int offsetPos = 0;
        int[] lengthStack = new int[256];
        int lengthPos = 0;
        int[] levelStack = new int[256];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = stable ? null : new int[256];
        int[] support = stable ? new int[perm.length] : null;
        byte[] digit = new byte[to - from];
        while (offsetPos > 0) {
            int i;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int level = levelStack[--levelPos];
            boolean signMask = false;
            if (length < 50) {
                CharArrays.insertionSortIndirect(perm, a, first, first + length);
                continue;
            }
            int shift = (1 - level % 2) * 8;
            int i2 = length;
            while (i2-- != 0) {
                digit[i2] = (byte)(a[perm[first + i2]] >>> shift & 0xFF ^ 0);
            }
            i2 = length;
            while (i2-- != 0) {
                int n = digit[i2] & 0xFF;
                count[n] = count[n] + 1;
            }
            int lastUsed = -1;
            int p = 0;
            for (i = 0; i < 256; ++i) {
                if (count[i] != 0) {
                    lastUsed = i;
                    if (level < 1 && count[i] > 1) {
                        offsetStack[offsetPos++] = p + first;
                        lengthStack[lengthPos++] = count[i];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                if (stable) {
                    count[i] = p += count[i];
                    continue;
                }
                pos[i] = p += count[i];
            }
            if (stable) {
                i = length;
                while (i-- != 0) {
                    int n = digit[i] & 0xFF;
                    int n2 = count[n] - 1;
                    count[n] = n2;
                    support[n2] = perm[first + i];
                }
                System.arraycopy(support, 0, perm, first, length);
                IntArrays.fill(count, 0);
                continue;
            }
            int end = length - count[lastUsed];
            count[lastUsed] = 0;
            int c = -1;
            for (int i3 = 0; i3 < end; i3 += count[c]) {
                int t = perm[i3 + first];
                c = digit[i3] & 0xFF;
                while (true) {
                    int n = c;
                    int n3 = pos[n] - 1;
                    pos[n] = n3;
                    int d = n3;
                    if (n3 <= i3) break;
                    int z = t;
                    int zz = c;
                    t = perm[d + first];
                    c = digit[d] & 0xFF;
                    perm[d + first] = z;
                    digit[d] = (byte)zz;
                }
                perm[i3 + first] = t;
                count[c] = 0;
            }
        }
    }

    private static void selectionSort(char[] a, char[] b, int from, int to) {
        for (int i = from; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (a[j] >= a[m] && (a[j] != a[m] || b[j] >= b[m])) continue;
                m = j;
            }
            if (m == i) continue;
            char t = a[i];
            a[i] = a[m];
            a[m] = t;
            t = b[i];
            b[i] = b[m];
            b[m] = t;
        }
    }

    public static void radixSort(char[] a, char[] b) {
        CharArrays.radixSort(a, b, 0, a.length);
    }

    public static void radixSort(char[] a, char[] b, int from, int to) {
        int layers = 2;
        if (a.length != b.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 3;
        int stackSize = 766;
        int[] offsetStack = new int[766];
        int offsetPos = 0;
        int[] lengthStack = new int[766];
        int lengthPos = 0;
        int[] levelStack = new int[766];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        byte[] digit = new byte[to - from];
        while (offsetPos > 0) {
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int level = levelStack[--levelPos];
            boolean signMask = false;
            if (length < 50) {
                CharArrays.selectionSort(a, b, first, first + length);
                continue;
            }
            char[] k = level < 2 ? a : b;
            int shift = (1 - level % 2) * 8;
            int i = length;
            while (i-- != 0) {
                digit[i] = (byte)(k[first + i] >>> shift & 0xFF ^ 0);
            }
            i = length;
            while (i-- != 0) {
                int n = digit[i] & 0xFF;
                count[n] = count[n] + 1;
            }
            int lastUsed = -1;
            int p = 0;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count[i2] != 0) {
                    lastUsed = i2;
                    if (level < 3 && count[i2] > 1) {
                        offsetStack[offsetPos++] = p + first;
                        lengthStack[lengthPos++] = count[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i2] = p += count[i2];
            }
            int end = length - count[lastUsed];
            count[lastUsed] = 0;
            int c = -1;
            for (int i3 = 0; i3 < end; i3 += count[c]) {
                char t = a[i3 + first];
                char u = b[i3 + first];
                c = digit[i3] & 0xFF;
                while (true) {
                    int n = c;
                    int n2 = pos[n] - 1;
                    pos[n] = n2;
                    int d = n2;
                    if (n2 <= i3) break;
                    char z = t;
                    int zz = c;
                    t = a[d + first];
                    a[d + first] = z;
                    z = u;
                    u = b[d + first];
                    b[d + first] = z;
                    c = digit[d] & 0xFF;
                    digit[d] = (byte)zz;
                }
                a[i3 + first] = t;
                b[i3 + first] = u;
                count[c] = 0;
            }
        }
    }

    private static void insertionSortIndirect(int[] perm, char[] a, char[] b, int from, int to) {
        int i = from;
        while (++i < to) {
            int t = perm[i];
            int j = i;
            int u = perm[j - 1];
            while (a[t] < a[u] || a[t] == a[u] && b[t] < b[u]) {
                perm[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = perm[--j - 1];
            }
            perm[j] = t;
        }
    }

    public static void radixSortIndirect(int[] perm, char[] a, char[] b, boolean stable) {
        CharArrays.radixSortIndirect(perm, a, b, 0, perm.length, stable);
    }

    public static void radixSortIndirect(int[] perm, char[] a, char[] b, int from, int to, boolean stable) {
        int layers = 2;
        if (a.length != b.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 3;
        int stackSize = 766;
        int[] offsetStack = new int[766];
        int offsetPos = 0;
        int[] lengthStack = new int[766];
        int lengthPos = 0;
        int[] levelStack = new int[766];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = stable ? null : new int[256];
        int[] support = stable ? new int[perm.length] : null;
        byte[] digit = new byte[to - from];
        while (offsetPos > 0) {
            int i;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int level = levelStack[--levelPos];
            boolean signMask = false;
            if (length < 50) {
                CharArrays.insertionSortIndirect(perm, a, b, first, first + length);
                continue;
            }
            char[] k = level < 2 ? a : b;
            int shift = (1 - level % 2) * 8;
            int i2 = length;
            while (i2-- != 0) {
                digit[i2] = (byte)(k[perm[first + i2]] >>> shift & 0xFF ^ 0);
            }
            i2 = length;
            while (i2-- != 0) {
                int n = digit[i2] & 0xFF;
                count[n] = count[n] + 1;
            }
            int lastUsed = -1;
            int p = 0;
            for (i = 0; i < 256; ++i) {
                if (count[i] != 0) {
                    lastUsed = i;
                    if (level < 3 && count[i] > 1) {
                        offsetStack[offsetPos++] = p + first;
                        lengthStack[lengthPos++] = count[i];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                if (stable) {
                    count[i] = p += count[i];
                    continue;
                }
                pos[i] = p += count[i];
            }
            if (stable) {
                i = length;
                while (i-- != 0) {
                    int n = digit[i] & 0xFF;
                    int n2 = count[n] - 1;
                    count[n] = n2;
                    support[n2] = perm[first + i];
                }
                System.arraycopy(support, 0, perm, first, length);
                IntArrays.fill(count, 0);
                continue;
            }
            int end = length - count[lastUsed];
            count[lastUsed] = 0;
            int c = -1;
            for (int i3 = 0; i3 < end; i3 += count[c]) {
                int t = perm[i3 + first];
                c = digit[i3] & 0xFF;
                while (true) {
                    int n = c;
                    int n3 = pos[n] - 1;
                    pos[n] = n3;
                    int d = n3;
                    if (n3 <= i3) break;
                    int z = t;
                    int zz = c;
                    t = perm[d + first];
                    c = digit[d] & 0xFF;
                    perm[d + first] = z;
                    digit[d] = (byte)zz;
                }
                perm[i3 + first] = t;
                count[c] = 0;
            }
        }
    }

    private static void selectionSort(char[][] a, int from, int to, int level) {
        int layers = a.length;
        int firstLayer = level / 2;
        for (int i = from; i < to - 1; ++i) {
            int m = i;
            block1: for (int j = i + 1; j < to; ++j) {
                for (int p = firstLayer; p < layers; ++p) {
                    if (a[p][j] < a[p][m]) {
                        m = j;
                        continue block1;
                    }
                    if (a[p][j] > a[p][m]) continue block1;
                }
            }
            if (m == i) continue;
            int p = layers;
            while (p-- != 0) {
                char u = a[p][i];
                a[p][i] = a[p][m];
                a[p][m] = u;
            }
        }
    }

    public static void radixSort(char[][] a) {
        CharArrays.radixSort(a, 0, a[0].length);
    }

    public static void radixSort(char[][] a, int from, int to) {
        int layers = a.length;
        int maxLevel = 2 * layers - 1;
        int p = layers;
        int l = a[0].length;
        while (p-- != 0) {
            if (a[p].length == l) continue;
            throw new IllegalArgumentException("The array of index " + p + " has not the same length of the array of index 0.");
        }
        int stackSize = 255 * (layers * 2 - 1) + 1;
        int[] offsetStack = new int[stackSize];
        int offsetPos = 0;
        int[] lengthStack = new int[stackSize];
        int lengthPos = 0;
        int[] levelStack = new int[stackSize];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        byte[] digit = new byte[to - from];
        char[] t = new char[layers];
        while (offsetPos > 0) {
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int level = levelStack[--levelPos];
            boolean signMask = false;
            if (length < 50) {
                CharArrays.selectionSort(a, first, first + length, level);
                continue;
            }
            char[] k = a[level / 2];
            int shift = (1 - level % 2) * 8;
            int i = length;
            while (i-- != 0) {
                digit[i] = (byte)(k[first + i] >>> shift & 0xFF ^ 0);
            }
            i = length;
            while (i-- != 0) {
                int n = digit[i] & 0xFF;
                count[n] = count[n] + 1;
            }
            int lastUsed = -1;
            int p2 = 0;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count[i2] != 0) {
                    lastUsed = i2;
                    if (level < maxLevel && count[i2] > 1) {
                        offsetStack[offsetPos++] = p2 + first;
                        lengthStack[lengthPos++] = count[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i2] = p2 += count[i2];
            }
            int end = length - count[lastUsed];
            count[lastUsed] = 0;
            int c = -1;
            for (int i3 = 0; i3 < end; i3 += count[c]) {
                int p3 = layers;
                while (p3-- != 0) {
                    t[p3] = a[p3][i3 + first];
                }
                c = digit[i3] & 0xFF;
                while (true) {
                    int n = c;
                    int n2 = pos[n] - 1;
                    pos[n] = n2;
                    int d = n2;
                    if (n2 <= i3) break;
                    p3 = layers;
                    while (p3-- != 0) {
                        char u = t[p3];
                        t[p3] = a[p3][d + first];
                        a[p3][d + first] = u;
                    }
                    int zz = c;
                    c = digit[d] & 0xFF;
                    digit[d] = (byte)zz;
                }
                p3 = layers;
                while (p3-- != 0) {
                    a[p3][i3 + first] = t[p3];
                }
                count[c] = 0;
            }
        }
    }

    public static char[] shuffle(char[] a, int from, int to, Random random) {
        int i = to - from;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            char t = a[from + i];
            a[from + i] = a[from + p];
            a[from + p] = t;
        }
        return a;
    }

    public static char[] shuffle(char[] a, Random random) {
        int i = a.length;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            char t = a[i];
            a[i] = a[p];
            a[p] = t;
        }
        return a;
    }

    public static char[] reverse(char[] a) {
        int length = a.length;
        int i = length / 2;
        while (i-- != 0) {
            char t = a[length - i - 1];
            a[length - i - 1] = a[i];
            a[i] = t;
        }
        return a;
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<char[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(char[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(char[] a, char[] b) {
            return CharArrays.equals(a, b);
        }
    }
}

