/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;

public class ByteIndirectHeaps {
    private ByteIndirectHeaps() {
    }

    public static int downHeap(byte[] refArray, int[] heap, int[] inv, int size, int i, ByteComparator c) {
        if (i >= size) {
            throw new IllegalArgumentException("Heap position (" + i + ") is larger than or equal to heap size (" + size + ")");
        }
        int e = heap[i];
        byte E = refArray[e];
        if (c == null) {
            int child;
            while ((child = 2 * i + 1) < size) {
                if (child + 1 < size && Byte.compare(refArray[heap[child + 1]], refArray[heap[child]]) < 0) {
                    ++child;
                }
                if (Byte.compare(E, refArray[heap[child]]) > 0) {
                    heap[i] = heap[child];
                    inv[heap[i]] = i;
                    i = child;
                    continue;
                }
                break;
            }
        } else {
            int child;
            while ((child = 2 * i + 1) < size) {
                if (child + 1 < size && c.compare(refArray[heap[child + 1]], refArray[heap[child]]) < 0) {
                    ++child;
                }
                if (c.compare(E, refArray[heap[child]]) > 0) {
                    heap[i] = heap[child];
                    inv[heap[i]] = i;
                    i = child;
                    continue;
                }
                break;
            }
        }
        heap[i] = e;
        inv[e] = i;
        return i;
    }

    public static int upHeap(byte[] refArray, int[] heap, int[] inv, int size, int i, ByteComparator c) {
        if (i >= size) {
            throw new IllegalArgumentException("Heap position (" + i + ") is larger than or equal to heap size (" + size + ")");
        }
        int e = heap[i];
        byte E = refArray[e];
        if (c == null) {
            int parent;
            while (i != 0 && (parent = (i - 1) / 2) >= 0 && Byte.compare(refArray[heap[parent]], E) > 0) {
                heap[i] = heap[parent];
                inv[heap[i]] = i;
                i = parent;
            }
        } else {
            int parent;
            while (i != 0 && (parent = (i - 1) / 2) >= 0 && c.compare(refArray[heap[parent]], E) > 0) {
                heap[i] = heap[parent];
                inv[heap[i]] = i;
                i = parent;
            }
        }
        heap[i] = e;
        inv[e] = i;
        return i;
    }

    public static void makeHeap(byte[] refArray, int offset, int length, int[] heap, int[] inv, ByteComparator c) {
        ByteArrays.ensureOffsetLength(refArray, offset, length);
        if (heap.length < length) {
            throw new IllegalArgumentException("The heap length (" + heap.length + ") is smaller than the number of elements (" + length + ")");
        }
        if (inv.length < refArray.length) {
            throw new IllegalArgumentException("The inversion array length (" + heap.length + ") is smaller than the length of the reference array (" + refArray.length + ")");
        }
        IntArrays.fill(inv, 0, refArray.length, -1);
        int i = length;
        while (i-- != 0) {
            heap[i] = offset + i;
            inv[heap[i]] = i;
        }
        i = length / 2;
        while (i-- != 0) {
            ByteIndirectHeaps.downHeap(refArray, heap, inv, length, i, c);
        }
    }

    public static void makeHeap(byte[] refArray, int[] heap, int[] inv, int size, ByteComparator c) {
        int i = size / 2;
        while (i-- != 0) {
            ByteIndirectHeaps.downHeap(refArray, heap, inv, size, i, c);
        }
    }
}

