/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleIterators;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DoubleOpenHashSet
extends AbstractDoubleSet
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient double[] key;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;

    public DoubleOpenHashSet(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new double[this.n];
        this.used = new boolean[this.n];
    }

    public DoubleOpenHashSet(int expected) {
        this(expected, 0.75f);
    }

    public DoubleOpenHashSet() {
        this(16, 0.75f);
    }

    public DoubleOpenHashSet(Collection<? extends Double> c, float f) {
        this(c.size(), f);
        this.addAll(c);
    }

    public DoubleOpenHashSet(Collection<? extends Double> c) {
        this(c, 0.75f);
    }

    public DoubleOpenHashSet(DoubleCollection c, float f) {
        this(c.size(), f);
        this.addAll(c);
    }

    public DoubleOpenHashSet(DoubleCollection c) {
        this(c, 0.75f);
    }

    public DoubleOpenHashSet(DoubleIterator i, float f) {
        this(16, f);
        while (i.hasNext()) {
            this.add(i.nextDouble());
        }
    }

    public DoubleOpenHashSet(DoubleIterator i) {
        this(i, 0.75f);
    }

    public DoubleOpenHashSet(Iterator<?> i, float f) {
        this(DoubleIterators.asDoubleIterator(i), f);
    }

    public DoubleOpenHashSet(Iterator<?> i) {
        this(DoubleIterators.asDoubleIterator(i));
    }

    public DoubleOpenHashSet(double[] a, int offset, int length, float f) {
        this(length < 0 ? 0 : length, f);
        DoubleArrays.ensureOffsetLength(a, offset, length);
        for (int i = 0; i < length; ++i) {
            this.add(a[offset + i]);
        }
    }

    public DoubleOpenHashSet(double[] a, int offset, int length) {
        this(a, offset, length, 0.75f);
    }

    public DoubleOpenHashSet(double[] a, float f) {
        this(a, 0, a.length, f);
    }

    public DoubleOpenHashSet(double[] a) {
        this(a, 0.75f);
    }

    @Override
    public boolean add(double k) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (Double.doubleToLongBits(this.key[pos]) == Double.doubleToLongBits(k)) {
                return false;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return true;
    }

    protected final int shiftKeys(int pos) {
        int last;
        while (true) {
            last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(this.key[pos]) ^ (long)this.mask) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
        }
        this.used[last] = false;
        return last;
    }

    @Override
    public boolean remove(double k) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (Double.doubleToLongBits(this.key[pos]) == Double.doubleToLongBits(k)) {
                --this.size;
                this.shiftKeys(pos);
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean contains(double k) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (Double.doubleToLongBits(this.key[pos]) == Double.doubleToLongBits(k)) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    @Override
    public DoubleIterator iterator() {
        return new SetIterator();
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = 0;
        boolean[] used = this.used;
        double[] key = this.key;
        int mask = newN - 1;
        double[] newKey = new double[newN];
        boolean[] newUsed = new boolean[newN];
        int j = this.size;
        while (j-- != 0) {
            while (!used[i]) {
                ++i;
            }
            double k = key[i];
            int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)mask) & mask;
            while (newUsed[pos]) {
                pos = pos + 1 & mask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            ++i;
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.used = newUsed;
    }

    public DoubleOpenHashSet clone() {
        DoubleOpenHashSet c;
        try {
            c = (DoubleOpenHashSet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.key = (double[])this.key.clone();
        c.used = (boolean[])this.used.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.size;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            h += HashCommon.double2int(this.key[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        DoubleIterator i = this.iterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            s.writeDouble(i.nextDouble());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new double[this.n];
        double[] key = this.key;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            double k = s.readDouble();
            pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)this.mask) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
        }
    }

    private void checkTable() {
    }

    private class SetIterator
    extends AbstractDoubleIterator {
        int pos;
        int last;
        int c;
        DoubleArrayList wrapped;

        private SetIterator() {
            this.pos = DoubleOpenHashSet.this.n;
            this.last = -1;
            this.c = DoubleOpenHashSet.this.size;
            boolean[] used = DoubleOpenHashSet.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.c != 0;
        }

        @Override
        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.pos < 0) {
                this.last = --this.pos;
                return this.wrapped.getDouble(-this.pos - 2);
            }
            this.last = this.pos;
            double retVal = DoubleOpenHashSet.this.key[this.last];
            if (this.c != 0) {
                boolean[] used = DoubleOpenHashSet.this.used;
                while (this.pos-- != 0 && !used[this.pos]) {
                }
            }
            return retVal;
        }

        final int shiftKeys(int pos) {
            int last;
            while (true) {
                last = pos;
                pos = last + 1 & DoubleOpenHashSet.this.mask;
                while (DoubleOpenHashSet.this.used[pos]) {
                    int slot = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(DoubleOpenHashSet.this.key[pos]) ^ (long)DoubleOpenHashSet.this.mask) & DoubleOpenHashSet.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & DoubleOpenHashSet.this.mask;
                }
                if (!DoubleOpenHashSet.this.used[pos]) break;
                if (pos < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new DoubleArrayList();
                    }
                    this.wrapped.add(DoubleOpenHashSet.this.key[pos]);
                }
                DoubleOpenHashSet.this.key[last] = DoubleOpenHashSet.this.key[pos];
            }
            DoubleOpenHashSet.this.used[last] = false;
            return last;
        }

        @Override
        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            if (this.pos < -1) {
                DoubleOpenHashSet.this.remove(this.wrapped.getDouble(-this.pos - 2));
                this.last = -1;
                return;
            }
            --DoubleOpenHashSet.this.size;
            if (this.shiftKeys(this.last) == this.pos && this.c > 0) {
                ++this.c;
                this.nextDouble();
            }
            this.last = -1;
        }
    }
}

