/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2CharMap;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import it.unimi.dsi.fastutil.doubles.Double2CharMap;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;

public class Double2CharOpenHashMap
extends AbstractDouble2CharMap
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient double[] key;
    protected transient char[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Double2CharMap.FastEntrySet entries;
    protected volatile transient DoubleSet keys;
    protected volatile transient CharCollection values;

    public Double2CharOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new double[this.n];
        this.value = new char[this.n];
        this.used = new boolean[this.n];
    }

    public Double2CharOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Double2CharOpenHashMap() {
        this(16, 0.75f);
    }

    public Double2CharOpenHashMap(Map<? extends Double, ? extends Character> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Double2CharOpenHashMap(Map<? extends Double, ? extends Character> m) {
        this(m, 0.75f);
    }

    public Double2CharOpenHashMap(Double2CharMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Double2CharOpenHashMap(Double2CharMap m) {
        this(m, 0.75f);
    }

    public Double2CharOpenHashMap(double[] k, char[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Double2CharOpenHashMap(double[] k, char[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public char put(double k, char v) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (Double.doubleToLongBits(this.key[pos]) == Double.doubleToLongBits(k)) {
                char oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Character put(Double ok, Character ov) {
        char v = ov.charValue();
        double k = ok;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (Double.doubleToLongBits(this.key[pos]) == Double.doubleToLongBits(k)) {
                Character oldValue = Character.valueOf(this.value[pos]);
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return null;
    }

    protected final int shiftKeys(int pos) {
        int last;
        while (true) {
            last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(this.key[pos]) ^ (long)this.mask) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
        }
        this.used[last] = false;
        return last;
    }

    @Override
    public char remove(double k) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (Double.doubleToLongBits(this.key[pos]) == Double.doubleToLongBits(k)) {
                --this.size;
                char v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public Character remove(Object ok) {
        double k = (Double)ok;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (Double.doubleToLongBits(this.key[pos]) == Double.doubleToLongBits(k)) {
                --this.size;
                char v = this.value[pos];
                this.shiftKeys(pos);
                return Character.valueOf(v);
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    public Character get(Double ok) {
        double k = ok;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (Double.doubleToLongBits(this.key[pos]) == Double.doubleToLongBits(k)) {
                return Character.valueOf(this.value[pos]);
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    @Override
    public char get(double k) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (Double.doubleToLongBits(this.key[pos]) == Double.doubleToLongBits(k)) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(double k) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (Double.doubleToLongBits(this.key[pos]) == Double.doubleToLongBits(k)) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(char v) {
        char[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    public Double2CharMap.FastEntrySet double2CharEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public DoubleSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public CharCollection values() {
        if (this.values == null) {
            this.values = new AbstractCharCollection(){

                @Override
                public CharIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Double2CharOpenHashMap.this.size;
                }

                @Override
                public boolean contains(char v) {
                    return Double2CharOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Double2CharOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = 0;
        boolean[] used = this.used;
        double[] key = this.key;
        char[] value = this.value;
        int mask = newN - 1;
        double[] newKey = new double[newN];
        char[] newValue = new char[newN];
        boolean[] newUsed = new boolean[newN];
        int j = this.size;
        while (j-- != 0) {
            while (!used[i]) {
                ++i;
            }
            double k = key[i];
            int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)mask) & mask;
            while (newUsed[pos]) {
                pos = pos + 1 & mask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            ++i;
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
    }

    public Double2CharOpenHashMap clone() {
        Double2CharOpenHashMap c;
        try {
            c = (Double2CharOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (double[])this.key.clone();
        c.value = (char[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = HashCommon.double2int(this.key[i]);
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        double[] key = this.key;
        char[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeDouble(key[e]);
            s.writeChar(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new double[this.n];
        double[] key = this.key;
        this.value = new char[this.n];
        char[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            double k = s.readDouble();
            char v = s.readChar();
            pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)this.mask) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements CharIterator {
        @Override
        public char nextChar() {
            return Double2CharOpenHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Character next() {
            return Character.valueOf(Double2CharOpenHashMap.this.value[this.nextEntry()]);
        }
    }

    private final class KeySet
    extends AbstractDoubleSet {
        private KeySet() {
        }

        @Override
        public DoubleIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Double2CharOpenHashMap.this.size;
        }

        @Override
        public boolean contains(double k) {
            return Double2CharOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(double k) {
            int oldSize = Double2CharOpenHashMap.this.size;
            Double2CharOpenHashMap.this.remove(k);
            return Double2CharOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Double2CharOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements DoubleIterator {
        @Override
        public double nextDouble() {
            return Double2CharOpenHashMap.this.key[this.nextEntry()];
        }

        @Override
        public Double next() {
            return Double2CharOpenHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Double2CharMap.Entry>
    implements Double2CharMap.FastEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Double2CharMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Double2CharMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            double k = (Double)e.getKey();
            int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)Double2CharOpenHashMap.this.mask) & Double2CharOpenHashMap.this.mask;
            while (Double2CharOpenHashMap.this.used[pos]) {
                if (Double.doubleToLongBits(Double2CharOpenHashMap.this.key[pos]) == Double.doubleToLongBits(k)) {
                    return Double2CharOpenHashMap.this.value[pos] == ((Character)e.getValue()).charValue();
                }
                pos = pos + 1 & Double2CharOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            double k = (Double)e.getKey();
            int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)Double2CharOpenHashMap.this.mask) & Double2CharOpenHashMap.this.mask;
            while (Double2CharOpenHashMap.this.used[pos]) {
                if (Double.doubleToLongBits(Double2CharOpenHashMap.this.key[pos]) == Double.doubleToLongBits(k)) {
                    Double2CharOpenHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Double2CharOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Double2CharOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Double2CharOpenHashMap.this.clear();
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Double2CharMap.Entry> {
        final AbstractDouble2CharMap.BasicEntry entry;

        private FastEntryIterator() {
            this.entry = new AbstractDouble2CharMap.BasicEntry(0.0, '\u0000');
        }

        @Override
        public AbstractDouble2CharMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Double2CharOpenHashMap.this.key[e];
            this.entry.value = Double2CharOpenHashMap.this.value[e];
            return this.entry;
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Double2CharMap.Entry> {
        private MapEntry entry;

        private EntryIterator() {
        }

        @Override
        public Double2CharMap.Entry next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;
        DoubleArrayList wrapped;

        private MapIterator() {
            this.pos = Double2CharOpenHashMap.this.n;
            this.last = -1;
            this.c = Double2CharOpenHashMap.this.size;
            boolean[] used = Double2CharOpenHashMap.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.pos < 0) {
                this.last = --this.pos;
                double k = this.wrapped.getDouble(-this.pos - 2);
                int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k) ^ (long)Double2CharOpenHashMap.this.mask) & Double2CharOpenHashMap.this.mask;
                while (Double2CharOpenHashMap.this.used[pos]) {
                    if (Double.doubleToLongBits(Double2CharOpenHashMap.this.key[pos]) == Double.doubleToLongBits(k)) {
                        return pos;
                    }
                    pos = pos + 1 & Double2CharOpenHashMap.this.mask;
                }
            }
            this.last = this.pos;
            if (this.c != 0) {
                boolean[] used = Double2CharOpenHashMap.this.used;
                while (this.pos-- != 0 && !used[this.pos]) {
                }
            }
            return this.last;
        }

        protected final int shiftKeys(int pos) {
            int last;
            while (true) {
                last = pos;
                pos = last + 1 & Double2CharOpenHashMap.this.mask;
                while (Double2CharOpenHashMap.this.used[pos]) {
                    int slot = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(Double2CharOpenHashMap.this.key[pos]) ^ (long)Double2CharOpenHashMap.this.mask) & Double2CharOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Double2CharOpenHashMap.this.mask;
                }
                if (!Double2CharOpenHashMap.this.used[pos]) break;
                if (pos < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new DoubleArrayList();
                    }
                    this.wrapped.add(Double2CharOpenHashMap.this.key[pos]);
                }
                Double2CharOpenHashMap.this.key[last] = Double2CharOpenHashMap.this.key[pos];
                Double2CharOpenHashMap.this.value[last] = Double2CharOpenHashMap.this.value[pos];
            }
            Double2CharOpenHashMap.this.used[last] = false;
            return last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            if (this.pos < -1) {
                Double2CharOpenHashMap.this.remove(this.wrapped.getDouble(-this.pos - 2));
                this.last = -1;
                return;
            }
            --Double2CharOpenHashMap.this.size;
            if (this.shiftKeys(this.last) == this.pos && this.c > 0) {
                ++this.c;
                this.nextEntry();
            }
            this.last = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Double2CharMap.Entry,
    Map.Entry<Double, Character> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Double getKey() {
            return Double2CharOpenHashMap.this.key[this.index];
        }

        @Override
        public double getDoubleKey() {
            return Double2CharOpenHashMap.this.key[this.index];
        }

        @Override
        public Character getValue() {
            return Character.valueOf(Double2CharOpenHashMap.this.value[this.index]);
        }

        @Override
        public char getCharValue() {
            return Double2CharOpenHashMap.this.value[this.index];
        }

        @Override
        public char setValue(char v) {
            char oldValue = Double2CharOpenHashMap.this.value[this.index];
            Double2CharOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Character setValue(Character v) {
            return Character.valueOf(this.setValue(v.charValue()));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Double.doubleToLongBits(Double2CharOpenHashMap.this.key[this.index]) == Double.doubleToLongBits((Double)e.getKey()) && Double2CharOpenHashMap.this.value[this.index] == ((Character)e.getValue()).charValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.double2int(Double2CharOpenHashMap.this.key[this.index]) ^ Double2CharOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Double2CharOpenHashMap.this.key[this.index] + "=>" + Double2CharOpenHashMap.this.value[this.index];
        }
    }
}

