/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.io;

import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.MeasurableInputStream;
import it.unimi.dsi.fastutil.io.RepositionableStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class FastMultiByteArrayInputStream
extends MeasurableInputStream
implements RepositionableStream {
    public static final int SLICE_BITS = 30;
    public static final int SLICE_SIZE = 0x40000000;
    public static final int SLICE_MASK = 0x3FFFFFFF;
    public byte[][] array;
    public long length;
    private long position;
    private long mark;

    public FastMultiByteArrayInputStream(MeasurableInputStream is) throws IOException {
        this(is, is.length());
    }

    public FastMultiByteArrayInputStream(InputStream is, long size) throws IOException {
        this.length = size;
        this.array = new byte[(int)((size + 0x40000000L - 1L) / 0x40000000L)][];
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = new byte[size >= 0x40000000L ? 0x40000000 : (int)size];
            if (BinIO.loadBytes(is, this.array[i]) != this.array[i].length) {
                throw new EOFException();
            }
            size -= (long)this.array[i].length;
        }
    }

    public FastMultiByteArrayInputStream(FastMultiByteArrayInputStream is) {
        this.array = is.array;
        this.length = is.length;
    }

    public FastMultiByteArrayInputStream(byte[] array) {
        this.array = new byte[1][];
        this.array[0] = array;
        this.length = array.length;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void reset() {
        this.position = this.mark;
    }

    @Override
    public void close() {
    }

    @Override
    public void mark(int dummy) {
        this.mark = this.position;
    }

    @Override
    public int available() {
        if (this.length - this.position > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)(this.length - this.position);
    }

    @Override
    public long skip(long n) {
        if (n <= this.length - this.position) {
            this.position += n;
            return n;
        }
        n = this.length - this.position;
        this.position = this.length;
        return n;
    }

    @Override
    public int read() {
        if (this.length == this.position) {
            return -1;
        }
        return this.array[(int)(this.position >>> 30)][(int)(this.position++ & 0x3FFFFFFFL)] & 0xFF;
    }

    @Override
    public int read(byte[] b, int offset, int length) {
        int res;
        int n;
        if (this.length == this.position) {
            return length == 0 ? 0 : -1;
        }
        int m = n = (int)Math.min((long)length, this.length - this.position);
        do {
            res = Math.min(n, this.array[(int)(this.position >>> 30)].length - (int)(this.position & 0x3FFFFFFFL));
            System.arraycopy(this.array[(int)(this.position >>> 30)], (int)(this.position & 0x3FFFFFFFL), b, offset, res);
            offset += res;
            this.position += (long)res;
        } while ((n -= res) > 0);
        return m;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public void position(long newPosition) {
        this.position = Math.min(newPosition, this.length);
    }

    @Override
    public long length() throws IOException {
        return this.length;
    }
}

