/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloat2DoubleMap;
import it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import it.unimi.dsi.fastutil.floats.Float2DoubleMap;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;

public class Float2DoubleOpenHashMap
extends AbstractFloat2DoubleMap
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient float[] key;
    protected transient double[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Float2DoubleMap.FastEntrySet entries;
    protected volatile transient FloatSet keys;
    protected volatile transient DoubleCollection values;

    public Float2DoubleOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new float[this.n];
        this.value = new double[this.n];
        this.used = new boolean[this.n];
    }

    public Float2DoubleOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Float2DoubleOpenHashMap() {
        this(16, 0.75f);
    }

    public Float2DoubleOpenHashMap(Map<? extends Float, ? extends Double> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Float2DoubleOpenHashMap(Map<? extends Float, ? extends Double> m) {
        this(m, 0.75f);
    }

    public Float2DoubleOpenHashMap(Float2DoubleMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Float2DoubleOpenHashMap(Float2DoubleMap m) {
        this(m, 0.75f);
    }

    public Float2DoubleOpenHashMap(float[] k, double[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Float2DoubleOpenHashMap(float[] k, double[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public double put(float k, double v) {
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                double oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Double put(Float ok, Double ov) {
        double v = ov;
        float k = ok.floatValue();
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                Double oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return null;
    }

    @Deprecated
    public double add(float k, double incr) {
        return this.addTo(k, incr);
    }

    public double addTo(float k, double incr) {
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                double oldValue = this.value[pos];
                int n = pos;
                this.value[n] = this.value[n] + incr;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = this.defRetValue + incr;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    protected final int shiftKeys(int pos) {
        int last;
        while (true) {
            last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(HashCommon.float2int(this.key[pos]) ^ this.mask) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
        }
        this.used[last] = false;
        return last;
    }

    @Override
    public double remove(float k) {
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                --this.size;
                double v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public Double remove(Object ok) {
        float k = ((Float)ok).floatValue();
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                --this.size;
                double v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    public Double get(Float ok) {
        float k = ok.floatValue();
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    @Override
    public double get(float k) {
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(float k) {
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(double v) {
        double[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    public Float2DoubleMap.FastEntrySet float2DoubleEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public FloatSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public DoubleCollection values() {
        if (this.values == null) {
            this.values = new AbstractDoubleCollection(){

                @Override
                public DoubleIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Float2DoubleOpenHashMap.this.size;
                }

                @Override
                public boolean contains(double v) {
                    return Float2DoubleOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Float2DoubleOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = 0;
        boolean[] used = this.used;
        float[] key = this.key;
        double[] value = this.value;
        int mask = newN - 1;
        float[] newKey = new float[newN];
        double[] newValue = new double[newN];
        boolean[] newUsed = new boolean[newN];
        int j = this.size;
        while (j-- != 0) {
            while (!used[i]) {
                ++i;
            }
            float k = key[i];
            int pos = HashCommon.murmurHash3(HashCommon.float2int(k) ^ mask) & mask;
            while (newUsed[pos]) {
                pos = pos + 1 & mask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            ++i;
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
    }

    public Float2DoubleOpenHashMap clone() {
        Float2DoubleOpenHashMap c;
        try {
            c = (Float2DoubleOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (float[])this.key.clone();
        c.value = (double[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = HashCommon.float2int(this.key[i]);
            h += (t ^= HashCommon.double2int(this.value[i]));
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        float[] key = this.key;
        double[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeFloat(key[e]);
            s.writeDouble(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new float[this.n];
        float[] key = this.key;
        this.value = new double[this.n];
        double[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            float k = s.readFloat();
            double v = s.readDouble();
            pos = HashCommon.murmurHash3(HashCommon.float2int(k) ^ this.mask) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements DoubleIterator {
        @Override
        public double nextDouble() {
            return Float2DoubleOpenHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Double next() {
            return Float2DoubleOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractFloatSet {
        private KeySet() {
        }

        @Override
        public FloatIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Float2DoubleOpenHashMap.this.size;
        }

        @Override
        public boolean contains(float k) {
            return Float2DoubleOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(float k) {
            int oldSize = Float2DoubleOpenHashMap.this.size;
            Float2DoubleOpenHashMap.this.remove(k);
            return Float2DoubleOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Float2DoubleOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements FloatIterator {
        @Override
        public float nextFloat() {
            return Float2DoubleOpenHashMap.this.key[this.nextEntry()];
        }

        @Override
        public Float next() {
            return Float.valueOf(Float2DoubleOpenHashMap.this.key[this.nextEntry()]);
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Float2DoubleMap.Entry>
    implements Float2DoubleMap.FastEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Float2DoubleMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Float2DoubleMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            float k = ((Float)e.getKey()).floatValue();
            int pos = HashCommon.murmurHash3(HashCommon.float2int(k) ^ Float2DoubleOpenHashMap.this.mask) & Float2DoubleOpenHashMap.this.mask;
            while (Float2DoubleOpenHashMap.this.used[pos]) {
                if (Float2DoubleOpenHashMap.this.key[pos] == k) {
                    return Float2DoubleOpenHashMap.this.value[pos] == (Double)e.getValue();
                }
                pos = pos + 1 & Float2DoubleOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            float k = ((Float)e.getKey()).floatValue();
            int pos = HashCommon.murmurHash3(HashCommon.float2int(k) ^ Float2DoubleOpenHashMap.this.mask) & Float2DoubleOpenHashMap.this.mask;
            while (Float2DoubleOpenHashMap.this.used[pos]) {
                if (Float2DoubleOpenHashMap.this.key[pos] == k) {
                    Float2DoubleOpenHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Float2DoubleOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Float2DoubleOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Float2DoubleOpenHashMap.this.clear();
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Float2DoubleMap.Entry> {
        final AbstractFloat2DoubleMap.BasicEntry entry;

        private FastEntryIterator() {
            this.entry = new AbstractFloat2DoubleMap.BasicEntry(0.0f, 0.0);
        }

        @Override
        public AbstractFloat2DoubleMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Float2DoubleOpenHashMap.this.key[e];
            this.entry.value = Float2DoubleOpenHashMap.this.value[e];
            return this.entry;
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Float2DoubleMap.Entry> {
        private MapEntry entry;

        private EntryIterator() {
        }

        @Override
        public Float2DoubleMap.Entry next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;
        FloatArrayList wrapped;

        private MapIterator() {
            this.pos = Float2DoubleOpenHashMap.this.n;
            this.last = -1;
            this.c = Float2DoubleOpenHashMap.this.size;
            boolean[] used = Float2DoubleOpenHashMap.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.pos < 0) {
                this.last = --this.pos;
                float k = this.wrapped.getFloat(-this.pos - 2);
                int pos = HashCommon.murmurHash3(HashCommon.float2int(k) ^ Float2DoubleOpenHashMap.this.mask) & Float2DoubleOpenHashMap.this.mask;
                while (Float2DoubleOpenHashMap.this.used[pos]) {
                    if (Float2DoubleOpenHashMap.this.key[pos] == k) {
                        return pos;
                    }
                    pos = pos + 1 & Float2DoubleOpenHashMap.this.mask;
                }
            }
            this.last = this.pos;
            if (this.c != 0) {
                boolean[] used = Float2DoubleOpenHashMap.this.used;
                while (this.pos-- != 0 && !used[this.pos]) {
                }
            }
            return this.last;
        }

        protected final int shiftKeys(int pos) {
            int last;
            while (true) {
                last = pos;
                pos = last + 1 & Float2DoubleOpenHashMap.this.mask;
                while (Float2DoubleOpenHashMap.this.used[pos]) {
                    int slot = HashCommon.murmurHash3(HashCommon.float2int(Float2DoubleOpenHashMap.this.key[pos]) ^ Float2DoubleOpenHashMap.this.mask) & Float2DoubleOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Float2DoubleOpenHashMap.this.mask;
                }
                if (!Float2DoubleOpenHashMap.this.used[pos]) break;
                if (pos < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new FloatArrayList();
                    }
                    this.wrapped.add(Float2DoubleOpenHashMap.this.key[pos]);
                }
                Float2DoubleOpenHashMap.this.key[last] = Float2DoubleOpenHashMap.this.key[pos];
                Float2DoubleOpenHashMap.this.value[last] = Float2DoubleOpenHashMap.this.value[pos];
            }
            Float2DoubleOpenHashMap.this.used[last] = false;
            return last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            if (this.pos < -1) {
                Float2DoubleOpenHashMap.this.remove(this.wrapped.getFloat(-this.pos - 2));
                this.last = -1;
                return;
            }
            --Float2DoubleOpenHashMap.this.size;
            if (this.shiftKeys(this.last) == this.pos && this.c > 0) {
                ++this.c;
                this.nextEntry();
            }
            this.last = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Float2DoubleMap.Entry,
    Map.Entry<Float, Double> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Float getKey() {
            return Float.valueOf(Float2DoubleOpenHashMap.this.key[this.index]);
        }

        @Override
        public float getFloatKey() {
            return Float2DoubleOpenHashMap.this.key[this.index];
        }

        @Override
        public Double getValue() {
            return Float2DoubleOpenHashMap.this.value[this.index];
        }

        @Override
        public double getDoubleValue() {
            return Float2DoubleOpenHashMap.this.value[this.index];
        }

        @Override
        public double setValue(double v) {
            double oldValue = Float2DoubleOpenHashMap.this.value[this.index];
            Float2DoubleOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Double setValue(Double v) {
            return this.setValue((double)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Float2DoubleOpenHashMap.this.key[this.index] == ((Float)e.getKey()).floatValue() && Float2DoubleOpenHashMap.this.value[this.index] == (Double)e.getValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.float2int(Float2DoubleOpenHashMap.this.key[this.index]) ^ HashCommon.double2int(Float2DoubleOpenHashMap.this.value[this.index]);
        }

        public String toString() {
            return Float2DoubleOpenHashMap.this.key[this.index] + "=>" + Float2DoubleOpenHashMap.this.value[this.index];
        }
    }
}

