/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.bytes.AbstractByte2ByteMap;
import it.unimi.dsi.fastutil.bytes.AbstractByte2ByteSortedMap;
import it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import it.unimi.dsi.fastutil.bytes.AbstractByteSortedSet;
import it.unimi.dsi.fastutil.bytes.Byte2ByteMap;
import it.unimi.dsi.fastutil.bytes.Byte2ByteSortedMap;
import it.unimi.dsi.fastutil.bytes.ByteBidirectionalIterator;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteComparator;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteListIterator;
import it.unimi.dsi.fastutil.bytes.ByteSortedSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Byte2ByteLinkedOpenHashMap
extends AbstractByte2ByteSortedMap
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient byte[] key;
    protected transient byte[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Byte2ByteSortedMap.FastSortedEntrySet entries;
    protected volatile transient ByteSortedSet keys;
    protected volatile transient ByteCollection values;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;

    public Byte2ByteLinkedOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new byte[this.n];
        this.value = new byte[this.n];
        this.used = new boolean[this.n];
        this.link = new int[this.n];
    }

    public Byte2ByteLinkedOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Byte2ByteLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Byte2ByteLinkedOpenHashMap(Map<? extends Byte, ? extends Byte> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Byte2ByteLinkedOpenHashMap(Map<? extends Byte, ? extends Byte> m) {
        this(m, 0.75f);
    }

    public Byte2ByteLinkedOpenHashMap(Byte2ByteMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Byte2ByteLinkedOpenHashMap(Byte2ByteMap m) {
        this(m, 0.75f);
    }

    public Byte2ByteLinkedOpenHashMap(byte[] k, byte[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Byte2ByteLinkedOpenHashMap(byte[] k, byte[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public byte put(byte k, byte v) {
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                byte oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Byte put(Byte ok, Byte ov) {
        byte v = ov;
        byte k = ok;
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                Byte oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return null;
    }

    public byte add(byte k, byte incr) {
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                byte oldValue = this.value[pos];
                int n = pos;
                this.value[n] = (byte)(this.value[n] + incr);
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = (byte)(this.defRetValue + incr);
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    protected final void shiftKeys(int pos) {
        while (true) {
            int last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(this.key[pos]) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
            this.fixPointers(pos, last);
        }
        this.used[last] = false;
    }

    @Override
    public byte remove(byte k) {
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                --this.size;
                this.fixPointers(pos);
                byte v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public Byte remove(Object ok) {
        byte k = (Byte)ok;
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                --this.size;
                this.fixPointers(pos);
                byte v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    public Byte get(Byte ok) {
        byte k = ok;
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    @Override
    public byte get(byte k) {
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(byte k) {
        int pos = HashCommon.murmurHash3(k) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(byte v) {
        byte[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    protected void fixPointers(int i) {
        int next;
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    protected void fixPointers(int s, int d) {
        int next;
        if (this.size == 1) {
            this.first = this.last = d;
            this.link[d] = 0;
            return;
        }
        if (this.first == s) {
            this.first = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        if (this.last == s) {
            this.last = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != s) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (s ^ d);
        int n2 = this.link[s] ^ j;
        this.link[n2] = this.link[n2] ^ (s ^ d);
        this.link[d] = this.link[s];
    }

    @Override
    public byte firstByteKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public byte lastByteKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public ByteComparator comparator() {
        return null;
    }

    @Override
    public Byte2ByteSortedMap tailMap(byte from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte2ByteSortedMap headMap(byte to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte2ByteSortedMap subMap(byte from, byte to) {
        throw new UnsupportedOperationException();
    }

    public Byte2ByteSortedMap.FastSortedEntrySet byte2ByteEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public ByteSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ByteCollection values() {
        if (this.values == null) {
            this.values = new AbstractByteCollection(){

                public ByteIterator iterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Byte2ByteLinkedOpenHashMap.this.size;
                }

                public boolean contains(byte v) {
                    return Byte2ByteLinkedOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Byte2ByteLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = this.first;
        int prev = -1;
        int newPrev = -1;
        byte[] key = this.key;
        byte[] value = this.value;
        int newMask = newN - 1;
        byte[] newKey = new byte[newN];
        byte[] newValue = new byte[newN];
        boolean[] newUsed = new boolean[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        int j = this.size;
        while (j-- != 0) {
            byte k = key[i];
            int pos = HashCommon.murmurHash3(k) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            if (prev != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ pos;
                newLink[pos] = newPrev;
                newPrev = pos;
            } else {
                newPrev = this.first = pos;
                newLink[pos] = -1;
            }
            int t = i;
            i = link[i] ^ prev;
            prev = t;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    public Byte2ByteLinkedOpenHashMap clone() {
        Byte2ByteLinkedOpenHashMap c;
        try {
            c = (Byte2ByteLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (byte[])this.key.clone();
        c.value = (byte[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = this.key[i];
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        byte[] key = this.key;
        byte[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeByte(key[e]);
            s.writeByte(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new byte[this.n];
        byte[] key = this.key;
        this.value = new byte[this.n];
        byte[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        this.link = new int[this.n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            byte k = s.readByte();
            byte v = s.readByte();
            pos = HashCommon.murmurHash3(k) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
            if (this.first != -1) {
                int n = prev;
                link[n] = link[n] ^ pos;
                link[pos] = prev;
                prev = pos;
                continue;
            }
            prev = this.first = pos;
            link[pos] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n = prev;
            link[n] = ~link[n];
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements ByteListIterator {
        public byte previousByte() {
            return Byte2ByteLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        public Byte previous() {
            return Byte2ByteLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        public void set(Byte ok) {
            throw new UnsupportedOperationException();
        }

        public void add(Byte ok) {
            throw new UnsupportedOperationException();
        }

        public void set(byte v) {
            throw new UnsupportedOperationException();
        }

        public void add(byte v) {
            throw new UnsupportedOperationException();
        }

        public byte nextByte() {
            return Byte2ByteLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        public Byte next() {
            return Byte2ByteLinkedOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractByteSortedSet {
        private KeySet() {
        }

        public ByteBidirectionalIterator iterator(byte from) {
            return new KeyIterator(from);
        }

        public ByteBidirectionalIterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return Byte2ByteLinkedOpenHashMap.this.size;
        }

        public boolean contains(byte k) {
            return Byte2ByteLinkedOpenHashMap.this.containsKey(k);
        }

        public boolean remove(byte k) {
            int oldSize = Byte2ByteLinkedOpenHashMap.this.size;
            Byte2ByteLinkedOpenHashMap.this.remove(k);
            return Byte2ByteLinkedOpenHashMap.this.size != oldSize;
        }

        public void clear() {
            Byte2ByteLinkedOpenHashMap.this.clear();
        }

        public byte firstByte() {
            if (Byte2ByteLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Byte2ByteLinkedOpenHashMap.this.key[Byte2ByteLinkedOpenHashMap.this.first];
        }

        public byte lastByte() {
            if (Byte2ByteLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Byte2ByteLinkedOpenHashMap.this.key[Byte2ByteLinkedOpenHashMap.this.last];
        }

        public ByteComparator comparator() {
            return null;
        }

        public final ByteSortedSet tailSet(byte from) {
            throw new UnsupportedOperationException();
        }

        public final ByteSortedSet headSet(byte to) {
            throw new UnsupportedOperationException();
        }

        public final ByteSortedSet subSet(byte from, byte to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ByteListIterator {
        public KeyIterator(byte k) {
            super(k);
        }

        public byte previousByte() {
            return Byte2ByteLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        public void set(byte k) {
            throw new UnsupportedOperationException();
        }

        public void add(byte k) {
            throw new UnsupportedOperationException();
        }

        public Byte previous() {
            return Byte2ByteLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        public void set(Byte ok) {
            throw new UnsupportedOperationException();
        }

        public void add(Byte ok) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        public byte nextByte() {
            return Byte2ByteLinkedOpenHashMap.this.key[this.nextEntry()];
        }

        public Byte next() {
            return Byte2ByteLinkedOpenHashMap.this.key[this.nextEntry()];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntrySet
    extends AbstractObjectSortedSet<Byte2ByteMap.Entry>
    implements Byte2ByteSortedMap.FastSortedEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectBidirectionalIterator<Byte2ByteMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public Comparator<? super Byte2ByteMap.Entry> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Byte2ByteMap.Entry> subSet(Byte2ByteMap.Entry fromElement, Byte2ByteMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Byte2ByteMap.Entry> headSet(Byte2ByteMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Byte2ByteMap.Entry> tailSet(Byte2ByteMap.Entry fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Byte2ByteMap.Entry first() {
            if (Byte2ByteLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Byte2ByteLinkedOpenHashMap.this.first);
        }

        @Override
        public Byte2ByteMap.Entry last() {
            if (Byte2ByteLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Byte2ByteLinkedOpenHashMap.this.last);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            byte k = (Byte)e.getKey();
            int pos = HashCommon.murmurHash3(k) & Byte2ByteLinkedOpenHashMap.this.mask;
            while (Byte2ByteLinkedOpenHashMap.this.used[pos]) {
                if (k == Byte2ByteLinkedOpenHashMap.this.key[pos]) {
                    return Byte2ByteLinkedOpenHashMap.this.value[pos] == (Byte)e.getValue();
                }
                pos = pos + 1 & Byte2ByteLinkedOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            byte k = (Byte)e.getKey();
            int pos = HashCommon.murmurHash3(k) & Byte2ByteLinkedOpenHashMap.this.mask;
            while (Byte2ByteLinkedOpenHashMap.this.used[pos]) {
                if (k == Byte2ByteLinkedOpenHashMap.this.key[pos]) {
                    Byte2ByteLinkedOpenHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Byte2ByteLinkedOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Byte2ByteLinkedOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Byte2ByteLinkedOpenHashMap.this.clear();
        }

        @Override
        public ObjectBidirectionalIterator<Byte2ByteMap.Entry> iterator(Byte2ByteMap.Entry from) {
            return new EntryIterator((Byte)from.getKey());
        }

        public ObjectBidirectionalIterator<Byte2ByteMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Byte2ByteMap.Entry> fastIterator(Byte2ByteMap.Entry from) {
            return new FastEntryIterator((Byte)from.getKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Byte2ByteMap.Entry> {
        final AbstractByte2ByteMap.BasicEntry entry;

        public FastEntryIterator() {
            this.entry = new AbstractByte2ByteMap.BasicEntry(0, 0);
        }

        public FastEntryIterator(byte from) {
            super(from);
            this.entry = new AbstractByte2ByteMap.BasicEntry(0, 0);
        }

        @Override
        public AbstractByte2ByteMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Byte2ByteLinkedOpenHashMap.this.key[e];
            this.entry.value = Byte2ByteLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public AbstractByte2ByteMap.BasicEntry previous() {
            int e = this.previousEntry();
            this.entry.key = Byte2ByteLinkedOpenHashMap.this.key[e];
            this.entry.value = Byte2ByteLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public void set(Byte2ByteMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Byte2ByteMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Byte2ByteMap.Entry> {
        public EntryIterator() {
        }

        public EntryIterator(byte from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            return new MapEntry(this.nextEntry());
        }

        @Override
        public MapEntry previous() {
            return new MapEntry(this.previousEntry());
        }

        @Override
        public void set(Byte2ByteMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Byte2ByteMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        private MapIterator() {
            this.next = Byte2ByteLinkedOpenHashMap.this.first;
        }

        private MapIterator(byte from) {
            if (Byte2ByteLinkedOpenHashMap.this.key[Byte2ByteLinkedOpenHashMap.this.last] == from) {
                this.prev = Byte2ByteLinkedOpenHashMap.this.last;
                this.index = Byte2ByteLinkedOpenHashMap.this.size;
            } else {
                int e;
                if (!Byte2ByteLinkedOpenHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Byte2ByteLinkedOpenHashMap.this.first;
                while (Byte2ByteLinkedOpenHashMap.this.key[e = this.nextEntry()] != from) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                return Byte2ByteLinkedOpenHashMap.this.size();
            }
            this.curr = this.next;
            this.next = Byte2ByteLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                return -1;
            }
            this.curr = this.prev;
            this.prev = Byte2ByteLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Byte2ByteLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Byte2ByteLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            }
            --Byte2ByteLinkedOpenHashMap.this.size;
            if (this.prev == -1) {
                Byte2ByteLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Byte2ByteLinkedOpenHashMap.this.link[n] = Byte2ByteLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Byte2ByteLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Byte2ByteLinkedOpenHashMap.this.link[n] = Byte2ByteLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            int pos = this.curr;
            while (true) {
                int last = pos;
                pos = last + 1 & Byte2ByteLinkedOpenHashMap.this.mask;
                while (Byte2ByteLinkedOpenHashMap.this.used[pos]) {
                    int slot = HashCommon.murmurHash3(Byte2ByteLinkedOpenHashMap.this.key[pos]) & Byte2ByteLinkedOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Byte2ByteLinkedOpenHashMap.this.mask;
                }
                if (!Byte2ByteLinkedOpenHashMap.this.used[pos]) break;
                Byte2ByteLinkedOpenHashMap.this.key[last] = Byte2ByteLinkedOpenHashMap.this.key[pos];
                Byte2ByteLinkedOpenHashMap.this.value[last] = Byte2ByteLinkedOpenHashMap.this.value[pos];
                if (this.next == pos) {
                    this.next = last;
                }
                if (this.prev == pos) {
                    this.prev = last;
                }
                Byte2ByteLinkedOpenHashMap.this.fixPointers(pos, last);
            }
            Byte2ByteLinkedOpenHashMap.this.used[last] = false;
            this.curr = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntry
    implements Byte2ByteMap.Entry,
    Map.Entry<Byte, Byte> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Byte getKey() {
            return Byte2ByteLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public byte getByteKey() {
            return Byte2ByteLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public Byte getValue() {
            return Byte2ByteLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public byte getByteValue() {
            return Byte2ByteLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public byte setValue(byte v) {
            byte oldValue = Byte2ByteLinkedOpenHashMap.this.value[this.index];
            Byte2ByteLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Byte setValue(Byte v) {
            return this.setValue((byte)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Byte2ByteLinkedOpenHashMap.this.key[this.index] == (Byte)e.getKey() && Byte2ByteLinkedOpenHashMap.this.value[this.index] == (Byte)e.getValue();
        }

        @Override
        public int hashCode() {
            return Byte2ByteLinkedOpenHashMap.this.key[this.index] ^ Byte2ByteLinkedOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Byte2ByteLinkedOpenHashMap.this.key[this.index] + "=>" + Byte2ByteLinkedOpenHashMap.this.value[this.index];
        }
    }
}

