/* Generic definitions */




/* Assertions (useful to generate conditional code) */
/* Current type and class (and size, if applicable) */
/* Value methods */
/* Interfaces (keys) */
/* Interfaces (values) */
/* Abstract implementations (keys) */
/* Abstract implementations (values) */
/* Static containers (keys) */
/* Static containers (values) */
/* Implementations */
/* Synchronized wrappers */
/* Unmodifiable wrappers */
/* Other wrappers */
/* Methods (keys) */
/* Methods (values) */
/* Methods (keys/values) */
/* Methods that have special names depending on keys (but the special names depend on values) */
/* Equality */
/* Object/Reference-only definitions (keys) */
/* Primitive-type-only definitions (keys) */
/* Object/Reference-only definitions (values) */
/*		 
 * Copyright (C) 2002-2011 Sebastiano Vigna 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License. 
 */
package it.unimi.dsi.fastutil.doubles;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import static it.unimi.dsi.fastutil.HashCommon.arraySize;
import static it.unimi.dsi.fastutil.HashCommon.maxFill;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
/**  A type-specific linked hash set with with a fast, small-footprint implementation.
 *
 * <P>Instances of this class use a hash table to represent a set. The table is
 * enlarged as needed by doubling its size when new entries are created, but it is <em>never</em> made
 * smaller (even on a {@link #clear()}). A family of {@linkplain #trim() trimming
 * methods} lets you control the size of the table; this is particularly useful
 * if you reuse instances of this class.
 *
 * <P>Iterators created by this map will enumerate elements in the same order in which they
 * have been added to the set (addition of elements already present 
 * in the set does not change the iteration order). Note that this order has nothing in common with the natural
 * order of the keys.
 *
 * <P>This class implements the interface of a sorted set, so to allow easy
 * access of the iteration order: for instance, you can get the first element
 * in iteration order with {@link #first()} without having to create an
 * iterator; however, this class partially violates the {@link java.util.SortedSet}
 * contract because all subset methods throw an exception and {@link
 * #comparator()} returns always <code>null</code>.
 *
 * <P>The iterators provided by this class are type-specific {@linkplain
 * java.util.ListIterator list iterators}.  However, creation of an iterator
 * using a starting point is going to be very expensive, as the chosen starting
 * point must be linearly searched for, unless it is {@link #last()}, in which
 * case the iterator is created in constant time.
 *
 * <P>Note that deletions in a linked set are very expensive, as they usually
 * require scanning the list until the element to be removed and the elements
 * shifted because of the removal are found.
 *
 * <p><strong>Warning:</strong> The implementation of this class has significantly
 * changed in <code>fastutil</code> 6.1.0. Please read the
 * comments about this issue in the section &ldquo;Faster Hash Tables&rdquo; of the <a href="../../../../../overview-summary.html">overview</a>.
 *
 * @see Hash
 * @see HashCommon
 */
public class DoubleLinkedOpenHashSet extends AbstractDoubleSortedSet implements java.io.Serializable, Cloneable, Hash {
    public static final long serialVersionUID = 0L;
 private static final boolean ASSERTS = false;
 /** The array of keys. */
 protected transient double key[];
 /** The array telling whether a position is used. */
 protected transient boolean used[];
 /** The acceptable load factor. */
 protected final float f;
 /** The current table size. */
 protected transient int n;
 /** Threshold after which we rehash. It must be the table size times {@link #f}. */
 protected transient int maxFill;
 /** The mask for wrapping a position counter. */
 protected transient int mask;
 /** Number of entries in the set. */
 protected int size;
 /** The index of the first entry in iteration order. It is valid iff {@link #size} is nonzero; otherwise, it contains -1. */
 protected transient int first = -1;
 /** The index of the last entry in iteration order. It is valid iff {@link #size} is nonzero; otherwise, it contains -1. */
 protected transient int last = -1;
 /** For each entry, the next and the previous entry in iteration order
	exclusive-or'd together. It is valid only on {@link Hash#OCCUPIED}
	entries. The first and the last entry contain the actual successor and
	predecessor, respectively, exclusived-or'd with -1. */
 protected transient int link[];
 /** Creates a new hash set.
	 *
	 * <p>The actual table size will be the least power of two greater than <code>expected</code>/<code>f</code>.
	 *
	 * @param expected the expected number of elements in the hash set. 
	 * @param f the load factor.
	 */
 @SuppressWarnings("unchecked")
 public DoubleLinkedOpenHashSet( final int expected, final float f ) {
  if ( f <= 0 || f > 1 ) throw new IllegalArgumentException( "Load factor must be greater than 0 and smaller than or equal to 1" );
  if ( expected < 0 ) throw new IllegalArgumentException( "The expected number of elements must be nonnegative" );
  this.f = f;
  n = arraySize( expected, f );
  mask = n - 1;
  maxFill = maxFill( n, f );
  key = new double[ n ];
  used = new boolean[ n ];
  link = new int[ n ];
 }
 /** Creates a new hash set with {@link Hash#DEFAULT_LOAD_FACTOR} as load factor.
	 *
	 * @param expected the expected number of elements in the hash set. 
	 */
 public DoubleLinkedOpenHashSet( final int expected ) {
  this( expected, DEFAULT_LOAD_FACTOR );
 }
 /** Creates a new hash set with initial expected {@link Hash#DEFAULT_INITIAL_SIZE} elements
	 * and {@link Hash#DEFAULT_LOAD_FACTOR} as load factor.
	 */
 public DoubleLinkedOpenHashSet() {
  this( DEFAULT_INITIAL_SIZE, DEFAULT_LOAD_FACTOR );
 }
 /** Creates a new hash set copying a given collection.
	 *
	 * @param c a {@link Collection} to be copied into the new hash set. 
	 * @param f the load factor.
	 */
 public DoubleLinkedOpenHashSet( final Collection<? extends Double> c, final float f ) {
  this( c.size(), f );
  addAll( c );
 }
 /** Creates a new hash set  with {@link Hash#DEFAULT_LOAD_FACTOR} as load factor 
	 * copying a given collection.
	 *
	 * @param c a {@link Collection} to be copied into the new hash set. 
	 */
 public DoubleLinkedOpenHashSet( final Collection<? extends Double> c ) {
  this( c, DEFAULT_LOAD_FACTOR );
 }
 /** Creates a new hash set copying a given type-specific collection.
	 *
	 * @param c a type-specific collection to be copied into the new hash set. 
	 * @param f the load factor.
	 */
 public DoubleLinkedOpenHashSet( final DoubleCollection c, final float f ) {
  this( c.size(), f );
  addAll( c );
 }
 /** Creates a new hash set  with {@link Hash#DEFAULT_LOAD_FACTOR} as load factor 
	 * copying a given type-specific collection.
	 *
	 * @param c a type-specific collection to be copied into the new hash set. 
	 */
 public DoubleLinkedOpenHashSet( final DoubleCollection c ) {
  this( c, DEFAULT_LOAD_FACTOR );
 }
 /** Creates a new hash set using elements provided by a type-specific iterator.
	 *
	 * @param i a type-specific iterator whose elements will fill the set.
	 * @param f the load factor.
	 */
 public DoubleLinkedOpenHashSet( final DoubleIterator i, final float f ) {
  this( DEFAULT_INITIAL_SIZE, f );
  while( i.hasNext() ) add( i.nextDouble() );
 }
 /** Creates a new hash set with {@link Hash#DEFAULT_LOAD_FACTOR} as load factor using elements provided by a type-specific iterator.
	 *
	 * @param i a type-specific iterator whose elements will fill the set.
	 */
 public DoubleLinkedOpenHashSet( final DoubleIterator i ) {
  this( i, DEFAULT_LOAD_FACTOR );
 }
 /** Creates a new hash set using elements provided by an iterator.
	 *
	 * @param i an iterator whose elements will fill the set.
	 * @param f the load factor.
	 */
 public DoubleLinkedOpenHashSet( final Iterator<?> i, final float f ) {
  this( DoubleIterators.asDoubleIterator( i ), f );
 }
 /** Creates a new hash set with {@link Hash#DEFAULT_LOAD_FACTOR} as load factor using elements provided by an iterator.
	 *
	 * @param i an iterator whose elements will fill the set.
	 */
 public DoubleLinkedOpenHashSet( final Iterator<?> i ) {
  this( DoubleIterators.asDoubleIterator( i ) );
 }
 /** Creates a new hash set and fills it with the elements of a given array.
	 *
	 * @param a an array whose elements will be used to fill the set.
	 * @param offset the first element to use.
	 * @param length the number of elements to use.
	 * @param f the load factor.
	 */
 public DoubleLinkedOpenHashSet( final double[] a, final int offset, final int length, final float f ) {
  this( length < 0 ? 0 : length, f );
  DoubleArrays.ensureOffsetLength( a, offset, length );
  for( int i = 0; i < length; i++ ) add( a[ offset + i ] );
 }
 /** Creates a new hash set with {@link Hash#DEFAULT_LOAD_FACTOR} as load factor and fills it with the elements of a given array.
	 *
	 * @param a an array whose elements will be used to fill the set.
	 * @param offset the first element to use.
	 * @param length the number of elements to use.
	 */
 public DoubleLinkedOpenHashSet( final double[] a, final int offset, final int length ) {
  this( a, offset, length, DEFAULT_LOAD_FACTOR );
 }
 /** Creates a new hash set copying the elements of an array.
	 *
	 * @param a an array to be copied into the new hash set. 
	 * @param f the load factor.
	 */
 public DoubleLinkedOpenHashSet( final double[] a, final float f ) {
  this( a, 0, a.length, f );
 }
 /** Creates a new hash set with {@link Hash#DEFAULT_LOAD_FACTOR} as load factor 
	 * copying the elements of an array.
	 *
	 * @param a an array to be copied into the new hash set. 
	 */
 public DoubleLinkedOpenHashSet( final double[] a ) {
  this( a, DEFAULT_LOAD_FACTOR );
 }
 /*
	 * The following methods implements some basic building blocks used by
	 * all accessors. They are (and should be maintained) identical to those used in HashMap.drv.
	 */
 public boolean add( final double k ) {
  // The starting point.
  int pos = (int)it.unimi.dsi.fastutil.HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & mask;
  // There's always an unused entry.
  while( used[ pos ] ) {
   if ( ( (k) == (key[ pos ]) ) ) return false;
   pos = ( pos + 1 ) & mask;
  }
  used[ pos ] = true;
  key[ pos ] = k;
  if ( size == 0 ) {
   first = last = pos;
   link[ pos ] = 0;
  }
  else {
   link[ last ] ^= pos ^ -1;
   link[ pos ] = last ^ -1;
   last = pos;
  }
  if ( ++size >= maxFill ) rehash( arraySize( size + 1, f ) );
  if ( ASSERTS ) checkTable();
  return true;
 }
 /** Shifts left entries with the specified hash code, starting at the specified position,
	 * and empties the resulting free entry.
	 *
	 * @param pos a starting position.
	 */
 protected final void shiftKeys( int pos ) {
  // Shift entries with the same hash.
  int last, slot;
  for(;;) {
   pos = ( ( last = pos ) + 1 ) & mask;
   while( used[ pos ] ) {
    slot = (int)it.unimi.dsi.fastutil.HashCommon.murmurHash3(Double.doubleToRawLongBits(key[ pos ])) & mask;
    if ( last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos ) break;
    pos = ( pos + 1 ) & mask;
   }
   if ( ! used[ pos ] ) break;
   key[ last ] = key[ pos ];
   fixPointers( pos, last );
  }
  used[ last ] = false;
 }
 @SuppressWarnings("unchecked")
 public boolean remove( final double k ) {
  // The starting point.
  int pos = (int)it.unimi.dsi.fastutil.HashCommon.murmurHash3(Double.doubleToRawLongBits( k)) & mask;
  // There's always an unused entry.
  while( used[ pos ] ) {
   if ( ( ( k) == (key[ pos ]) ) ) {
    size--;
    fixPointers( pos );
    shiftKeys( pos );
    if ( ASSERTS ) checkTable();
    return true;
   }
   pos = ( pos + 1 ) & mask;
  }
  return false;
 }
 @SuppressWarnings("unchecked")
 public boolean contains( final double k ) {
  // The starting point.
  int pos = (int)it.unimi.dsi.fastutil.HashCommon.murmurHash3(Double.doubleToRawLongBits( k)) & mask;
  // There's always an unused entry.
  while( used[ pos ] ) {
   if ( ( ( k) == (key[ pos ]) ) ) return true;
   pos = ( pos + 1 ) & mask;
  }
  return used[ pos ];
 }
 /* Removes all elements from this set.
	 *
	 * <P>To increase object reuse, this method does not change the table size.
	 * If you want to reduce the table size, you must use {@link #trim()}.
	 *
	 */
 public void clear() {
  if ( size == 0 ) return;
  size = 0;
  BooleanArrays.fill( used, false );
  first = last = -1;
 }
 public int size() {
  return size;
 }
 public boolean isEmpty() {
  return size == 0;
 }
 /** A no-op for backward compatibility.
	 * 
	 * @param growthFactor unused.
	 * @deprecated Since <code>fastutil</code> 6.1.0, hash tables are doubled when they are too full.
	 */
 @Deprecated
 public void growthFactor( int growthFactor ) {}
 /** Gets the growth factor (2).
	 *
	 * @return the growth factor of this set, which is fixed (2).
	 * @see #growthFactor(int)
	 * @deprecated Since <code>fastutil</code> 6.1.0, hash tables are doubled when they are too full.
	 */
 @Deprecated
 public int growthFactor() {
  return 16;
 }
 /** Modifies the {@link #link} vector so that the given entry is removed.
	 *
	 * <P>If the given entry is the first or the last one, this method will complete
	 * in constant time; otherwise, it will have to search for the given entry.
	 *
	 * @param i the index of an entry. 
	 */
 protected void fixPointers( final int i ) {
  if ( size == 0 ) {
   first = last = -1;
   return;
  }
  if ( first == i ) {
   first = link[ i ] ^ -1;
   link[ first ] ^= i ^ -1;
   return;
  }
  if ( last == i ) {
   last = link[ i ] ^ -1;
   link[ last ] ^= i ^ -1;
   return;
  }
  int j = first, prev = -1, next;
  while( ( next = link[ j ] ^ prev ) != i ) {
   prev = j;
   j = next;
  }
  link[ j ] ^= link[ i ] ^ i ^ j;
  link[ link[ i ] ^ j ] ^= i ^ j;
 }
 /** Modifies the {@link #link} vector for a shift from s to d.
	 *
	 * <P>If the given entry is the first or the last one, this method will complete
	 * in constant time; otherwise, it will have to search for the given entry.
	 *
	 * @param s the source position.
	 * @param d the destination position.
	 */
 protected void fixPointers( int s, int d ) {
  if ( size == 1 ) {
   first = last = d;
   link[ d ] = 0;
   return;
  }
  if ( first == s ) {
   first = d;
   link[ link[ s ] ^ -1 ] ^= s ^ d;
   link[ d ] = link[ s ];
   return;
  }
  if ( last == s ) {
   last = d;
   link[ link[ s ] ^ -1 ] ^= s ^ d;
   link[ d ] = link[ s ];
   return;
  }
  int j = first, prev = -1, next;
  while( ( next = link[ j ] ^ prev ) != s ) {
   prev = j;
   j = next;
  }
  link[ j ] ^= s ^ d;
  link[ link[ s ] ^ j ] ^= s ^ d;
  link[ d ] = link[ s ];
 }
 /** Returns the first element of this set in iteration order.
	 *
	 * @return the first element in iteration order.
	 */
 public double firstDouble() {
  if ( size == 0 ) throw new NoSuchElementException();
  return key[ first ];
 }
 /** Returns the last element of this set in iteration order.
	 *
	 * @return the last element in iteration order.
	 */
 public double lastDouble() {
  if ( size == 0 ) throw new NoSuchElementException();
  return key[ last ];
 }
 public DoubleSortedSet tailSet( double from ) { throw new UnsupportedOperationException(); }
 public DoubleSortedSet headSet( double to ) { throw new UnsupportedOperationException(); }
 public DoubleSortedSet subSet( double from, double to ) { throw new UnsupportedOperationException(); }
 public DoubleComparator comparator() { return null; }
 /** A list iterator over a linked set.
	 *
	 * <P>This class provides a list iterator over a linked hash set. The empty constructor runs in 
	 * constant time. The one-argument constructor needs to search for the given element, but it is 
	 * optimized for the case of {@link java.util.SortedSet#last()}, in which case runs in constant time, too.
	 */
 private class SetIterator extends AbstractDoubleListIterator {
  /** The entry that will be returned by the next call to {@link java.util.ListIterator#previous()} (or <code>null</code> if no previous entry exists). */
  int prev = -1;
  /** The entry that will be returned by the next call to {@link java.util.ListIterator#next()} (or <code>null</code> if no next entry exists). */
  int next = -1;
  /** The last entry that was returned (or -1 if we did not iterate or used {@link #remove()}). */
  int curr = -1;
  /** The current index (in the sense of a {@link java.util.ListIterator}). Note that this value is not meaningful when this {@link SetIterator} has been created using the nonempty constructor.*/
  int index = 0;
  SetIterator() {
   next = first;
  }
  SetIterator( double from ) {
   if ( ( (key[ last ]) == (from) ) ) {
    prev = last;
    index = size;
   }
   else {
    if ( ! contains( from ) ) throw new IllegalArgumentException( "The key " + from + " does not belong to this set." );
    next = first;
    double k;
    do k = nextDouble(); while( ! ( (k) == (from) ) );
    curr = -1;
   }
  }
  public boolean hasNext() { return next != -1; }
  public boolean hasPrevious() { return prev != -1; }
  public double nextDouble() {
   if ( ! hasNext() ) throw new NoSuchElementException();
   curr = next;
   next = link[ curr ] ^ prev;
   prev = curr;
   index++;
   if ( ASSERTS ) assert used[ curr ] : "Position " + curr + " is not used";
   return key[ curr ];
  }
  public double previousDouble() {
   if ( ! hasPrevious() ) throw new NoSuchElementException();
   curr = prev;
   prev = link[ curr ] ^ next;
   next = curr;
   index--;
   return key[ curr ];
  }
  public int nextIndex() {
   return index;
  }
  public int previousIndex() {
   return index - 1;
  }
  @SuppressWarnings("unchecked")
  public void remove() {
   if ( curr == -1 ) throw new IllegalStateException();
   if ( curr == prev ) {
    /* If the last operation was a next(), we are removing an entry that preceeds
				   the current index, and thus we must decrement it. */
    index--;
    prev = link[ curr ] ^ next;
   }
   else next = link[ curr ] ^ prev; // curr == next
   size--;
   /* Now we manually fix the pointers. Because of our knowledge of next
			   and prev, this is going to be faster than calling fixPointers(). */
   if ( prev == -1 ) first = next;
   else link[ prev ] ^= curr ^ next;
   if ( next == -1 ) last = prev;
   else link[ next ] ^= curr ^ prev;
   int last, slot, pos = curr;
   // We have to horribly duplicated the shiftKeys() code because we need to update next/prev.			
   for(;;) {
    pos = ( ( last = pos ) + 1 ) & mask;
    while( used[ pos ] ) {
     slot = (int)it.unimi.dsi.fastutil.HashCommon.murmurHash3(Double.doubleToRawLongBits(key[ pos ])) & mask;
     if ( last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos ) break;
     pos = ( pos + 1 ) & mask;
    }
    if ( ! used[ pos ] ) break;
    key[ last ] = key[ pos ];
    if ( next == pos ) next = last;
    if ( prev == pos ) prev = last;
    fixPointers( pos, last );
   }
   used[ last ] = false;
   curr = -1;
  }
 }
 /** Returns a type-specific list iterator on the elements in this set, starting from a given element of the set.
	 *
	 * <P>This method provides an iterator positioned immediately after the
	 * given element. That is, the next call to <code>previous()</code> will
	 * return <code>from</code>, whereas the next call to <code>next()</code>
	 * will return the element immediately after <code>from</code>. This
	 * allows to call <code>iterator(last())</code> and obtain an iterator starting
	 * from the end of the iteration order.
	 *
	 * <P>Because of the way linking is implemented, generating an iterator using this method
	 * requires constant time only if the argument is <code>last()</code>. In all other cases,
	 * a linear search for the given element will be necessary.
	 *
	 * <P>Note that this method returns a bidirectional iterator, which, however, can be safely cast to 
	 * a type-specific list iterator.
	 *
	 * @param from an element to start from.
	 * @return a type-specific list iterator starting at the given element.
	 * @throws IllegalArgumentException if <code>from</code> does not belong to the set.
	 */
 public DoubleBidirectionalIterator iterator( double from ) {
  return new SetIterator( from );
 }
 public DoubleBidirectionalIterator iterator() {
  return new SetIterator();
 }
 /** A no-op for backward compatibility. The kind of tables implemented by
	 * this class never need rehashing.
	 *
	 * <P>If you need to reduce the table size to fit exactly
	 * this set, use {@link #trim()}.
	 *
	 * @return true.
	 * @see #trim()
	 * @deprecated A no-op.
	 */
 @Deprecated
 public boolean rehash() {
  return true;
 }
 /** Rehashes this set, making the table as small as possible.
	 * 
	 * <P>This method rehashes the table to the smallest size satisfying the
	 * load factor. It can be used when the set will not be changed anymore, so
	 * to optimize access speed and size.
	 *
	 * <P>If the table size is already the minimum possible, this method
	 * does nothing.
	 *
	 * @return true if there was enough memory to trim the set.
	 * @see #trim(int)
	 */
 public boolean trim() {
  final int l = arraySize( size, f );
  if ( l >= n ) return true;
  try {
   rehash( l );
  }
  catch(OutOfMemoryError cantDoIt) { return false; }
  return true;
 }
 /** Rehashes this set if the table is too large.
	 * 
	 * <P>Let <var>N</var> be the smallest table size that can hold
	 * <code>max(n,{@link #size()})</code> entries, still satisfying the load factor. If the current
	 * table size is smaller than or equal to <var>N</var>, this method does
	 * nothing. Otherwise, it rehashes this set in a table of size
	 * <var>N</var>.
	 *
	 * <P>This method is useful when reusing sets.  {@linkplain #clear() Clearing a
	 * set} leaves the table size untouched. If you are reusing a set
	 * many times, you can call this method with a typical
	 * size to avoid keeping around a very large table just
	 * because of a few large transient sets.
	 *
	 * @param n the threshold for the trimming.
	 * @return true if there was enough memory to trim the set.
	 * @see #trim()
	 */
 public boolean trim( final int n ) {
  final int l = HashCommon.nextPowerOfTwo( (int)Math.ceil( n / f ) );
  if ( this.n <= l ) return true;
  try {
   rehash( l );
  }
  catch( OutOfMemoryError cantDoIt ) { return false; }
  return true;
 }
 /** Resizes the set.
	 *
	 * <P>This method implements the basic rehashing strategy, and may be
	 * overriden by subclasses implementing different rehashing strategies (e.g.,
	 * disk-based rehashing). However, you should not override this method
	 * unless you understand the internal workings of this class.
	 *
	 * @param newN the new size
	 */
 @SuppressWarnings("unchecked")
 protected void rehash( final int newN ) {
  int i = first, prev = -1, newPrev = -1, t, pos;
  double k;
  final double key[] = this.key;
  final int newMask = newN - 1;
  final double newKey[] = new double[ newN ];
  final boolean newUsed[] = new boolean[ newN ];
  final int link[] = this.link;
  final int newLink[] = new int[ newN ];
  first = -1;
  for( int j = size; j-- != 0; ) {
   k = key[ i ];
   pos = (int)it.unimi.dsi.fastutil.HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & newMask;
   while ( newUsed[ pos ] ) pos = ( pos + 1 ) & newMask;
   newUsed[ pos ] = true;
   newKey[ pos ] = k;
   if ( prev != -1 ) {
    newLink[ newPrev ] ^= pos;
    newLink[ pos ] = newPrev;
    newPrev = pos;
   }
   else {
    newPrev = first = pos;
    newLink[ pos ] = -1;
   }
   t = i;
   i = link[ i ] ^ prev;
   prev = t;
  }
  n = newN;
  mask = newMask;
  maxFill = maxFill( n, f );
  this.key = newKey;
  this.used = newUsed;
  this.link = newLink;
  this.last = newPrev;
  if ( newPrev != -1 ) newLink[ newPrev ] ^= -1;
 }
 /** Returns a deep copy of this set. 
	 *
	 * <P>This method performs a deep copy of this hash set; the data stored in the
	 * set, however, is not cloned. Note that this makes a difference only for object keys.
	 *
	 *  @return a deep copy of this set.
	 */
 @SuppressWarnings("unchecked")
 public DoubleLinkedOpenHashSet clone() {
  DoubleLinkedOpenHashSet c;
  try {
   c = (DoubleLinkedOpenHashSet )super.clone();
  }
  catch(CloneNotSupportedException cantHappen) {
   throw new InternalError();
  }
  c.key = key.clone();
  c.used = used.clone();
  c.link = link.clone();
  return c;
 }
 /** Returns a hash code for this set.
	 *
	 * This method overrides the generic method provided by the superclass. 
	 * Since <code>equals()</code> is not overriden, it is important
	 * that the value returned by this method is the same value as
	 * the one returned by the overriden method.
	 *
	 * @return a hash code for this set.
	 */
 public int hashCode() {
  int h = 0, i = 0, j = size;
  while( j-- != 0 ) {
   while( ! used[ i ] ) i++;
    h += it.unimi.dsi.fastutil.HashCommon.double2int(key[ i ]);
   i++;
  }
  return h;
 }
 private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException {
  final DoubleIterator i = iterator();
  s.defaultWriteObject();
  for( int j = size; j-- != 0; ) s.writeDouble( i.nextDouble() );
 }
 @SuppressWarnings("unchecked")
 private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException {
  s.defaultReadObject();
  n = arraySize( size, f );
  maxFill = maxFill( n, f );
  mask = n - 1;
  final double key[] = this.key = new double[ n ];
  final boolean used[] = this.used = new boolean[ n ];
  final int link[] = this.link = new int[ n ];
  int prev = -1;
  first = last = -1;
  double k;
  for( int i = size, pos = 0; i-- != 0; ) {
   k = s.readDouble();
   pos = (int)it.unimi.dsi.fastutil.HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & mask;
   while ( used[ pos ] ) pos = ( pos + 1 ) & mask;
   used[ pos ] = true;
   key[ pos ] = k;
   if ( first != -1 ) {
    link[ prev ] ^= pos;
    link[ pos ] = prev;
    prev = pos;
   }
   else {
    prev = first = pos;
    link[ pos ] = -1;
   }
  }
  last = prev;
  if ( prev != -1 ) link[ prev ] ^= -1;
  if ( ASSERTS ) checkTable();
 }
 private void checkTable() {}
}
