/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.AbstractObject2IntMap;
import it.unimi.dsi.fastutil.objects.AbstractObject2IntSortedMap;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Object2IntLinkedOpenHashMap<K>
extends AbstractObject2IntSortedMap<K>
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient K[] key;
    protected transient int[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Object2IntSortedMap.FastSortedEntrySet<K> entries;
    protected volatile transient ObjectSortedSet<K> keys;
    protected volatile transient IntCollection values;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;

    public Object2IntLinkedOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new Object[this.n];
        this.value = new int[this.n];
        this.used = new boolean[this.n];
        this.link = new int[this.n];
    }

    public Object2IntLinkedOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Object2IntLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Object2IntLinkedOpenHashMap(Map<? extends K, ? extends Integer> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Object2IntLinkedOpenHashMap(Map<? extends K, ? extends Integer> m) {
        this(m, 0.75f);
    }

    public Object2IntLinkedOpenHashMap(Object2IntMap<K> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Object2IntLinkedOpenHashMap(Object2IntMap<K> m) {
        this(m, 0.75f);
    }

    public Object2IntLinkedOpenHashMap(K[] k, int[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Object2IntLinkedOpenHashMap(K[] k, int[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public int put(K k, int v) {
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & this.mask;
        while (this.used[pos]) {
            if (k == null ? this.key[pos] == null : k.equals(this.key[pos])) {
                int oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Integer put(K ok, Integer ov) {
        int v = ov;
        K k = ok;
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & this.mask;
        while (this.used[pos]) {
            if (k == null ? this.key[pos] == null : k.equals(this.key[pos])) {
                Integer oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return null;
    }

    public int add(K k, int incr) {
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & this.mask;
        while (this.used[pos]) {
            if (k == null ? this.key[pos] == null : k.equals(this.key[pos])) {
                int oldValue = this.value[pos];
                int n = pos;
                this.value[n] = this.value[n] + incr;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = this.defRetValue + incr;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    protected final void shiftKeys(int pos) {
        while (true) {
            int last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = (this.key[pos] == null ? 142593372 : HashCommon.murmurHash3(this.key[pos].hashCode())) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
            this.fixPointers(pos, last);
        }
        this.used[last] = false;
        this.key[last] = null;
    }

    @Override
    public int removeInt(Object k) {
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & this.mask;
        while (this.used[pos]) {
            if (k == null ? this.key[pos] == null : k.equals(this.key[pos])) {
                --this.size;
                this.fixPointers(pos);
                int v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public Integer remove(Object ok) {
        Object k = ok;
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & this.mask;
        while (this.used[pos]) {
            if (k == null ? this.key[pos] == null : k.equals(this.key[pos])) {
                --this.size;
                this.fixPointers(pos);
                int v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    @Override
    public int getInt(Object k) {
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & this.mask;
        while (this.used[pos]) {
            if (k == null ? this.key[pos] == null : k.equals(this.key[pos])) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(Object k) {
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & this.mask;
        while (this.used[pos]) {
            if (k == null ? this.key[pos] == null : k.equals(this.key[pos])) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(int v) {
        int[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        ObjectArrays.fill(this.key, null);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    protected void fixPointers(int i) {
        int next;
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    protected void fixPointers(int s, int d) {
        int next;
        if (this.size == 1) {
            this.first = this.last = d;
            this.link[d] = 0;
            return;
        }
        if (this.first == s) {
            this.first = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        if (this.last == s) {
            this.last = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != s) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (s ^ d);
        int n2 = this.link[s] ^ j;
        this.link[n2] = this.link[n2] ^ (s ^ d);
        this.link[d] = this.link[s];
    }

    @Override
    public K firstKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public K lastKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public Comparator<? super K> comparator() {
        return null;
    }

    @Override
    public Object2IntSortedMap<K> tailMap(K from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object2IntSortedMap<K> headMap(K to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object2IntSortedMap<K> subMap(K from, K to) {
        throw new UnsupportedOperationException();
    }

    public Object2IntSortedMap.FastSortedEntrySet<K> object2IntEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public ObjectSortedSet<K> keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public IntCollection values() {
        if (this.values == null) {
            this.values = new AbstractIntCollection(){

                @Override
                public IntIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Object2IntLinkedOpenHashMap.this.size;
                }

                @Override
                public boolean contains(int v) {
                    return Object2IntLinkedOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Object2IntLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = this.first;
        int prev = -1;
        int newPrev = -1;
        K[] key = this.key;
        int[] value = this.value;
        int newMask = newN - 1;
        Object[] newKey = new Object[newN];
        int[] newValue = new int[newN];
        boolean[] newUsed = new boolean[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        int j = this.size;
        while (j-- != 0) {
            K k = key[i];
            int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            if (prev != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ pos;
                newLink[pos] = newPrev;
                newPrev = pos;
            } else {
                newPrev = this.first = pos;
                newLink[pos] = -1;
            }
            int t = i;
            i = link[i] ^ prev;
            prev = t;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    public Object2IntLinkedOpenHashMap<K> clone() {
        Object2IntLinkedOpenHashMap c;
        try {
            c = (Object2IntLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (Object[])this.key.clone();
        c.value = (int[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            if (this != this.key[i]) {
                t = this.key[i] == null ? 0 : this.key[i].hashCode();
            }
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        K[] key = this.key;
        int[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeObject(key[e]);
            s.writeInt(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new Object[this.n];
        Object[] key = this.key;
        this.value = new int[this.n];
        int[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        this.link = new int[this.n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            Object k = s.readObject();
            int v = s.readInt();
            pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
            if (this.first != -1) {
                int n = prev;
                link[n] = link[n] ^ pos;
                link[pos] = prev;
                prev = pos;
                continue;
            }
            prev = this.first = pos;
            link[pos] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n = prev;
            link[n] = ~link[n];
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements IntListIterator {
        @Override
        public int previousInt() {
            return Object2IntLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public Integer previous() {
            return Object2IntLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public void set(Integer ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Integer ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int nextInt() {
            return Object2IntLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Integer next() {
            return Object2IntLinkedOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractObjectSortedSet<K> {
        private KeySet() {
        }

        @Override
        public ObjectBidirectionalIterator<K> iterator(K from) {
            return new KeyIterator(from);
        }

        @Override
        public ObjectBidirectionalIterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Object2IntLinkedOpenHashMap.this.size;
        }

        @Override
        public boolean contains(Object k) {
            return Object2IntLinkedOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(Object k) {
            int oldSize = Object2IntLinkedOpenHashMap.this.size;
            Object2IntLinkedOpenHashMap.this.remove(k);
            return Object2IntLinkedOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Object2IntLinkedOpenHashMap.this.clear();
        }

        @Override
        public K first() {
            if (Object2IntLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Object2IntLinkedOpenHashMap.this.key[Object2IntLinkedOpenHashMap.this.first];
        }

        @Override
        public K last() {
            if (Object2IntLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Object2IntLinkedOpenHashMap.this.key[Object2IntLinkedOpenHashMap.this.last];
        }

        @Override
        public Comparator<? super K> comparator() {
            return null;
        }

        @Override
        public final ObjectSortedSet<K> tailSet(K from) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ObjectSortedSet<K> headSet(K to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ObjectSortedSet<K> subSet(K from, K to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ObjectListIterator<K> {
        public KeyIterator(K k) {
            super(k);
        }

        @Override
        public K previous() {
            return Object2IntLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(K k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(K k) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        @Override
        public K next() {
            return Object2IntLinkedOpenHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSortedSet<Object2IntMap.Entry<K>>
    implements Object2IntSortedMap.FastSortedEntrySet<K> {
        private MapEntrySet() {
        }

        @Override
        public ObjectBidirectionalIterator<Object2IntMap.Entry<K>> iterator() {
            return new EntryIterator();
        }

        @Override
        public Comparator<? super Object2IntMap.Entry<K>> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Object2IntMap.Entry<K>> subSet(Object2IntMap.Entry<K> fromElement, Object2IntMap.Entry<K> toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Object2IntMap.Entry<K>> headSet(Object2IntMap.Entry<K> toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Object2IntMap.Entry<K>> tailSet(Object2IntMap.Entry<K> fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object2IntMap.Entry<K> first() {
            if (Object2IntLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Object2IntLinkedOpenHashMap.this.first);
        }

        @Override
        public Object2IntMap.Entry<K> last() {
            if (Object2IntLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Object2IntLinkedOpenHashMap.this.last);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & Object2IntLinkedOpenHashMap.this.mask;
            while (Object2IntLinkedOpenHashMap.this.used[pos]) {
                if (k == null ? Object2IntLinkedOpenHashMap.this.key[pos] == null : k.equals(Object2IntLinkedOpenHashMap.this.key[pos])) {
                    return Object2IntLinkedOpenHashMap.this.value[pos] == (Integer)e.getValue();
                }
                pos = pos + 1 & Object2IntLinkedOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode())) & Object2IntLinkedOpenHashMap.this.mask;
            while (Object2IntLinkedOpenHashMap.this.used[pos]) {
                if (k == null ? Object2IntLinkedOpenHashMap.this.key[pos] == null : k.equals(Object2IntLinkedOpenHashMap.this.key[pos])) {
                    Object2IntLinkedOpenHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Object2IntLinkedOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Object2IntLinkedOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Object2IntLinkedOpenHashMap.this.clear();
        }

        @Override
        public ObjectBidirectionalIterator<Object2IntMap.Entry<K>> iterator(Object2IntMap.Entry<K> from) {
            return new EntryIterator(from.getKey());
        }

        @Override
        public ObjectBidirectionalIterator<Object2IntMap.Entry<K>> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Object2IntMap.Entry<K>> fastIterator(Object2IntMap.Entry<K> from) {
            return new FastEntryIterator(from.getKey());
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Object2IntMap.Entry<K>> {
        final AbstractObject2IntMap.BasicEntry<K> entry;

        public FastEntryIterator() {
            this.entry = new AbstractObject2IntMap.BasicEntry<Object>(null, 0);
        }

        public FastEntryIterator(K from) {
            super(from);
            this.entry = new AbstractObject2IntMap.BasicEntry<Object>(null, 0);
        }

        @Override
        public AbstractObject2IntMap.BasicEntry<K> next() {
            int e = this.nextEntry();
            this.entry.key = Object2IntLinkedOpenHashMap.this.key[e];
            this.entry.value = Object2IntLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public AbstractObject2IntMap.BasicEntry<K> previous() {
            int e = this.previousEntry();
            this.entry.key = Object2IntLinkedOpenHashMap.this.key[e];
            this.entry.value = Object2IntLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public void set(Object2IntMap.Entry<K> ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object2IntMap.Entry<K> ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Object2IntMap.Entry<K>> {
        public EntryIterator() {
        }

        public EntryIterator(K from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            return new MapEntry(this.nextEntry());
        }

        @Override
        public MapEntry previous() {
            return new MapEntry(this.previousEntry());
        }

        @Override
        public void set(Object2IntMap.Entry<K> ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object2IntMap.Entry<K> ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        private MapIterator() {
            this.next = Object2IntLinkedOpenHashMap.this.first;
        }

        private MapIterator(K from) {
            if (Object2IntLinkedOpenHashMap.this.key[Object2IntLinkedOpenHashMap.this.last] == null ? from == null : Object2IntLinkedOpenHashMap.this.key[Object2IntLinkedOpenHashMap.this.last].equals(from)) {
                this.prev = Object2IntLinkedOpenHashMap.this.last;
                this.index = Object2IntLinkedOpenHashMap.this.size;
            } else {
                int e;
                if (!Object2IntLinkedOpenHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Object2IntLinkedOpenHashMap.this.first;
                while (!(Object2IntLinkedOpenHashMap.this.key[e = this.nextEntry()] == null ? from == null : Object2IntLinkedOpenHashMap.this.key[e].equals(from))) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                return Object2IntLinkedOpenHashMap.this.size();
            }
            this.curr = this.next;
            this.next = Object2IntLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                return -1;
            }
            this.curr = this.prev;
            this.prev = Object2IntLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Object2IntLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Object2IntLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            }
            --Object2IntLinkedOpenHashMap.this.size;
            if (this.prev == -1) {
                Object2IntLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Object2IntLinkedOpenHashMap.this.link[n] = Object2IntLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Object2IntLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Object2IntLinkedOpenHashMap.this.link[n] = Object2IntLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            int pos = this.curr;
            while (true) {
                int last = pos;
                pos = last + 1 & Object2IntLinkedOpenHashMap.this.mask;
                while (Object2IntLinkedOpenHashMap.this.used[pos]) {
                    int slot = (Object2IntLinkedOpenHashMap.this.key[pos] == null ? 142593372 : HashCommon.murmurHash3(Object2IntLinkedOpenHashMap.this.key[pos].hashCode())) & Object2IntLinkedOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Object2IntLinkedOpenHashMap.this.mask;
                }
                if (!Object2IntLinkedOpenHashMap.this.used[pos]) break;
                Object2IntLinkedOpenHashMap.this.key[last] = Object2IntLinkedOpenHashMap.this.key[pos];
                Object2IntLinkedOpenHashMap.this.value[last] = Object2IntLinkedOpenHashMap.this.value[pos];
                if (this.next == pos) {
                    this.next = last;
                }
                if (this.prev == pos) {
                    this.prev = last;
                }
                Object2IntLinkedOpenHashMap.this.fixPointers(pos, last);
            }
            Object2IntLinkedOpenHashMap.this.used[last] = false;
            Object2IntLinkedOpenHashMap.this.key[last] = null;
            this.curr = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Object2IntMap.Entry<K>,
    Map.Entry<K, Integer> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public K getKey() {
            return Object2IntLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public Integer getValue() {
            return Object2IntLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public int getIntValue() {
            return Object2IntLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public int setValue(int v) {
            int oldValue = Object2IntLinkedOpenHashMap.this.value[this.index];
            Object2IntLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Integer setValue(Integer v) {
            return this.setValue((int)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (Object2IntLinkedOpenHashMap.this.key[this.index] == null ? e.getKey() == null : Object2IntLinkedOpenHashMap.this.key[this.index].equals(e.getKey())) && Object2IntLinkedOpenHashMap.this.value[this.index] == (Integer)e.getValue();
        }

        @Override
        public int hashCode() {
            return (Object2IntLinkedOpenHashMap.this.key[this.index] == null ? 0 : Object2IntLinkedOpenHashMap.this.key[this.index].hashCode()) ^ Object2IntLinkedOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Object2IntLinkedOpenHashMap.this.key[this.index] + "=>" + Object2IntLinkedOpenHashMap.this.value[this.index];
        }
    }
}

